/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.model.language;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import net.loomchild.maligna.model.ModelParseException;
import net.loomchild.maligna.model.language.LanguageModel;
import net.loomchild.maligna.model.language.MutableLanguageModel;

public class LanguageModelUtil {
    public static LanguageModel train(List<List<Integer>> segmentList) {
        MutableLanguageModel model = new MutableLanguageModel();
        for (List<Integer> segment : segmentList) {
            for (int wid : segment) {
                model.addWordOccurence(wid);
            }
        }
        model.normalize();
        return model;
    }

    public static LanguageModel parse(Reader reader) {
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(reader);
            MutableLanguageModel languageModel = new MutableLanguageModel();
            while ((line = bufferedReader.readLine()) != null) {
                String[] parts = line.split("\\s");
                if (parts.length == 2) {
                    int wid = Integer.parseInt(parts[0]);
                    int count = Integer.parseInt(parts[1]);
                    languageModel.addWordOccurence(wid, count);
                    continue;
                }
                if (parts.length == 0) continue;
                throw new ModelParseException("Bad number of line parts.");
            }
            languageModel.normalize();
            return languageModel;
        }
        catch (NumberFormatException e) {
            throw new ModelParseException("Part format error", e);
        }
        catch (IOException e) {
            throw new ModelParseException("IO error", e);
        }
    }
}

