/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2;

import java.util.Map;

public abstract class AbstractOptions {
    private final Map<String, String> options;

    public AbstractOptions(Map<String, String> options) {
        this.options = options;
    }

    public Map<String, String> getOptionsMap() {
        return this.options;
    }

    protected boolean getBoolean(String key, boolean defaultValue) {
        String value = this.options.get(key);
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        return defaultValue;
    }

    protected void setBoolean(String key, boolean value) {
        this.options.put(key, Boolean.toString(value));
    }

    protected String getString(String key, String defaultValue) {
        String value = this.options.get(key);
        return value != null ? value : defaultValue;
    }

    protected void setString(String key, String value) {
        this.options.put(key, value);
    }

    protected <T extends Enum<T>> T getEnum(Class<T> enumType, String key, T defaultValue) {
        String value = this.options.get(key);
        try {
            return Enum.valueOf(enumType, value);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    protected <T extends Enum<T>> void setEnum(String key, T value) {
        this.options.put(key, value.name());
    }
}

