/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.map;

import edu.berkeley.nlp.lm.array.LongArray;
import edu.berkeley.nlp.lm.collections.Iterators;
import edu.berkeley.nlp.lm.map.HashMap;
import edu.berkeley.nlp.lm.util.Annotations;
import edu.berkeley.nlp.lm.util.MurmurHash;
import java.io.Serializable;
import java.util.Iterator;

final class ExplicitWordHashMap
implements Serializable,
HashMap {
    private static final long serialVersionUID = 1L;
    @Annotations.PrintMemoryCount
    private final LongArray keys;
    private final long keysSize;
    private long numFilled = 0L;
    private static final int EMPTY_KEY = -1;

    public ExplicitWordHashMap(long capacity) {
        this.keys = LongArray.StaticMethods.newLongArray(Long.MAX_VALUE, capacity, capacity);
        this.keys.fill(-1L, capacity);
        this.keysSize = this.keys.size();
        this.numFilled = 0L;
    }

    @Override
    public long put(long key) {
        long hash = this.hash(key);
        if (hash < 0L) {
            return -1L;
        }
        long rangeStart = 0L;
        long rangeEnd = this.keysSize;
        long i = this.keys.linearSearch(key, 0L, rangeEnd, hash, -1L, true);
        if (this.keys.get(i) == -1L) {
            ++this.numFilled;
            if (this.numFilled >= this.keysSize) {
                throw new RuntimeException("Hash map is full with " + this.keysSize + " keys. Should never happen.");
            }
        }
        this.setKey(i, key);
        return i;
    }

    private void setKey(long index, long putKey) {
        this.keys.set(index, putKey);
    }

    @Override
    public final long getOffset(long key) {
        long hash = this.hash(key);
        if (hash < 0L) {
            return -1L;
        }
        long rangeStart = 0L;
        long rangeEnd = this.keysSize;
        long startIndex = hash;
        assert (startIndex >= 0L);
        assert (startIndex < rangeEnd);
        return this.keys.linearSearch(key, 0L, rangeEnd, startIndex, -1L, false);
    }

    @Override
    public long getCapacity() {
        return this.keysSize;
    }

    @Override
    public double getLoadFactor() {
        return (double)this.numFilled / (double)this.getCapacity();
    }

    public double getLoadFactor(int numAdditional) {
        return (double)(this.numFilled + (long)numAdditional) / (double)this.getCapacity();
    }

    private long hash(long key) {
        long hashed = MurmurHash.hashOneLong(key, 31);
        long hash1 = hashed;
        if (hash1 < 0L) {
            hash1 = -hash1;
        }
        long startOfRange = 0L;
        long numHashPositions = this.keysSize - 0L;
        if (numHashPositions == 0L) {
            return -1L;
        }
        return (hash1 %= numHashPositions) + 0L;
    }

    @Override
    public long getKey(long contextOffset) {
        return this.keys.get(contextOffset);
    }

    @Override
    public boolean isEmptyKey(long key) {
        return key == -1L;
    }

    @Override
    public long size() {
        return this.numFilled;
    }

    @Override
    public Iterable<Long> keys() {
        return Iterators.able(new KeyIterator(this.keys));
    }

    @Override
    public boolean hasContexts(int word) {
        return true;
    }

    public static class KeyIterator
    implements Iterator<Long> {
        private final LongArray keys;
        private long next;
        private final long end;

        public KeyIterator(LongArray keys) {
            this.keys = keys;
            this.end = keys.size();
            this.next = -1L;
            this.nextIndex();
        }

        @Override
        public boolean hasNext() {
            return this.end > 0L && this.next < this.end;
        }

        @Override
        public Long next() {
            long nextIndex = this.nextIndex();
            return nextIndex;
        }

        long nextIndex() {
            long curr = this.next;
            do {
                ++this.next;
            } while (this.next < this.end && this.keys != null && this.keys.get(this.next) == -1L);
            return curr;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

