/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.perforce;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.optional.perforce.P4Base;
import org.apache.tools.ant.taskdefs.optional.perforce.P4HandlerAdapter;

public class P4Change
extends P4Base {
    protected String emptyChangeList = null;
    protected String description = "AutoSubmit By Ant";

    public void execute() throws BuildException {
        if (this.emptyChangeList == null) {
            this.emptyChangeList = this.getEmptyChangeList();
        }
        final Project myProj = ((ProjectComponent)this).project;
        P4HandlerAdapter handler = new P4HandlerAdapter(){

            public void process(String line) {
                if (P4Change.this.util.match("/Change/", line)) {
                    line = P4Change.this.util.substitute("s/[^0-9]//g", line);
                    int changenumber = Integer.parseInt(line);
                    P4Change.this.log("Change Number is " + changenumber, 2);
                    myProj.setProperty("p4.change", "" + changenumber);
                } else if (P4Change.this.util.match("/error/", line)) {
                    throw new BuildException("Perforce Error, check client settings and/or server");
                }
            }
        };
        handler.setOutput(this.emptyChangeList);
        this.execP4Command("change -i", handler);
    }

    public String getEmptyChangeList() throws BuildException {
        final StringBuffer stringbuf = new StringBuffer();
        this.execP4Command("change -o", new P4HandlerAdapter(){

            public void process(String line) {
                if (!P4Change.this.util.match("/^#/", line)) {
                    if (P4Change.this.util.match("/error/", line)) {
                        P4Change.this.log("Client Error", 3);
                        throw new BuildException("Perforce Error, check client settings and/or server");
                    }
                    if (P4Change.this.util.match("/<enter description here>/", line)) {
                        P4Change.this.description = P4Change.backslash(P4Change.this.description);
                        line = P4Change.this.util.substitute("s/<enter description here>/" + P4Change.this.description + "/", line);
                    } else if (P4Change.this.util.match("/\\/\\//", line)) {
                        return;
                    }
                    stringbuf.append(line);
                    stringbuf.append("\n");
                }
            }
        });
        return stringbuf.toString();
    }

    public static final String backslash(String value) {
        StringBuffer buf = new StringBuffer(value.length());
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '/') {
                buf.append('\\');
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public void setDescription(String desc) {
        this.description = desc;
    }
}

