/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.compress;

import com.google.common.base.Function;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.DataOutputStreamPlus;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamWriter;
import org.apache.cassandra.streaming.compress.CompressionInfo;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressedStreamWriter
extends StreamWriter {
    public static final int CHUNK_SIZE = 0xA00000;
    private static final Logger logger = LoggerFactory.getLogger(CompressedStreamWriter.class);
    private final CompressionInfo compressionInfo;

    public CompressedStreamWriter(SSTableReader sstable, Collection<Pair<Long, Long>> sections, CompressionInfo compressionInfo, StreamSession session) {
        super(sstable, sections, session);
        this.compressionInfo = compressionInfo;
    }

    @Override
    public void write(DataOutputStreamPlus out) throws IOException {
        long totalSize = this.totalSize();
        logger.debug("[Stream #{}] Start streaming file {} to {}, repairedAt = {}, totalSize = {}", new Object[]{this.session.planId(), this.sstable.getFilename(), this.session.peer, this.sstable.getSSTableMetadata().repairedAt, totalSize});
        try (RandomAccessReader file = this.sstable.openDataReader();
             final ChannelProxy fc = file.getChannel();){
            long progress = 0L;
            List<Pair<Long, Long>> sections = this.getTransferSections(this.compressionInfo.chunks);
            int sectionIdx = 0;
            for (final Pair<Long, Long> section : sections) {
                long lastWrite;
                long length = (Long)section.right - (Long)section.left;
                logger.trace("[Stream #{}] Writing section {} with length {} to stream.", new Object[]{this.session.planId(), sectionIdx++, length});
                for (long bytesTransferred = 0L; bytesTransferred < length; bytesTransferred += lastWrite) {
                    final long bytesTransferredFinal = bytesTransferred;
                    final int toTransfer = (int)Math.min(0xA00000L, length - bytesTransferred);
                    this.limiter.acquire(toTransfer);
                    lastWrite = out.applyToChannel(new Function<WritableByteChannel, Long>(){

                        public Long apply(WritableByteChannel wbc) {
                            return fc.transferTo((Long)section.left + bytesTransferredFinal, toTransfer, wbc);
                        }
                    });
                    this.session.progress(this.sstable.descriptor, ProgressInfo.Direction.OUT, progress += lastWrite, totalSize);
                }
            }
            logger.debug("[Stream #{}] Finished streaming file {} to {}, bytesTransferred = {}, totalSize = {}", new Object[]{this.session.planId(), this.sstable.getFilename(), this.session.peer, progress, totalSize});
        }
    }

    @Override
    protected long totalSize() {
        long size = 0L;
        for (CompressionMetadata.Chunk chunk : this.compressionInfo.chunks) {
            size += (long)(chunk.length + 4);
        }
        return size;
    }

    private List<Pair<Long, Long>> getTransferSections(CompressionMetadata.Chunk[] chunks) {
        ArrayList<Pair<Long, Long>> transferSections = new ArrayList<Pair<Long, Long>>();
        Pair<Long, Long> lastSection = null;
        for (CompressionMetadata.Chunk chunk : chunks) {
            if (lastSection != null) {
                if (chunk.offset == (Long)lastSection.right) {
                    lastSection = Pair.create(lastSection.left, chunk.offset + (long)chunk.length + 4L);
                    continue;
                }
                transferSections.add(lastSection);
                lastSection = Pair.create(chunk.offset, chunk.offset + (long)chunk.length + 4L);
                continue;
            }
            lastSection = Pair.create(chunk.offset, chunk.offset + (long)chunk.length + 4L);
        }
        if (lastSection != null) {
            transferSections.add(lastSection);
        }
        return transferSections;
    }
}

