/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolver;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;

public final class SourceResolver
implements EventResolver {
    private static final EventResolver NULL_RESOLVER = (value, jsonWriter) -> jsonWriter.writeNull();
    private static final EventResolver CLASS_NAME_RESOLVER = (logEvent, jsonWriter) -> {
        StackTraceElement logEventSource = logEvent.getSource();
        if (logEventSource == null) {
            jsonWriter.writeNull();
        } else {
            String sourceClassName = logEventSource.getClassName();
            jsonWriter.writeString(sourceClassName);
        }
    };
    private static final EventResolver FILE_NAME_RESOLVER = (logEvent, jsonWriter) -> {
        StackTraceElement logEventSource = logEvent.getSource();
        if (logEventSource == null) {
            jsonWriter.writeNull();
        } else {
            String sourceFileName = logEventSource.getFileName();
            jsonWriter.writeString(sourceFileName);
        }
    };
    private static final EventResolver LINE_NUMBER_RESOLVER = (logEvent, jsonWriter) -> {
        StackTraceElement logEventSource = logEvent.getSource();
        if (logEventSource == null) {
            jsonWriter.writeNull();
        } else {
            int sourceLineNumber = logEventSource.getLineNumber();
            jsonWriter.writeNumber(sourceLineNumber);
        }
    };
    private static final EventResolver METHOD_NAME_RESOLVER = (logEvent, jsonWriter) -> {
        StackTraceElement logEventSource = logEvent.getSource();
        if (logEventSource == null) {
            jsonWriter.writeNull();
        } else {
            String sourceMethodName = logEventSource.getMethodName();
            jsonWriter.writeString(sourceMethodName);
        }
    };
    private final boolean locationInfoEnabled;
    private final EventResolver internalResolver;

    SourceResolver(EventResolverContext context, TemplateResolverConfig config) {
        this.locationInfoEnabled = context.isLocationInfoEnabled();
        this.internalResolver = SourceResolver.createInternalResolver(context, config);
    }

    private static EventResolver createInternalResolver(EventResolverContext context, TemplateResolverConfig config) {
        if (!context.isLocationInfoEnabled()) {
            return NULL_RESOLVER;
        }
        String fieldName = config.getString("field");
        if ("className".equals(fieldName)) {
            return CLASS_NAME_RESOLVER;
        }
        if ("fileName".equals(fieldName)) {
            return FILE_NAME_RESOLVER;
        }
        if ("lineNumber".equals(fieldName)) {
            return LINE_NUMBER_RESOLVER;
        }
        if ("methodName".equals(fieldName)) {
            return METHOD_NAME_RESOLVER;
        }
        throw new IllegalArgumentException("unknown field: " + config);
    }

    static String getName() {
        return "source";
    }

    @Override
    public boolean isResolvable() {
        return this.locationInfoEnabled;
    }

    @Override
    public boolean isResolvable(LogEvent logEvent) {
        return this.locationInfoEnabled && logEvent.getSource() != null;
    }

    @Override
    public void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
        this.internalResolver.resolve(logEvent, jsonWriter);
    }
}

