/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import java.util.function.UnaryOperator;
import org.apache.solr.analytics.function.ReductionFunction;
import org.apache.solr.analytics.function.reduction.PercentileFunction;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.function.reduction.data.SortedListCollector;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.LongValueStream;

class DatePercentileFunction
extends DateValue.AbstractDateValue
implements ReductionFunction {
    private SortedListCollector.SortedLongListCollector collector;
    private double percentile;
    public static final String name = "percentile";
    private final String exprStr;

    public DatePercentileFunction(LongValueStream param, double percentile) {
        this.collector = new SortedListCollector.SortedLongListCollector(param);
        this.percentile = percentile;
        this.exprStr = PercentileFunction.createPercentileExpressionString(param, percentile);
    }

    @Override
    public long getLong() {
        int size = this.collector.size();
        return size > 0 ? (Long)this.collector.get((int)Math.round(this.percentile * (double)size - 0.5)) : 0L;
    }

    @Override
    public boolean exists() {
        return this.collector.size() > 0;
    }

    @Override
    public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
        this.collector = (SortedListCollector.SortedLongListCollector)sync.apply(this.collector);
        this.collector.calcPercentile(this.percentile);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return AnalyticsValueStream.ExpressionType.REDUCTION;
    }
}

