/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DistanceUnits {
    public static final String KILOMETERS_PARAM = "kilometers";
    public static final String MILES_PARAM = "miles";
    public static final String DEGREES_PARAM = "degrees";
    public static final DistanceUnits KILOMETERS = new DistanceUnits("kilometers", 6371.0087714, 0.008993203677616635);
    public static final DistanceUnits MILES = new DistanceUnits("miles", 3958.7613145272735, 0.014473158384878317);
    public static final DistanceUnits DEGREES = new DistanceUnits("degrees", 57.29577951308232, 1.0);
    private static volatile Map<String, DistanceUnits> instances = ImmutableMap.of((Object)"kilometers", (Object)KILOMETERS, (Object)"miles", (Object)MILES, (Object)"degrees", (Object)DEGREES);
    private final String stringIdentifier;
    private final double earthRadius;
    private final double multiplierThisToDegrees;
    private final double multiplierDegreesToThis;

    private DistanceUnits(String str, double earthRadius, double multiplierThisToDegrees) {
        this.stringIdentifier = str;
        this.earthRadius = earthRadius;
        this.multiplierThisToDegrees = multiplierThisToDegrees;
        this.multiplierDegreesToThis = 1.0 / multiplierThisToDegrees;
    }

    public static DistanceUnits valueOf(String str) {
        return instances.get(str);
    }

    public static Set<String> getSupportedUnits() {
        return instances.keySet();
    }

    public double getEarthRadius() {
        return this.earthRadius;
    }

    public double multiplierFromThisUnitToDegrees() {
        return this.multiplierThisToDegrees;
    }

    public double multiplierFromDegreesToThisUnit() {
        return this.multiplierDegreesToThis;
    }

    public String getStringIdentifier() {
        return this.stringIdentifier;
    }

    public static synchronized void addUnits(String strId, double earthRadius, double multiplierThisToDegrees) {
        HashMap<String, DistanceUnits> map = new HashMap<String, DistanceUnits>(instances);
        map.put(strId, new DistanceUnits(strId, earthRadius, multiplierThisToDegrees));
        instances = ImmutableMap.copyOf(map);
    }

    public String toString() {
        return this.getStringIdentifier();
    }
}

