/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging;

import com.drew.imaging.FileType;
import com.drew.imaging.TypeChecker;
import com.drew.imaging.mp3.MpegAudioTypeChecker;
import com.drew.imaging.quicktime.QuickTimeTypeChecker;
import com.drew.imaging.riff.RiffTypeChecker;
import com.drew.lang.ByteTrie;
import com.drew.lang.annotations.NotNull;
import java.io.FilterInputStream;
import java.io.IOException;

public class FileTypeDetector {
    private static final ByteTrie<FileType> _root;
    private static final TypeChecker[] _fixedCheckers;
    private static final int _bytesNeeded;

    private FileTypeDetector() throws Exception {
        throw new Exception("Not intended for instantiation");
    }

    @NotNull
    public static FileType detectFileType(@NotNull FilterInputStream inputStream) throws IOException {
        int bytesRead;
        if (!inputStream.markSupported()) {
            throw new IOException("Stream must support mark/reset");
        }
        inputStream.mark(_bytesNeeded);
        byte[] bytes = new byte[_bytesNeeded];
        int offset = 0;
        int count = _bytesNeeded;
        while (count != 0 && (bytesRead = inputStream.read(bytes, offset, count)) != -1) {
            count -= bytesRead;
            offset += bytesRead;
        }
        inputStream.reset();
        FileType fileType = _root.find(bytes, 0, offset);
        assert (fileType != null);
        if (fileType == FileType.Unknown) {
            for (TypeChecker checker : _fixedCheckers) {
                fileType = checker.checkType(bytes);
                if (fileType == FileType.Unknown) continue;
                return fileType;
            }
        }
        return fileType;
    }

    static {
        _fixedCheckers = new TypeChecker[]{new QuickTimeTypeChecker(), new RiffTypeChecker(), new MpegAudioTypeChecker()};
        _root = new ByteTrie();
        _root.setDefaultValue(FileType.Unknown);
        _root.addPath(FileType.Jpeg, new byte[][]{{-1, -40}});
        _root.addPath(FileType.Tiff, "II".getBytes(), {42, 0});
        _root.addPath(FileType.Tiff, "MM".getBytes(), {0, 42});
        _root.addPath(FileType.Psd, new byte[][]{"8BPS".getBytes()});
        _root.addPath(FileType.Png, new byte[][]{{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82}});
        _root.addPath(FileType.Bmp, new byte[][]{"BM".getBytes()});
        _root.addPath(FileType.Bmp, new byte[][]{"BA".getBytes()});
        _root.addPath(FileType.Bmp, new byte[][]{"CI".getBytes()});
        _root.addPath(FileType.Bmp, new byte[][]{"CP".getBytes()});
        _root.addPath(FileType.Bmp, new byte[][]{"IC".getBytes()});
        _root.addPath(FileType.Bmp, new byte[][]{"PT".getBytes()});
        _root.addPath(FileType.Gif, new byte[][]{"GIF87a".getBytes()});
        _root.addPath(FileType.Gif, new byte[][]{"GIF89a".getBytes()});
        _root.addPath(FileType.Ico, new byte[][]{{0, 0, 1, 0}});
        _root.addPath(FileType.Pcx, new byte[][]{{10, 0, 1}});
        _root.addPath(FileType.Pcx, new byte[][]{{10, 2, 1}});
        _root.addPath(FileType.Pcx, new byte[][]{{10, 3, 1}});
        _root.addPath(FileType.Pcx, new byte[][]{{10, 5, 1}});
        _root.addPath(FileType.Arw, "II".getBytes(), {42, 0, 8, 0});
        _root.addPath(FileType.Crw, "II".getBytes(), {26, 0, 0, 0}, "HEAPCCDR".getBytes());
        _root.addPath(FileType.Cr2, "II".getBytes(), {42, 0, 16, 0, 0, 0, 67, 82});
        _root.addPath(FileType.Orf, "IIRO".getBytes(), {8, 0});
        _root.addPath(FileType.Orf, "MMOR".getBytes(), {0, 0});
        _root.addPath(FileType.Orf, "IIRS".getBytes(), {8, 0});
        _root.addPath(FileType.Raf, new byte[][]{"FUJIFILMCCD-RAW".getBytes()});
        _root.addPath(FileType.Rw2, "II".getBytes(), {85, 0});
        _root.addPath(FileType.Eps, new byte[][]{"%!PS".getBytes()});
        _root.addPath(FileType.Eps, new byte[][]{{-59, -48, -45, -58}});
        _root.addPath(FileType.Aac, new byte[][]{{-1, -15}});
        _root.addPath(FileType.Aac, new byte[][]{{-1, -7}});
        _root.addPath(FileType.Asf, new byte[][]{{48, 38, -78, 117, -114, 102, -49, 17, -90, -39, 0, -86, 0, 98, -50, 108}});
        _root.addPath(FileType.Cfbf, new byte[][]{{-48, -49, 17, -32, -95, -79, 26, -31, 0}});
        _root.addPath(FileType.Flv, new byte[][]{{70, 76, 86}});
        _root.addPath(FileType.Indd, new byte[][]{{6, 6, -19, -11, -40, 29, 70, -27, -67, 49, -17, -25, -2, 116, -73, 29}});
        _root.addPath(FileType.Mxf, new byte[][]{{6, 14, 43, 52, 2, 5, 1, 1, 13, 1, 2, 1, 1, 2}});
        _root.addPath(FileType.Qxp, new byte[][]{{0, 0, 73, 73, 88, 80, 82, 51}});
        _root.addPath(FileType.Qxp, new byte[][]{{0, 0, 77, 77, 88, 80, 82, 51}});
        _root.addPath(FileType.Ram, new byte[][]{{114, 116, 115, 112, 58, 47, 47}});
        _root.addPath(FileType.Rtf, new byte[][]{{123, 92, 114, 116, 102, 49}});
        _root.addPath(FileType.Sit, new byte[][]{{83, 73, 84, 33, 0}});
        _root.addPath(FileType.Sit, new byte[][]{{83, 116, 117, 102, 102, 73, 116, 32, 40, 99, 41, 49, 57, 57, 55, 45}});
        _root.addPath(FileType.Sitx, new byte[][]{{83, 116, 117, 102, 102, 73, 116, 33}});
        _root.addPath(FileType.Swf, new byte[][]{"CWS".getBytes()});
        _root.addPath(FileType.Swf, new byte[][]{"FWS".getBytes()});
        _root.addPath(FileType.Swf, new byte[][]{"ZWS".getBytes()});
        _root.addPath(FileType.Vob, new byte[][]{{0, 0, 1, -70}});
        _root.addPath(FileType.Zip, new byte[][]{"PK".getBytes()});
        int bytesNeeded = _root.getMaxDepth();
        for (TypeChecker fixedChecker : _fixedCheckers) {
            if (fixedChecker.getByteCount() <= bytesNeeded) continue;
            bytesNeeded = fixedChecker.getByteCount();
        }
        _bytesNeeded = bytesNeeded;
    }
}

