/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.util.Base64;
import org.apache.solr.schema.PreAnalyzedField;
import org.noggit.JSONUtil;
import org.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPreAnalyzedParser
implements PreAnalyzedField.PreAnalyzedParser {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String VERSION = "1";
    public static final String VERSION_KEY = "v";
    public static final String STRING_KEY = "str";
    public static final String BINARY_KEY = "bin";
    public static final String TOKENS_KEY = "tokens";
    public static final String TOKEN_KEY = "t";
    public static final String OFFSET_START_KEY = "s";
    public static final String OFFSET_END_KEY = "e";
    public static final String POSINCR_KEY = "i";
    public static final String PAYLOAD_KEY = "p";
    public static final String TYPE_KEY = "y";
    public static final String FLAGS_KEY = "f";

    @Override
    public PreAnalyzedField.ParseResult parse(Reader reader, AttributeSource parent) throws IOException {
        List tokens;
        int cnt;
        PreAnalyzedField.ParseResult res = new PreAnalyzedField.ParseResult();
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[128];
        while ((cnt = reader.read(buf)) > 0) {
            sb.append(buf, 0, cnt);
        }
        String val = sb.toString();
        if (val.length() == 0) {
            return res;
        }
        Object o = ObjectBuilder.fromJSONStrict((String)val);
        if (!(o instanceof Map)) {
            throw new IOException("Invalid JSON type " + o.getClass().getName() + ", expected Map");
        }
        Map map = (Map)o;
        String version = (String)map.get(VERSION_KEY);
        if (version == null) {
            throw new IOException("Missing VERSION key");
        }
        if (!VERSION.equals(version)) {
            throw new IOException("Unknown VERSION '" + version + "', expected " + VERSION);
        }
        if (map.containsKey(STRING_KEY) && map.containsKey(BINARY_KEY)) {
            throw new IOException("Field cannot have both stringValue and binaryValue");
        }
        res.str = (String)map.get(STRING_KEY);
        String bin = (String)map.get(BINARY_KEY);
        if (bin != null) {
            byte[] data = Base64.base64ToByteArray((String)bin);
            res.bin = data;
        }
        if ((tokens = (List)map.get(TOKENS_KEY)) == null) {
            return res;
        }
        int tokenStart = 0;
        int tokenEnd = 0;
        parent.clearAttributes();
        for (Object ot : tokens) {
            tokenStart = tokenEnd + 1;
            Map tok = (Map)ot;
            boolean hasOffsetStart = false;
            boolean hasOffsetEnd = false;
            int len = -1;
            for (Map.Entry e : tok.entrySet()) {
                String key = (String)e.getKey();
                if (key.equals(TOKEN_KEY)) {
                    CharTermAttribute catt = (CharTermAttribute)parent.addAttribute(CharTermAttribute.class);
                    String str = String.valueOf(e.getValue());
                    catt.append(str);
                    len = str.length();
                    continue;
                }
                if (key.equals(OFFSET_START_KEY)) {
                    Object obj = e.getValue();
                    hasOffsetStart = true;
                    if (obj instanceof Number) {
                        tokenStart = ((Number)obj).intValue();
                        continue;
                    }
                    try {
                        tokenStart = Integer.parseInt(String.valueOf(obj));
                    }
                    catch (NumberFormatException nfe) {
                        log.warn("Invalid {} attribute, skipped: '{}'", (Object)OFFSET_START_KEY, obj);
                        hasOffsetStart = false;
                    }
                    continue;
                }
                if (key.equals(OFFSET_END_KEY)) {
                    hasOffsetEnd = true;
                    Object obj = e.getValue();
                    if (obj instanceof Number) {
                        tokenEnd = ((Number)obj).intValue();
                        continue;
                    }
                    try {
                        tokenEnd = Integer.parseInt(String.valueOf(obj));
                    }
                    catch (NumberFormatException nfe) {
                        log.warn("Invalid {} attribute, skipped: '{}'", (Object)OFFSET_END_KEY, obj);
                        hasOffsetEnd = false;
                    }
                    continue;
                }
                if (key.equals(POSINCR_KEY)) {
                    Object obj = e.getValue();
                    int posIncr = 1;
                    if (obj instanceof Number) {
                        posIncr = ((Number)obj).intValue();
                    } else {
                        try {
                            posIncr = Integer.parseInt(String.valueOf(obj));
                        }
                        catch (NumberFormatException nfe) {
                            log.warn("Invalid {} attribute, skipped: '{}'", (Object)POSINCR_KEY, obj);
                        }
                    }
                    PositionIncrementAttribute patt = (PositionIncrementAttribute)parent.addAttribute(PositionIncrementAttribute.class);
                    patt.setPositionIncrement(posIncr);
                    continue;
                }
                if (key.equals(PAYLOAD_KEY)) {
                    String str = String.valueOf(e.getValue());
                    if (str.length() <= 0) continue;
                    byte[] data = Base64.base64ToByteArray((String)str);
                    PayloadAttribute p = (PayloadAttribute)parent.addAttribute(PayloadAttribute.class);
                    if (data == null || data.length <= 0) continue;
                    p.setPayload(new BytesRef(data));
                    continue;
                }
                if (key.equals(FLAGS_KEY)) {
                    try {
                        int f = Integer.parseInt(String.valueOf(e.getValue()), 16);
                        FlagsAttribute flags = (FlagsAttribute)parent.addAttribute(FlagsAttribute.class);
                        flags.setFlags(f);
                    }
                    catch (NumberFormatException nfe) {
                        log.warn("Invalid {} attribute, skipped: '{}'", (Object)FLAGS_KEY, e.getValue());
                    }
                    continue;
                }
                if (key.equals(TYPE_KEY)) {
                    TypeAttribute tattr = (TypeAttribute)parent.addAttribute(TypeAttribute.class);
                    tattr.setType(String.valueOf(e.getValue()));
                    continue;
                }
                log.warn("Unknown attribute, skipped: {} = {}", e.getKey(), e.getValue());
            }
            OffsetAttribute offset = (OffsetAttribute)parent.addAttribute(OffsetAttribute.class);
            if (!hasOffsetEnd && len > -1) {
                tokenEnd = tokenStart + len;
            }
            offset.setOffset(tokenStart, tokenEnd);
            if (!hasOffsetStart) {
                tokenStart = tokenEnd + 1;
            }
            AttributeSource.State state = parent.captureState();
            res.states.add(state.clone());
            parent.clearAttributes();
        }
        return res;
    }

    @Override
    public String toFormattedString(Field f) throws IOException {
        TokenStream ts;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(VERSION_KEY, VERSION);
        if (f.fieldType().stored()) {
            BytesRef binaryValue;
            String stringValue = f.stringValue();
            if (stringValue != null) {
                map.put(STRING_KEY, stringValue);
            }
            if ((binaryValue = f.binaryValue()) != null) {
                map.put(BINARY_KEY, Base64.byteArrayToBase64((byte[])binaryValue.bytes, (int)binaryValue.offset, (int)binaryValue.length));
            }
        }
        if ((ts = f.tokenStreamValue()) != null) {
            LinkedList tokens = new LinkedList();
            while (ts.incrementToken()) {
                Iterator it = ts.getAttributeClassesIterator();
                String cTerm = null;
                String tTerm = null;
                TreeMap<String, Object> tok = new TreeMap<String, Object>();
                while (it.hasNext()) {
                    Class cl = (Class)it.next();
                    Attribute att = ts.getAttribute(cl);
                    if (att == null) continue;
                    if (cl.isAssignableFrom(CharTermAttribute.class)) {
                        CharTermAttribute catt = (CharTermAttribute)att;
                        cTerm = new String(catt.buffer(), 0, catt.length());
                        continue;
                    }
                    if (cl.isAssignableFrom(TermToBytesRefAttribute.class)) {
                        TermToBytesRefAttribute tatt = (TermToBytesRefAttribute)att;
                        tTerm = tatt.getBytesRef().utf8ToString();
                        continue;
                    }
                    if (cl.isAssignableFrom(FlagsAttribute.class)) {
                        tok.put(FLAGS_KEY, Integer.toHexString(((FlagsAttribute)att).getFlags()));
                        continue;
                    }
                    if (cl.isAssignableFrom(OffsetAttribute.class)) {
                        tok.put(OFFSET_START_KEY, ((OffsetAttribute)att).startOffset());
                        tok.put(OFFSET_END_KEY, ((OffsetAttribute)att).endOffset());
                        continue;
                    }
                    if (cl.isAssignableFrom(PayloadAttribute.class)) {
                        BytesRef p = ((PayloadAttribute)att).getPayload();
                        if (p == null || p.length <= 0) continue;
                        tok.put(PAYLOAD_KEY, Base64.byteArrayToBase64((byte[])p.bytes, (int)p.offset, (int)p.length));
                        continue;
                    }
                    if (cl.isAssignableFrom(PositionIncrementAttribute.class)) {
                        tok.put(POSINCR_KEY, ((PositionIncrementAttribute)att).getPositionIncrement());
                        continue;
                    }
                    if (cl.isAssignableFrom(TypeAttribute.class)) {
                        tok.put(TYPE_KEY, ((TypeAttribute)att).type());
                        continue;
                    }
                    tok.put(cl.getName(), att.toString());
                }
                String term = null;
                term = cTerm != null ? cTerm : tTerm;
                if (term != null && term.length() > 0) {
                    tok.put(TOKEN_KEY, term);
                }
                tokens.add(tok);
            }
            map.put(TOKENS_KEY, tokens);
        }
        return JSONUtil.toJSON(map, (int)-1);
    }
}

