/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.openwire;

import org.apache.activemq.apollo.broker.BufferConversions$;
import org.apache.activemq.apollo.broker.Message;
import org.apache.activemq.apollo.broker.Sizer;
import org.apache.activemq.apollo.broker.store.MessageRecord;
import org.apache.activemq.apollo.openwire.CachedEncoding;
import org.apache.activemq.apollo.openwire.OpenwireConstants$;
import org.apache.activemq.apollo.openwire.OpenwireMessage;
import org.apache.activemq.apollo.openwire.codec.OpenWireFormat;
import org.apache.activemq.apollo.openwire.command.ActiveMQMessage;
import org.apache.activemq.apollo.openwire.command.CachedEncodingTrait;
import org.apache.activemq.apollo.openwire.command.Command;
import org.fusesource.hawtbuf.AbstractVarIntSupport;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import scala.ScalaObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OpenwireCodec$
implements Sizer<Command>,
ScalaObject {
    public static final OpenwireCodec$ MODULE$;
    private final int DB_VERSION;
    private final boolean DB_TIGHT_ENCODING;

    static {
        new OpenwireCodec$();
    }

    public final int DB_VERSION() {
        return this.DB_VERSION;
    }

    public final boolean DB_TIGHT_ENCODING() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public MessageRecord encode(Message message) {
        void var2_2;
        Buffer buffer;
        MessageRecord rc = new MessageRecord();
        rc.protocol_$eq(BufferConversions$.MODULE$.toAsciiBuffer(OpenwireConstants$.MODULE$.PROTOCOL()));
        OpenwireMessage msg = (OpenwireMessage)message;
        CachedEncodingTrait cachedEncodingTrait = msg.message().getCachedEncoding();
        if (cachedEncodingTrait instanceof CachedEncoding) {
            CachedEncoding cachedEncoding = (CachedEncoding)cachedEncodingTrait;
            int n = cachedEncoding.version();
            Buffer buffer2 = cachedEncoding.buffer();
            int version = n;
            Buffer buffer3 = buffer2;
            DataByteArrayOutputStream boas = new DataByteArrayOutputStream(1 + AbstractVarIntSupport.computeVarIntSize((int)version) + buffer3.length());
            boas.writeBoolean(cachedEncoding.tight());
            boas.writeVarInt(version);
            boas.write(buffer3);
            buffer = boas.toBuffer();
        } else {
            OpenWireFormat db_format = new OpenWireFormat();
            db_format.setCacheEnabled(false);
            db_format.setTightEncodingEnabled(false);
            db_format.setVersion(this.DB_VERSION());
            int size = msg.message().getEncodedSize();
            DataByteArrayOutputStream boas = new DataByteArrayOutputStream(size == 0 ? 1024 : size + 20);
            boas.writeBoolean(false);
            boas.writeVarInt(this.DB_VERSION());
            db_format.marshal(msg.message(), boas);
            buffer = boas.toBuffer();
        }
        rc.buffer_$eq(buffer);
        return var2_2;
    }

    public OpenwireMessage decode(MessageRecord message) {
        Buffer buffer = message.buffer().buffer();
        DataByteArrayInputStream bais = new DataByteArrayInputStream(message.buffer());
        boolean tight = bais.readBoolean();
        int version = bais.readVarInt();
        buffer.moveHead(bais.getPos() - buffer.offset);
        OpenWireFormat db_format = new OpenWireFormat();
        db_format.setCacheEnabled(false);
        db_format.setTightEncodingEnabled(tight);
        db_format.setVersion(version);
        ActiveMQMessage msg = (ActiveMQMessage)db_format.unmarshal(bais);
        msg.setEncodedSize(buffer.length);
        msg.setCachedEncoding(new CachedEncoding(tight, version, buffer));
        return new OpenwireMessage(msg);
    }

    public int size(Command value) {
        Command command = value;
        return command instanceof ActiveMQMessage ? ((ActiveMQMessage)command).getSize() : 100;
    }

    private OpenwireCodec$() {
        MODULE$ = this;
        this.DB_VERSION = OpenWireFormat.DEFAULT_VERSION;
    }
}

