/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.openwire.codec.v5;

import java.io.IOException;
import org.apache.activemq.apollo.openwire.codec.BaseDataStreamMarshaller;
import org.apache.activemq.apollo.openwire.codec.BooleanStream;
import org.apache.activemq.apollo.openwire.codec.OpenWireFormat;
import org.apache.activemq.apollo.openwire.command.DataStructure;
import org.apache.activemq.apollo.openwire.command.DiscoveryEvent;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;

public class DiscoveryEventMarshaller
extends BaseDataStreamMarshaller {
    public byte getDataStructureType() {
        return 40;
    }

    public DataStructure createObject() {
        return new DiscoveryEvent();
    }

    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataByteArrayInputStream dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        DiscoveryEvent info = (DiscoveryEvent)o;
        info.setServiceName(this.tightUnmarshalString(dataIn, bs));
        info.setBrokerName(this.tightUnmarshalString(dataIn, bs));
    }

    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        DiscoveryEvent info = (DiscoveryEvent)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalString1(info.getServiceName(), bs);
        return (rc += this.tightMarshalString1(info.getBrokerName(), bs)) + 0;
    }

    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataByteArrayOutputStream dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        DiscoveryEvent info = (DiscoveryEvent)o;
        this.tightMarshalString2(info.getServiceName(), dataOut, bs);
        this.tightMarshalString2(info.getBrokerName(), dataOut, bs);
    }

    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataByteArrayInputStream dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        DiscoveryEvent info = (DiscoveryEvent)o;
        info.setServiceName(this.looseUnmarshalString(dataIn));
        info.setBrokerName(this.looseUnmarshalString(dataIn));
    }

    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataByteArrayOutputStream dataOut) throws IOException {
        DiscoveryEvent info = (DiscoveryEvent)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalString(info.getServiceName(), dataOut);
        this.looseMarshalString(info.getBrokerName(), dataOut);
    }
}

