/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import vcf.GT;
import vcf.Marker;
import vcf.Markers;
import vcf.RestrictedGT;
import vcf.Samples;

public final class SplicedGT
implements GT {
    private final int overlap;
    private final GT phasedGT;
    private final GT gt;

    public SplicedGT(GT gT, GT gT2) {
        if (gT.nMarkers() >= gT2.nMarkers()) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        int n = gT.nMarkers();
        for (int i = 0; i < n; ++i) {
            if (gT.marker(i).equals(gT2.marker(i))) continue;
            throw new IllegalArgumentException("inconsistent markers");
        }
        if (!gT.samples().equals(gT2.samples())) {
            throw new IllegalArgumentException("inconsistent samples");
        }
        this.overlap = gT.nMarkers();
        this.phasedGT = gT;
        this.gt = gT2;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public Marker marker(int n) {
        return this.gt.marker(n);
    }

    @Override
    public Markers markers() {
        return this.gt.markers();
    }

    @Override
    public int nMarkers() {
        return this.gt.nMarkers();
    }

    @Override
    public int nHaps() {
        return this.gt.nHaps();
    }

    @Override
    public int nSamples() {
        return this.gt.nSamples();
    }

    @Override
    public Samples samples() {
        return this.gt.samples();
    }

    @Override
    public boolean isPhased() {
        return this.gt.isPhased();
    }

    @Override
    public int allele1(int n, int n2) {
        if (n < this.overlap) {
            return this.phasedGT.allele1(n, n2);
        }
        return this.gt.allele1(n, n2);
    }

    @Override
    public int allele2(int n, int n2) {
        if (n < this.overlap) {
            return this.phasedGT.allele2(n, n2);
        }
        return this.gt.allele2(n, n2);
    }

    @Override
    public int allele(int n, int n2) {
        if (n < this.overlap) {
            return this.phasedGT.allele(n, n2);
        }
        return this.gt.allele(n, n2);
    }

    @Override
    public GT restrict(Markers markers, int[] nArray) {
        return new RestrictedGT(this, markers, nArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(10000);
        stringBuilder.append("SplicedGL: nSamples=");
        stringBuilder.append(this.nSamples());
        return stringBuilder.toString();
    }
}

