/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.sandbox.security.trust2;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class Lifetime
extends Timestamp {
    public Lifetime(WSSConfig wssConfig, Document doc, Element element) throws WSSecurityException {
        super(element);
        this.element = this.copyElement(doc, element);
    }

    public Lifetime(WSSConfig wssConfig, Document doc, int duration) {
        super(wssConfig.isPrecisionInMilliSeconds(), doc, duration);
        this.element = this.changeElementName(this.element, "http://schemas.xmlsoap.org/ws/2004/04/trust", "wst:Lifetime");
    }

    public Lifetime(WSSConfig wssConfig, Document doc, Date created, Date expires) {
        super(wssConfig.isPrecisionInMilliSeconds(), doc, 0);
        this.element = doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/04/trust", "wst:Lifetime");
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        zulu.setTimeZone(TimeZone.getTimeZone("GMT"));
        Calendar rightNow = Calendar.getInstance();
        if (created == null) {
            created = rightNow.getTime();
        }
        Element elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        WSSecurityUtil.setNamespace(elementCreated, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        elementCreated.appendChild(doc.createTextNode(zulu.format(created)));
        this.element.appendChild(elementCreated);
        if (expires == null) {
            expires = created;
        }
        Element elementExpires = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Expires");
        WSSecurityUtil.setNamespace(elementExpires, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        elementExpires.appendChild(doc.createTextNode(zulu.format(expires)));
        this.element.appendChild(elementExpires);
        this.created = Calendar.getInstance();
        this.expires = Calendar.getInstance();
        this.created.setTime(created);
        this.expires.setTime(expires);
    }

    public Element getElement(Document doc) {
        return this.copyElement(doc, this.element);
    }

    protected Element copyElement(Document doc, Element oldElement) {
        return (Element)doc.importNode(oldElement, true);
    }

    protected Element changeElementName(Document doc, Element oldElement, String newNamespace, String newQualName) {
        Element element2 = doc.createElementNS(newNamespace, newQualName);
        NamedNodeMap attrs = oldElement.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr2 = (Attr)doc.importNode(attrs.item(i), true);
            element2.getAttributes().setNamedItem(attr2);
        }
        while (oldElement.hasChildNodes()) {
            element2.appendChild(oldElement.getFirstChild());
        }
        return element2;
    }

    protected Element changeElementName(Element oldElement, String newNamespace, String newQualName) {
        return this.changeElementName(oldElement.getOwnerDocument(), oldElement, newNamespace, newQualName);
    }
}

