/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.processor.X509Util;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class EncryptedKeyProcessor
implements Processor {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$processor$EncryptedKeyProcessor == null ? (class$org$apache$ws$security$processor$EncryptedKeyProcessor = EncryptedKeyProcessor.class$("org.apache.ws.security.processor.EncryptedKeyProcessor")) : class$org$apache$ws$security$processor$EncryptedKeyProcessor).getName());
    private static Log tlog = LogFactory.getLog((String)"org.apache.ws.security.TIME");
    private byte[] decryptedBytes = null;
    private WSSConfig wssConfig = null;
    private String encryptedKeyId = null;
    static /* synthetic */ Class class$org$apache$ws$security$processor$EncryptedKeyProcessor;

    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Found encrypted key element");
        }
        this.wssConfig = wsc;
        if (decCrypto == null) {
            throw new WSSecurityException(0, "noDecCryptoFile");
        }
        if (cb == null) {
            throw new WSSecurityException(0, "noCallback");
        }
        ArrayList dataRefUris = this.handleEncryptedKey(elem, cb, decCrypto);
        this.encryptedKeyId = elem.getAttributeNS(null, "Id");
        returnResults.add(0, new WSSecurityEngineResult(4, this.decryptedBytes, this.encryptedKeyId, dataRefUris));
    }

    public ArrayList handleEncryptedKey(Element xencEncryptedKey, CallbackHandler cb, Crypto crypto) throws WSSecurityException {
        return this.handleEncryptedKey(xencEncryptedKey, cb, crypto, null);
    }

    public ArrayList handleEncryptedKey(Element xencEncryptedKey, PrivateKey privatekey) throws WSSecurityException {
        return this.handleEncryptedKey(xencEncryptedKey, null, null, privatekey);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList handleEncryptedKey(Element xencEncryptedKey, CallbackHandler cb, Crypto crypto, PrivateKey privateKey) throws WSSecurityException {
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        Document doc = xencEncryptedKey.getOwnerDocument();
        Node tmpE = null;
        tmpE = (Element)WSSecurityUtil.getDirectChild(xencEncryptedKey, "EncryptionMethod", "http://www.w3.org/2001/04/xmlenc#");
        String keyEncAlgo = null;
        if (tmpE != null) {
            keyEncAlgo = tmpE.getAttribute("Algorithm");
        }
        if (keyEncAlgo == null) {
            throw new WSSecurityException(2, "noEncAlgo");
        }
        Cipher cipher = WSSecurityUtil.getCipherInstance(keyEncAlgo);
        Element xencCipherValue = null;
        tmpE = (Element)WSSecurityUtil.getDirectChild(xencEncryptedKey, "CipherData", "http://www.w3.org/2001/04/xmlenc#");
        if (tmpE != null) {
            xencCipherValue = (Element)WSSecurityUtil.getDirectChild(tmpE, "CipherValue", "http://www.w3.org/2001/04/xmlenc#");
        }
        if (xencCipherValue == null) {
            throw new WSSecurityException(3, "noCipher");
        }
        if (privateKey == null) {
            String alias;
            Element keyInfo = (Element)WSSecurityUtil.getDirectChild(xencEncryptedKey, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
            if (keyInfo != null) {
                Element secRefToken = (Element)WSSecurityUtil.getDirectChild(keyInfo, "SecurityTokenReference", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
                if (secRefToken == null) {
                    throw new WSSecurityException(3, "noSecTokRef");
                }
                SecurityTokenReference secRef = new SecurityTokenReference(secRefToken);
                alias = null;
                if (secRef.containsX509Data() || secRef.containsX509IssuerSerial()) {
                    alias = secRef.getX509IssuerSerialAlias(crypto);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("X509IssuerSerial alias: " + alias));
                    }
                } else if (secRef.containsKeyIdentifier()) {
                    X509Certificate[] certs = secRef.getKeyIdentifier(crypto);
                    if (certs == null || certs.length < 1 || certs[0] == null) {
                        throw new WSSecurityException(0, "invalidX509Data", new Object[]{"for decryption (KeyId)"});
                    }
                    alias = crypto.getAliasForX509Cert(certs[0]);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("cert: " + certs[0]));
                        log.debug((Object)("KeyIdentifier Alias: " + alias));
                    }
                } else {
                    if (!secRef.containsReference()) throw new WSSecurityException(0, "unsupportedKeyId");
                    Element bstElement = secRef.getTokenElement(doc, null);
                    QName el = new QName(bstElement.getNamespaceURI(), bstElement.getLocalName());
                    if (!el.equals(WSSecurityEngine.binaryToken)) throw new WSSecurityException(3, "unsupportedToken", null);
                    X509Security token = null;
                    String value = bstElement.getAttribute("ValueType");
                    if (!X509Security.getType().equals(value) || (token = new X509Security(bstElement)) == null) {
                        throw new WSSecurityException(1, "unsupportedBinaryTokenType", new Object[]{"for decryption (BST)"});
                    }
                    X509Certificate cert = token.getX509Certificate(crypto);
                    if (cert == null) {
                        throw new WSSecurityException(0, "invalidX509Data", new Object[]{"for decryption"});
                    }
                    alias = crypto.getAliasForX509Cert(cert);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("BST Alias: " + alias));
                    }
                }
            } else {
                if (crypto.getDefaultX509Alias() == null) throw new WSSecurityException(3, "noKeyinfo");
                alias = crypto.getDefaultX509Alias();
            }
            WSPasswordCallback pwCb = new WSPasswordCallback(alias, 1);
            Callback[] callbacks = new Callback[]{pwCb};
            try {
                cb.handle(callbacks);
            }
            catch (IOException e) {
                throw new WSSecurityException(0, "noPassword", new Object[]{alias});
            }
            catch (UnsupportedCallbackException e) {
                throw new WSSecurityException(0, "noPassword", new Object[]{alias});
            }
            String password = pwCb.getPassword();
            if (password == null) {
                throw new WSSecurityException(0, "noPassword", new Object[]{alias});
            }
            try {
                privateKey = crypto.getPrivateKey(alias, password);
            }
            catch (Exception e) {
                throw new WSSecurityException(8, null, null, e);
            }
        }
        try {
            cipher.init(2, privateKey);
        }
        catch (Exception e1) {
            throw new WSSecurityException(8, null, null, e1);
        }
        try {
            this.decryptedBytes = cipher.doFinal(EncryptedKeyProcessor.getDecodedBase64EncodedData(xencCipherValue));
        }
        catch (IllegalStateException e2) {
            throw new WSSecurityException(8, null, null, e2);
        }
        catch (IllegalBlockSizeException e2) {
            throw new WSSecurityException(8, null, null, e2);
        }
        catch (BadPaddingException e2) {
            throw new WSSecurityException(8, null, null, e2);
        }
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        String dataRefURI = null;
        Element refList = (Element)WSSecurityUtil.getDirectChild(xencEncryptedKey, "ReferenceList", "http://www.w3.org/2001/04/xmlenc#");
        ArrayList<String> dataRefUris = new ArrayList<String>();
        if (refList != null) {
            for (tmpE = refList.getFirstChild(); tmpE != null; tmpE = tmpE.getNextSibling()) {
                if (tmpE.getNodeType() != 1 || !tmpE.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#") || !tmpE.getLocalName().equals("DataReference")) continue;
                dataRefURI = ((Element)tmpE).getAttribute("URI");
                this.decryptDataRef(doc, dataRefURI, this.decryptedBytes);
                dataRefUris.add(dataRefURI.substring(1));
            }
            return dataRefUris;
        }
        if (!tlog.isDebugEnabled()) return null;
        t2 = System.currentTimeMillis();
        tlog.debug((Object)("XMLDecrypt: total= " + (t2 - t0) + ", get-sym-key= " + (t1 - t0) + ", decrypt= " + (t2 - t1)));
        return null;
    }

    public static byte[] getDecodedBase64EncodedData(Element element) throws WSSecurityException {
        StringBuffer sb = new StringBuffer();
        NodeList children = element.getChildNodes();
        int iMax = children.getLength();
        for (int i = 0; i < iMax; ++i) {
            Node curr = children.item(i);
            if (curr.getNodeType() != 3) continue;
            sb.append(((Text)curr).getData());
        }
        String encodedData = sb.toString();
        return Base64.decode(encodedData);
    }

    private void decryptDataRef(Document doc, String dataRefURI, byte[] decryptedData) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("found data refernce: " + dataRefURI));
        }
        Element encBodyData = null;
        encBodyData = WSSecurityUtil.getElementByWsuId(doc, dataRefURI);
        if (encBodyData == null) {
            encBodyData = WSSecurityUtil.getElementByGenId(doc, dataRefURI);
        }
        if (encBodyData == null) {
            throw new WSSecurityException(3, "dataRef", new Object[]{dataRefURI});
        }
        boolean content = X509Util.isContent(encBodyData);
        String symEncAlgo = X509Util.getEncAlgo(encBodyData);
        SecretKey symmetricKey = WSSecurityUtil.prepareSecretKey(symEncAlgo, decryptedData);
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance((String)symEncAlgo);
            xmlCipher.init(2, (Key)symmetricKey);
        }
        catch (XMLEncryptionException e) {
            throw new WSSecurityException(2, null, null, e);
        }
        if (content) {
            encBodyData = (Element)encBodyData.getParentNode();
        }
        try {
            xmlCipher.doFinal(doc, encBodyData, content);
        }
        catch (Exception e1) {
            throw new WSSecurityException(8, null, null, e1);
        }
    }

    public String getId() {
        return this.encryptedKeyId;
    }

    public byte[] getDecryptedBytes() {
        return this.decryptedBytes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

