/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.adobe.epubcheck.util.InvalidDateException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class DateParser {
    private boolean checkValueAndNext(StringTokenizer st, String token) throws InvalidDateException {
        if (!st.hasMoreTokens()) {
            return false;
        }
        String t = st.nextToken();
        if (!t.equals(token)) {
            throw new InvalidDateException("Unexpected: " + t);
        }
        if (!st.hasMoreTokens()) {
            throw new InvalidDateException("Incomplete date.");
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Calendar getCalendar(String iso8601Date) throws InvalidDateException {
        StringTokenizer st = new StringTokenizer(iso8601Date, "-T:.+Z", true);
        if (!st.hasMoreTokens()) {
            throw new InvalidDateException("Empty Date");
        }
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.clear();
        try {
            if (!st.hasMoreTokens()) {
                return calendar;
            }
            int year = Integer.parseInt(st.nextToken());
            calendar.set(1, year);
            if (!this.checkValueAndNext(st, "-")) {
                return calendar;
            }
            int month = Integer.parseInt(st.nextToken()) - 1;
            calendar.set(2, month);
            if (!this.checkValueAndNext(st, "-")) {
                return calendar;
            }
            int day = Integer.parseInt(st.nextToken());
            calendar.set(5, day);
            if (!this.checkValueAndNext(st, "T")) {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                return calendar;
            }
            int hour = Integer.parseInt(st.nextToken());
            calendar.set(11, hour);
            if (!this.checkValueAndNext(st, ":")) {
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                return calendar;
            }
            int minutes = Integer.parseInt(st.nextToken());
            calendar.set(12, minutes);
            if (!st.hasMoreTokens()) {
                return calendar;
            }
            String tok = st.nextToken();
            if (tok.equals(":")) {
                if (!st.hasMoreTokens()) throw new InvalidDateException("No secondes specified");
                int secondes = Integer.parseInt(st.nextToken());
                calendar.set(13, secondes);
                if (!st.hasMoreTokens()) {
                    return calendar;
                }
                tok = st.nextToken();
                if (tok.equals(".")) {
                    String nt = st.nextToken();
                    while (nt.length() < 3) {
                        nt = nt + "0";
                    }
                    if (nt.length() > 3) {
                        for (int i = 3; i < nt.length(); ++i) {
                            if (Character.isDigit(nt.charAt(i))) continue;
                            throw new InvalidDateException("Invalid digit in the decimal fraction of a second: " + nt.charAt(i));
                        }
                    }
                    nt = nt.substring(0, 3);
                    int millisec = Integer.parseInt(nt);
                    calendar.set(14, millisec);
                    if (!st.hasMoreTokens()) {
                        return calendar;
                    }
                    tok = st.nextToken();
                } else {
                    calendar.set(14, 0);
                }
            } else {
                calendar.set(13, 0);
                calendar.set(14, 0);
            }
            if (!tok.equals("Z")) {
                if (!tok.equals("+") && !tok.equals("-")) {
                    throw new InvalidDateException("only Z, + or - allowed");
                }
                boolean plus = tok.equals("+");
                if (!st.hasMoreTokens()) {
                    throw new InvalidDateException("Missing hour field");
                }
                int tzhour = Integer.parseInt(st.nextToken());
                if (!this.checkValueAndNext(st, ":")) {
                    throw new InvalidDateException("Missing minute field");
                }
                int tzmin = Integer.parseInt(st.nextToken());
                if (plus) {
                    ((Calendar)calendar).add(10, -tzhour);
                    ((Calendar)calendar).add(12, -tzmin);
                    return calendar;
                } else {
                    ((Calendar)calendar).add(10, tzhour);
                    ((Calendar)calendar).add(12, tzmin);
                }
                return calendar;
            } else {
                if (!st.hasMoreTokens()) return calendar;
                throw new InvalidDateException("Unexpected field at the end of the date field: " + st.nextToken());
            }
        }
        catch (NumberFormatException ex) {
            throw new InvalidDateException("[" + ex.getMessage() + "] is not an integer");
        }
    }

    public Date parse(String iso8601DateAsString) throws InvalidDateException {
        Calendar calendar = this.getCalendar(iso8601DateAsString);
        try {
            calendar.setLenient(false);
            return calendar.getTime();
        }
        catch (Exception e) {
            throw new InvalidDateException(iso8601DateAsString + " " + e.getClass().toString() + " " + e.getMessage());
        }
    }
}

