/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ocf.OCFHandler;
import com.adobe.epubcheck.opf.OPFPreflight;
import com.adobe.epubcheck.xml.XMLParser;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class OCFPreflight {
    ZipFile zip;
    Report report;
    HashSet encryptedItemsSet;

    public OCFPreflight(ZipFile zip, Report report) {
        this.zip = zip;
        this.report = report;
    }

    public void runChecks() {
        String containerEntry = "META-INF/container.xml";
        ZipEntry container = this.zip.getEntry("META-INF/container.xml");
        if (container == null) {
            this.report.error(null, 0, "META-INF/container.xml is missing");
            return;
        }
        XMLParser containerParser = new XMLParser(this.zip, containerEntry, this.report);
        OCFHandler containerHandler = new OCFHandler(containerParser);
        containerParser.addXMLHandler(containerHandler);
        containerParser.process();
        String rootPath = containerHandler.getRootPath();
        String encryptionEntry = "META-INF/encryption.xml";
        ZipEntry encryption = this.zip.getEntry(encryptionEntry);
        if (encryption != null) {
            XMLParser encryptionParser = new XMLParser(this.zip, encryptionEntry, this.report);
            OCFHandler encryptionHandler = new OCFHandler(encryptionParser);
            encryptionHandler.setPopulateEnryptedItems(true);
            encryptionHandler.setRootBase(this.processRootPath(rootPath));
            encryptionParser.addXMLHandler(encryptionHandler);
            encryptionParser.process();
            this.encryptedItemsSet = encryptionHandler.getEncryptedItems();
        }
        String signatureEntry = "META-INF/signatures.xml";
        ZipEntry signatures = this.zip.getEntry(signatureEntry);
        if (signatures != null) {
            XMLParser signatureParser = new XMLParser(this.zip, signatureEntry, this.report);
            OCFHandler signatureHandler = new OCFHandler(signatureParser);
            signatureParser.addXMLHandler(signatureHandler);
            signatureParser.process();
        }
        OPFPreflight opfChecker = new OPFPreflight(this.zip, this.report, rootPath);
        opfChecker.setEncryptedItemsSet(this.encryptedItemsSet);
        opfChecker.runChecks();
    }

    public String processRootPath(String rootPath) {
        String rootBase = rootPath;
        if (rootPath.endsWith(".opf")) {
            int slash = rootPath.lastIndexOf("/");
            if (slash < rootPath.lastIndexOf("\\")) {
                slash = rootPath.lastIndexOf("\\");
            }
            rootBase = slash >= 0 && slash + 1 < rootPath.length() ? rootPath.substring(0, slash + 1) : rootPath;
            return rootBase;
        }
        System.out.println("RootPath is not an OPF file");
        return null;
    }
}

