/*
* MyGoGrinder - a program to practice Go problems
* Copyright (c) 2004-2006 Tim Kington
*   timkington@users.sourceforge.net
* Portions Copyright (C) Ruediger Klehn (2014)
*   RuediRf@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/
// This is the tags pool drop-down box

package GoGrinder.ui;

import java.awt.event.*;
import javax.swing.*;

import GoGrinder.*;

/**
 *
 * @author  tkington
 */
public class TagCB extends JComboBox {
    DefaultComboBoxModel model;
    int numTags;
    TagListener listener;
    
    /** Creates a new instance of TagCB */
    public TagCB(TagListener l) {
        super(new DefaultComboBoxModel());
        
        fillCB();
        
        listener = l;
        
   // here we could add a listener for typed characters a-zA-Z and collect 
   // all typed without more than 1 sec. interruption // can be adjusted with settings
   // and THEN select this, maybe a msg box with ok/cancel
        addActionListener(new ActionListener() { 
            public void actionPerformed(ActionEvent e) { //
                onSelChanged(); //here maybe not directly selChanged, but collect 
                // keys, and when timeThisKey minus timeLastKey more than x msec, 
                // then onSelChanged and use this;
                // can also show list with currently selected item, but need 
                // [Enter] to accept/[Esc] or click elsewhere to abort (something of this direction)
            }
        });
    }
    
    public void fillCB() {
        model = (DefaultComboBoxModel)getModel();
        model.removeAllElements();
        
        model.addElement(Messages.getString("apply_tag")); //$NON-NLS-1$
        // would be fine to have this item only on the button and not also in the list
        
        String [] tags = GS.getTagList().getTags();
        for(int i = 0; i < tags.length; i++)
            model.addElement(tags[i]);
        
        model.addElement("----------"); //$NON-NLS-1$ // items added at the top of the list
        model.addElement(Messages.getString("new_tag")); //$NON-NLS-1$
        
        numTags = tags.length;
    }
    
    public boolean mergeTag(String tagToMerge) {
      boolean done = false;
      if(tagToMerge == null || tagToMerge.length() == 0)
        return false; // at the moment, we don't come here: these tags 
                      //   are sorted out in SelectionDialog.onImportTags()
      if(!GS.getTagList().addTag(tagToMerge))
        return false; // addTag gives false, if the tag is already in the list
      else {
        for(int j = 0; j < numTags; j++) { // the new tag becomes sorted into the list "lexicographically"
          if(tagToMerge.compareTo((String)getItemAt(j + 1)) < 0) { 
                                   // .compareTo gives a positive or negative integer or zero
            model.insertElementAt(tagToMerge, j + 1);
            done = true;
            break;
          }
        }
        if(!done)
        model.insertElementAt(tagToMerge, numTags + 1);
        numTags++;
        return true;
      }
      // at the end of this procedure the TagsCB needs to be updated!
      // return false; // we should never reach this point - o.k. - the compiler doesn't need it here 
    }
    
    public void onSelChanged() {
        int i = getSelectedIndex();
        if(i == -1)  // "-1 if no item is selected or if the currently 
                     //   selected item is not in the list" (by Java docs)
            return;
        
        if(i == 0 || i == numTags + 1) { // if we selected "Apply tag ..." or "---------"
            setSelectedIndex(0);
            return;
        }
        
        if(i == numTags + 2) { // "New tag ..." selected
            hidePopup();
            String nt = JOptionPane.showInputDialog(this, Messages.getString("new_tag_q")); //$NON-NLS-1$
            if(nt == null || nt.length() == 0)  
               // nothing entered (interestingly, when I pressed Enter with nothing written, this 
                return;     // gave a new empty tag (""), which could be used as every other tag
            
            if(!GS.getTagList().addTag(nt)) {
                JOptionPane.showMessageDialog(this, Messages.getString("dup_tag")); //$NON-NLS-1$
                return;
            }
            
            boolean done = false;
          // the new tag becomes sorted into the list "lexicographically"
            for(int j = 0; j < numTags; j++) { 
                if(nt.compareTo((String)getItemAt(j + 1)) < 0) { 
                                               // .compareTo gives a positive or negative integer or zero
                    model.insertElementAt(nt, j + 1);
                    done = true;
                    break;
                }
            }
            if(!done)
                model.insertElementAt(nt, numTags + 1);
            
            setSelectedIndex(0);
            numTags++;
            
            listener.newTagCreated();
        }
        else {
            listener.addTag((String)getSelectedItem());
            setSelectedIndex(0);
        }
    }
}
