/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.stress.Operation;
import org.apache.cassandra.stress.StressProfile;
import org.apache.cassandra.stress.generate.DistributionFactory;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.generate.TokenRangeIterator;
import org.apache.cassandra.stress.operations.OpDistributionFactory;
import org.apache.cassandra.stress.operations.SampledOpDistributionFactory;
import org.apache.cassandra.stress.report.Timer;
import org.apache.cassandra.stress.settings.Command;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionAnyProbabilities;
import org.apache.cassandra.stress.settings.OptionDistribution;
import org.apache.cassandra.stress.settings.OptionSimple;
import org.apache.cassandra.stress.settings.SettingsCommand;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.ResultLogger;

public class SettingsCommandUser
extends SettingsCommand {
    private final Map<String, Double> ratios;
    private final DistributionFactory clustering;
    public final StressProfile profile;
    private final Options options;

    public SettingsCommandUser(Options options) {
        super(Command.USER, options.parent);
        this.options = options;
        this.clustering = options.clustering.get();
        this.ratios = options.ops.ratios();
        String yamlPath = options.profile.value();
        File yamlFile = new File(yamlPath);
        this.profile = StressProfile.load(yamlFile.exists() ? yamlFile.toURI() : URI.create(yamlPath));
        if (this.ratios.size() == 0) {
            throw new IllegalArgumentException("Must specify at least one command with a non-zero ratio");
        }
    }

    public boolean hasInsertOnly() {
        return this.ratios.size() == 1 && this.ratios.containsKey("insert");
    }

    @Override
    public OpDistributionFactory getFactory(final StressSettings settings) {
        final SeedManager seeds = new SeedManager(settings);
        final TokenRangeIterator tokenRangeIterator = this.profile.tokenRangeQueries.isEmpty() ? null : new TokenRangeIterator(settings, this.profile.maybeLoadTokenRanges(settings));
        return new SampledOpDistributionFactory<String>(this.ratios, this.clustering){

            @Override
            protected List<? extends Operation> get(Timer timer, PartitionGenerator generator, String key, boolean isWarmup) {
                if (key.equalsIgnoreCase("insert")) {
                    return Collections.singletonList(SettingsCommandUser.this.profile.getInsert(timer, generator, seeds, settings));
                }
                if (key.equalsIgnoreCase("validate")) {
                    return SettingsCommandUser.this.profile.getValidate(timer, generator, seeds, settings);
                }
                if (SettingsCommandUser.this.profile.tokenRangeQueries.containsKey(key)) {
                    return Collections.singletonList(SettingsCommandUser.this.profile.getBulkReadQueries(key, timer, settings, tokenRangeIterator, isWarmup));
                }
                return Collections.singletonList(SettingsCommandUser.this.profile.getQuery(key, timer, generator, seeds, settings, isWarmup));
            }

            @Override
            protected PartitionGenerator newGenerator() {
                return SettingsCommandUser.this.profile.newGenerator(settings);
            }
        };
    }

    @Override
    public void truncateTables(StressSettings settings) {
        this.profile.truncateTable(settings);
    }

    @Override
    public void printSettings(ResultLogger out) {
        super.printSettings(out);
        out.printf("  Command Ratios: %s%n", this.ratios);
        out.printf("  Command Clustering Distribution: %s%n", this.options.clustering.getOptionAsString());
        out.printf("  Profile File: %s%n", this.options.profile.value());
    }

    public static SettingsCommandUser build(String[] params) {
        GroupedOptions options = GroupedOptions.select((String[])params, (GroupedOptions[])new Options[]{new Options(new SettingsCommand.Uncertainty()), new Options(new SettingsCommand.Duration()), new Options(new SettingsCommand.Count())});
        if (options == null) {
            SettingsCommandUser.printHelp();
            System.out.println("Invalid USER options provided, see output for valid options");
            System.exit(1);
        }
        return new SettingsCommandUser((Options)options);
    }

    public static void printHelp() {
        GroupedOptions.printOptions(System.out, "user", new Options(new SettingsCommand.Uncertainty()), new Options(new SettingsCommand.Count()), new Options(new SettingsCommand.Duration()));
    }

    public static Runnable helpPrinter() {
        return new Runnable(){

            @Override
            public void run() {
                SettingsCommandUser.printHelp();
            }
        };
    }

    static final class Options
    extends GroupedOptions {
        final SettingsCommand.Options parent;
        final OptionDistribution clustering = new OptionDistribution("clustering=", "gaussian(1..10)", "Distribution clustering runs of operations of the same kind");
        final OptionSimple profile = new OptionSimple("profile=", ".*", null, "Specify the path to a yaml cql3 profile", true);
        final OptionAnyProbabilities ops = new OptionAnyProbabilities("ops", "Specify the ratios for inserts/queries to perform; e.g. ops(insert=2,<query1>=1) will perform 2 inserts for each query1");

        protected Options(SettingsCommand.Options parent) {
            this.parent = parent;
        }

        @Override
        public List<? extends Option> options() {
            return Options.merge(Arrays.asList(this.ops, this.profile, this.clustering), this.parent.options());
        }
    }
}

