/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.impl;

import edu.umd.marbl.mhap.impl.MhapRuntimeException;
import edu.umd.marbl.mhap.impl.Sequence;
import edu.umd.marbl.mhap.impl.SequenceId;
import edu.umd.marbl.mhap.utils.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;

public class FastaData
implements Cloneable {
    private final BufferedReader fileReader;
    private final long offset;
    private String lastLine;
    private AtomicLong numberProcessed;
    private boolean readFullFile;
    private final ConcurrentLinkedQueue<Sequence> sequenceList;
    private static final String[] fastaSuffix = new String[]{"fna", "contigs", "contig", "final", "fasta", "fa"};

    private FastaData(ConcurrentLinkedQueue<Sequence> seqList) {
        this.sequenceList = new ConcurrentLinkedQueue<Sequence>(seqList);
        this.fileReader = null;
        this.lastLine = null;
        this.readFullFile = true;
        this.numberProcessed = new AtomicLong(this.sequenceList.size());
        this.offset = 0L;
    }

    public FastaData(String file, long offset) throws IOException {
        try {
            this.fileReader = Utils.getFile(file, fastaSuffix);
        }
        catch (Exception e) {
            throw new MhapRuntimeException(e);
        }
        this.offset = offset;
        this.lastLine = null;
        this.readFullFile = false;
        this.numberProcessed = new AtomicLong(0L);
        this.sequenceList = new ConcurrentLinkedQueue();
    }

    public synchronized FastaData clone() {
        try {
            this.enqueueFullFile();
        }
        catch (IOException e) {
            throw new MhapRuntimeException(e);
        }
        return new FastaData(this.sequenceList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence dequeue() throws IOException {
        Sequence seq;
        ConcurrentLinkedQueue<Sequence> concurrentLinkedQueue = this.sequenceList;
        synchronized (concurrentLinkedQueue) {
            if (this.sequenceList.isEmpty()) {
                this.enqueueNextSequenceInFile();
            }
            seq = this.sequenceList.poll();
        }
        return seq;
    }

    public void enqueueFullFile() throws IOException {
        while (this.enqueueNextSequenceInFile()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enqueueNextSequenceInFile() throws IOException {
        StringBuilder fastaSeq = new StringBuilder();
        String header = null;
        long index = -1L - this.offset;
        BufferedReader bufferedReader = this.fileReader;
        synchronized (bufferedReader) {
            if (this.readFullFile) {
                return false;
            }
            if (this.lastLine == null) {
                this.lastLine = this.fileReader.readLine();
                if (this.lastLine == null) {
                    this.fileReader.close();
                    this.readFullFile = true;
                    return false;
                }
            }
            if (!this.lastLine.startsWith(">")) {
                throw new MhapRuntimeException("Next sequence does not start with >. Invalid format.");
            }
            if (SequenceId.STORE_FULL_ID) {
                header = this.lastLine.substring(1).split("[\\s,]+", 2)[0];
            }
            this.lastLine = this.fileReader.readLine();
            while (this.lastLine != null && !this.lastLine.startsWith(">")) {
                fastaSeq.append(this.lastLine);
                this.lastLine = this.fileReader.readLine();
            }
            if (this.lastLine == null) {
                this.fileReader.close();
                this.readFullFile = true;
            }
            if (fastaSeq.length() > 0) {
                index = this.numberProcessed.incrementAndGet();
            }
        }
        String fastaSeqSring = fastaSeq.toString();
        if (!fastaSeqSring.isEmpty()) {
            SequenceId id = SequenceId.STORE_FULL_ID ? new SequenceId(index + this.offset, true, header) : new SequenceId(index + this.offset);
            Sequence seq = new Sequence(fastaSeq.toString().toUpperCase(Locale.ENGLISH), id);
            this.sequenceList.add(seq);
            return true;
        }
        return false;
    }

    public int getNumberProcessed() {
        return this.numberProcessed.intValue();
    }

    public Sequence getSequence(SequenceId id) {
        if (id.isForward()) {
            for (Sequence seq : this.sequenceList) {
                if (!seq.getId().equals(id)) continue;
                return seq;
            }
        }
        id = id.complimentId();
        for (Sequence seq : this.sequenceList) {
            if (!seq.getId().equals(id)) continue;
            return seq.getReverseCompliment();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        BufferedReader bufferedReader = this.fileReader;
        synchronized (bufferedReader) {
            return this.sequenceList.isEmpty() && this.readFullFile;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.fileReader.close();
    }
}

