/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.sketch;

import edu.umd.marbl.mhap.sketch.Sketch;
import edu.umd.marbl.mhap.sketch.SketchRuntimeException;

public abstract class AbstractBitSketch<T extends AbstractBitSketch<T>>
implements Sketch<T>,
Comparable<T> {
    protected final long[] bits;
    private static final long serialVersionUID = -3392030412388403092L;

    protected AbstractBitSketch(long[] bits) {
        this.bits = bits;
    }

    @Override
    public int compareTo(T sim) {
        for (int bitIndex = 0; bitIndex < this.bits.length; ++bitIndex) {
            if (this.bits[bitIndex] < ((AbstractBitSketch)sim).bits[bitIndex]) {
                return -1;
            }
            if (this.bits[bitIndex] <= ((AbstractBitSketch)sim).bits[bitIndex]) continue;
            return 1;
        }
        return 0;
    }

    public final boolean getBit(long index) {
        int arrayIndex = (int)(index / 64L);
        int bitPos = (int)(index % 64L);
        long mask = 1L << bitPos;
        return (this.bits[arrayIndex] & mask) != 0L;
    }

    public final long[] getBits() {
        return this.bits;
    }

    public final int getIntersectionCount(T sh) {
        if (this.bits.length != ((AbstractBitSketch)sh).bits.length) {
            throw new SketchRuntimeException("Size of bits in tables must match.");
        }
        int count = 0;
        for (int longIndex = 0; longIndex < this.bits.length; ++longIndex) {
            long xor = this.bits[longIndex] ^ ((AbstractBitSketch)sh).bits[longIndex];
            count += Long.bitCount(xor);
        }
        return this.bits.length * 64 - count;
    }

    public long getWord(int index) {
        return this.bits[index];
    }

    public long numberOfBits() {
        return this.bits.length * 64;
    }

    public int numberOfWords() {
        return this.bits.length;
    }

    @Override
    public final double similarity(T v) {
        int count = this.getIntersectionCount(v);
        return (double)count / (double)this.numberOfBits();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (int longIndex = 0; longIndex < this.bits.length; ++longIndex) {
            long mask = Long.MIN_VALUE;
            for (int bit = 63; bit >= 0; --bit) {
                if ((this.bits[longIndex] & mask) == 0L) {
                    s.append("0");
                } else {
                    s.append("1");
                }
                mask >>>= 1;
            }
        }
        return s.toString();
    }
}

