/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

public class IntHashSet
extends AbstractSet<Integer> {
    private static final int DEFAULT_CAPACITY = 7;
    private int size;
    private int growSize;
    volatile transient int modCount;
    private Entry[] entries;

    public IntHashSet() {
        this(7);
    }

    public IntHashSet(int startingCapacity) {
        startingCapacity = (int)((double)startingCapacity / 0.75 + 0.9999) | 1;
        this.entries = new Entry[startingCapacity];
        this.growSize = (int)((double)startingCapacity * 0.75);
    }

    public IntHashSet(Collection<? extends Integer> init) {
        this(init.size());
        this.addAll(init);
    }

    private boolean contains(int key) {
        Entry bucket = this.entries[(key & Integer.MAX_VALUE) % this.entries.length];
        while (bucket != null) {
            if (bucket.key == key) {
                return true;
            }
            bucket = bucket.next;
        }
        return false;
    }

    @Override
    public boolean contains(Object key) {
        return this.contains((Integer)key);
    }

    @Override
    public boolean add(Integer key) {
        return this.add((int)key);
    }

    @Override
    public boolean add(int key) {
        int bucket = (key & Integer.MAX_VALUE) % this.entries.length;
        Entry entry = this.entries[bucket];
        while (entry != null) {
            if (entry.key == key) {
                return false;
            }
            entry = entry.next;
        }
        ++this.modCount;
        if (this.size == this.growSize) {
            this.growCapacity();
            bucket = (key & Integer.MAX_VALUE) % this.entries.length;
        }
        Entry newEntry = new Entry(key);
        newEntry.next = this.entries[bucket];
        this.entries[bucket] = newEntry;
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(Object key) {
        return this.remove((Integer)key);
    }

    public boolean remove(int key) {
        int bucket = (key & Integer.MAX_VALUE) % this.entries.length;
        Entry prevEntry = null;
        Entry entry = this.entries[bucket];
        while (entry != null) {
            if (entry.key == key) {
                if (prevEntry == null) {
                    this.entries[bucket] = entry.next;
                } else {
                    prevEntry.next = entry.next;
                }
                --this.size;
                ++this.modCount;
                return true;
            }
            prevEntry = entry;
            entry = entry.next;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = null;
        }
        this.size = 0;
    }

    private void growCapacity() {
        int newSize = this.entries.length * 2 + 1;
        Entry[] newEntries = new Entry[newSize];
        for (int bucket = 0; bucket < this.entries.length; ++bucket) {
            Entry entry = this.entries[bucket];
            while (entry != null) {
                Entry nextEntry = entry.next;
                int newBucket = (entry.key & Integer.MAX_VALUE) % newSize;
                entry.next = newEntries[newBucket];
                newEntries[newBucket] = entry;
                entry = nextEntry;
            }
        }
        this.entries = newEntries;
        this.growSize = (int)((double)newSize * 0.75);
    }

    public IntIterator iterator() {
        return new IntIterator();
    }

    public class IntIterator
    implements Iterator<Integer> {
        int bucket;
        Entry prevEntry;
        Entry entry;
        int expectedModCount;

        public IntIterator() {
            this.expectedModCount = IntHashSet.this.modCount;
            this.entry = null;
            this.bucket = 0;
            while (this.bucket < IntHashSet.this.entries.length) {
                if (IntHashSet.this.entries[this.bucket] != null) {
                    this.entry = IntHashSet.this.entries[this.bucket];
                    return;
                }
                ++this.bucket;
            }
        }

        @Override
        public boolean hasNext() {
            return this.entry != null;
        }

        public int nextInt() {
            if (IntHashSet.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.prevEntry = this.entry;
            if (this.entry != null) {
                this.entry = this.entry.next;
                while (this.entry == null && ++this.bucket < IntHashSet.this.entries.length) {
                    this.entry = IntHashSet.this.entries[this.bucket];
                }
            }
            return this.prevEntry.key;
        }

        @Override
        public Integer next() {
            return new Integer(this.nextInt());
        }

        @Override
        public void remove() {
            if (this.prevEntry == null) {
                throw new IllegalStateException();
            }
            if (IntHashSet.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            IntHashSet.this.remove(this.prevEntry.key);
            this.prevEntry = null;
            this.expectedModCount = IntHashSet.this.modCount;
        }
    }

    private static class Entry {
        Entry next;
        final int key;

        Entry(int key) {
            this.key = key;
        }
    }
}

