/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.tools;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.impl.DynamicActionConfigurationCustomizer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.PresentableId;
import com.intellij.remote.RemoteConnectionType;
import com.intellij.tools.BaseToolManager;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolsGroup;
import com.intellij.tools.ToolsProcessor;
import com.jetbrains.plugins.remotesdk.tools.RemoteTool;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Service
public final class RemoteToolManager
extends BaseToolManager<RemoteTool> {
    @NonNls
    private static final String CONNECTION_TYPE = "CONNECTION_TYPE";
    @NonNls
    private static final String CONNECTION_ID = "CONNECTION_ID";
    @NonNls
    private static final String CONNECTION_ADDITIONAL_DATA = "CONNECTION_ADDITIONAL_DATA";

    public RemoteToolManager() {
        super(SchemeManagerFactory.getInstance(), "remoteTools", RemoteTool.DEFAULT_GROUP_NAME_SUPPLIER.get());
    }

    public static RemoteToolManager getInstance() {
        return (RemoteToolManager)((Object)ApplicationManager.getApplication().getService(RemoteToolManager.class));
    }

    protected SchemeProcessor<ToolsGroup<RemoteTool>, ToolsGroup<RemoteTool>> createProcessor() {
        return new ToolsProcessor<RemoteTool>(){

            protected ToolsGroup<RemoteTool> createToolsGroup(String groupName) {
                return new ToolsGroup(groupName);
            }

            protected String getDefaultGroupName() {
                return RemoteTool.DEFAULT_GROUP_NAME_SUPPLIER.get();
            }

            protected RemoteTool createTool() {
                return new RemoteTool();
            }

            protected void readToolAttributes(Element element, RemoteTool tool) {
                super.readToolAttributes(element, (Tool)tool);
                RemoteConnectionType connectionType = RemoteConnectionType.findByName((String)element.getAttributeValue(RemoteToolManager.CONNECTION_TYPE));
                String connectionId = BaseToolManager.convertString((String)element.getAttributeValue(RemoteToolManager.CONNECTION_ID));
                String connectionAdditionalData = BaseToolManager.convertString((String)element.getAttributeValue(RemoteToolManager.CONNECTION_ADDITIONAL_DATA));
                if (RemoteConnectionType.DEPLOYMENT_SERVER == connectionType) {
                    PresentableId id;
                    connectionType = RemoteConnectionType.SSH_CONFIG;
                    WebServerConfig server = GroupedServersConfigManager.getInstance(null).findServer(connectionId);
                    connectionId = null;
                    connectionAdditionalData = null;
                    if (server != null && (id = server.getFileTransferConfig().getSshPresentableId()) != null) {
                        connectionId = id.getName();
                        connectionAdditionalData = id.getId();
                    }
                }
                tool.setConnectionId(connectionId);
                tool.setConnectionType(connectionType);
                tool.setAdditionalData(connectionAdditionalData);
            }

            protected void saveToolAttributes(RemoteTool tool, Element element) {
                String connectionTypeName;
                super.saveToolAttributes((Tool)tool, element);
                RemoteConnectionType connectionType = tool.getConnectionType();
                String string = connectionTypeName = connectionType == null ? null : connectionType.name();
                if (!StringUtil.isEmpty((String)connectionTypeName)) {
                    element.setAttribute(RemoteToolManager.CONNECTION_TYPE, connectionTypeName);
                }
                if (!StringUtil.isEmpty((String)tool.getConnectionId())) {
                    element.setAttribute(RemoteToolManager.CONNECTION_ID, tool.getConnectionId());
                }
                if (!StringUtil.isEmpty((String)tool.getAdditionalData())) {
                    element.setAttribute(RemoteToolManager.CONNECTION_ADDITIONAL_DATA, tool.getAdditionalData());
                }
            }
        };
    }

    protected String getActionIdPrefix() {
        return "RemoteTool_";
    }

    static final class MyActionTuner
    implements DynamicActionConfigurationCustomizer {
        MyActionTuner() {
        }

        public void registerActions(@NotNull ActionManager actionManager) {
            if (actionManager == null) {
                MyActionTuner.$$$reportNull$$$0(0);
            }
            RemoteToolManager.getInstance().registerActions(actionManager);
        }

        public void unregisterActions(@NotNull ActionManager actionManager) {
            if (actionManager == null) {
                MyActionTuner.$$$reportNull$$$0(1);
            }
            RemoteToolManager.getInstance().unregisterActions(actionManager);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "actionManager";
            objectArray2[1] = "com/jetbrains/plugins/remotesdk/tools/RemoteToolManager$MyActionTuner";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerActions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unregisterActions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

