/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.config.UpdateMethod;
import git4idea.i18n.GitBundle;
import git4idea.i18n.GitBundleExtensions;
import git4idea.push.PushUpdateSettings;
import git4idea.repo.GitRepository;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GitRejectedPushUpdateDialog
extends DialogWrapper {
    public static final int MERGE_EXIT_CODE = 2;
    public static final int REBASE_EXIT_CODE = 3;
    private final Project myProject;
    private final Collection<? extends GitRepository> myRepositories;
    private final boolean myRebaseOverMergeProblemDetected;
    private final JCheckBox myUpdateAllRoots;
    private final RebaseAction myRebaseAction;
    private final MergeAction myMergeAction;
    private final JCheckBox myAutoUpdateInFuture;

    protected GitRejectedPushUpdateDialog(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NotNull PushUpdateSettings initialSettings, boolean rebaseOverMergeProblemDetected) {
        if (project == null) {
            GitRejectedPushUpdateDialog.$$$reportNull$$$0(0);
        }
        if (repositories == null) {
            GitRejectedPushUpdateDialog.$$$reportNull$$$0(1);
        }
        if (initialSettings == null) {
            GitRejectedPushUpdateDialog.$$$reportNull$$$0(2);
        }
        super(project);
        this.myProject = project;
        this.myRepositories = repositories;
        this.myRebaseOverMergeProblemDetected = rebaseOverMergeProblemDetected;
        this.myUpdateAllRoots = new JCheckBox(GitBundle.message("push.rejected.update.not.rejected.repositories.as.well.checkbox", new Object[0]), initialSettings.shouldUpdateAllRoots());
        this.myAutoUpdateInFuture = new JCheckBox(GitBundleExtensions.html("push.rejected.remember.checkbox", new Object[0]));
        this.myMergeAction = new MergeAction();
        this.myRebaseAction = new RebaseAction();
        this.setDefaultAndFocusedActions(initialSettings.getUpdateMethod());
        this.init();
        this.setTitle(GitBundle.message("push.rejected.dialog.title", new Object[0]));
    }

    private void setDefaultAndFocusedActions(@Nullable UpdateMethod updateMethod) {
        Action focusedAction;
        AbstractAction defaultAction;
        if (this.myRebaseOverMergeProblemDetected) {
            defaultAction = this.myMergeAction;
            focusedAction = this.getCancelAction();
        } else if (updateMethod == UpdateMethod.REBASE) {
            defaultAction = this.myRebaseAction;
            focusedAction = this.myMergeAction;
        } else {
            defaultAction = this.myMergeAction;
            focusedAction = this.myRebaseAction;
        }
        defaultAction.putValue("DefaultAction", Boolean.TRUE);
        focusedAction.putValue("FocusedAction", Boolean.TRUE);
    }

    protected JComponent createCenterPanel() {
        JBLabel desc = new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)this.makeDescription()));
        JPanel options = new JPanel(new BorderLayout());
        if (!this.myRebaseOverMergeProblemDetected) {
            options.add((Component)this.myAutoUpdateInFuture, "South");
        }
        if (!GitUtil.justOneGitRepository(this.myProject)) {
            options.add(this.myUpdateAllRoots);
        }
        int GAP = 15;
        JPanel rootPanel = new JPanel(new BorderLayout(15, 15));
        rootPanel.add((Component)desc);
        rootPanel.add((Component)options, "South");
        JLabel iconLabel = new JLabel(this.myRebaseOverMergeProblemDetected ? UIUtil.getWarningIcon() : UIUtil.getQuestionIcon());
        rootPanel.add((Component)iconLabel, "West");
        return rootPanel;
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.UpdateOnRejectedPushDialog";
    }

    @NlsContexts.Label
    private String makeDescription() {
        if (GitUtil.justOneGitRepository(this.myProject)) {
            assert (!this.myRepositories.isEmpty()) : "repositories are empty";
            GitRepository repository = this.myRepositories.iterator().next();
            String currentBranch = GitRejectedPushUpdateDialog.getCurrentBranch(repository).getName();
            return new HtmlBuilder().appendRaw(GitBundle.message("push.rejected.only.one.git.repo", HtmlChunk.text((String)currentBranch).code())).br().appendRaw(this.descriptionEnding()).toString();
        }
        if (this.myRepositories.size() == 1) {
            GitRepository repository = (GitRepository)ContainerUtil.getFirstItem(this.myRepositories);
            String currentBranch = GitRejectedPushUpdateDialog.getCurrentBranch(repository).getName();
            return new HtmlBuilder().appendRaw(GitBundle.message("push.rejected.specific.repo", HtmlChunk.text((String)currentBranch).code(), HtmlChunk.text((String)repository.getPresentableUrl()).code())).br().appendRaw(this.descriptionEnding()).toString();
        }
        Map<GitRepository, GitBranch> currentBranches = this.getCurrentBranches();
        HtmlBuilder description = new HtmlBuilder();
        if (GitRejectedPushUpdateDialog.allBranchesHaveTheSameName(currentBranches)) {
            String branchName = ((GitBranch)ContainerUtil.getFirstItem(currentBranches.values())).getName();
            description.appendRaw(GitBundle.message("push.rejected.many.repos.single.branch", HtmlChunk.text((String)branchName).code())).br();
            for (GitRepository repository : DvcsUtil.sortRepositories(currentBranches.keySet())) {
                description.nbsp(4).append((HtmlChunk)HtmlChunk.text((String)repository.getPresentableUrl()).code()).br();
            }
        } else {
            description.append(GitBundle.message("push.rejected.many.repos", new Object[0])).br();
            for (Map.Entry<GitRepository, GitBranch> entry : currentBranches.entrySet()) {
                String repositoryUrl = entry.getKey().getPresentableUrl();
                String currentBranch = entry.getValue().getName();
                description.nbsp(4).appendRaw(GitBundle.message("push.rejected.many.repos.item", HtmlChunk.text((String)currentBranch).code(), HtmlChunk.text((String)repositoryUrl).code())).br();
            }
        }
        return description.br().appendRaw(this.descriptionEnding()).toString();
    }

    @NotNull
    @NlsContexts.Label
    private String descriptionEnding() {
        if (this.myRebaseOverMergeProblemDetected) {
            String string = GitBundle.message("push.rejected.merge.needed.with.problem", new Object[0]);
            if (string == null) {
                GitRejectedPushUpdateDialog.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = GitBundle.message("push.rejected.merge.needed", new Object[0]);
        if (string == null) {
            GitRejectedPushUpdateDialog.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static boolean allBranchesHaveTheSameName(@NotNull Map<GitRepository, GitBranch> branches2) {
        if (branches2 == null) {
            GitRejectedPushUpdateDialog.$$$reportNull$$$0(5);
        }
        String name = null;
        for (GitBranch branch : branches2.values()) {
            if (name == null) {
                name = branch.getName();
                continue;
            }
            if (name.equals(branch.getName())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private Map<GitRepository, GitBranch> getCurrentBranches() {
        HashMap<GitRepository, GitBranch> currentBranches = new HashMap<GitRepository, GitBranch>();
        for (GitRepository gitRepository : this.myRepositories) {
            currentBranches.put(gitRepository, GitRejectedPushUpdateDialog.getCurrentBranch(gitRepository));
        }
        HashMap<GitRepository, GitBranch> hashMap = currentBranches;
        if (hashMap == null) {
            GitRejectedPushUpdateDialog.$$$reportNull$$$0(6);
        }
        return hashMap;
    }

    @NotNull
    @NlsSafe
    private static GitBranch getCurrentBranch(GitRepository repository) {
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        assert (currentBranch != null) : "Current branch can't be null here. " + repository;
        GitLocalBranch gitLocalBranch = currentBranch;
        if (gitLocalBranch == null) {
            GitRejectedPushUpdateDialog.$$$reportNull$$$0(7);
        }
        return gitLocalBranch;
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getCancelAction(), this.myMergeAction, this.myRebaseAction};
        if (actionArray == null) {
            GitRejectedPushUpdateDialog.$$$reportNull$$$0(8);
        }
        return actionArray;
    }

    boolean shouldUpdateAll() {
        return this.myUpdateAllRoots.isSelected();
    }

    boolean shouldAutoUpdateInFuture() {
        return this.myAutoUpdateInFuture.isSelected();
    }

    @TestOnly
    boolean warnsAboutRebaseOverMerge() {
        return this.myRebaseOverMergeProblemDetected;
    }

    @TestOnly
    @NotNull
    Action getDefaultAction() {
        AbstractAction abstractAction = Boolean.TRUE.equals(this.myMergeAction.getValue("DefaultAction")) ? this.myMergeAction : this.myRebaseAction;
        if (abstractAction == null) {
            GitRejectedPushUpdateDialog.$$$reportNull$$$0(9);
        }
        return abstractAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSettings";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/push/GitRejectedPushUpdateDialog";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/push/GitRejectedPushUpdateDialog";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "descriptionEnding";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentBranches";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentBranch";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "allBranchesHaveTheSameName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RebaseAction
    extends AbstractAction {
        RebaseAction() {
            super(GitRejectedPushUpdateDialog.this.myRebaseOverMergeProblemDetected ? GitBundle.message("push.rejected.rebase.anyway", new Object[0]) : GitBundle.message("push.rejected.rebase", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GitRejectedPushUpdateDialog.this.close(3);
        }
    }

    private class MergeAction
    extends AbstractAction {
        MergeAction() {
            super(GitBundle.message("push.rejected.merge", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GitRejectedPushUpdateDialog.this.close(2);
        }
    }
}

