/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.ide.DataManager;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunSettings;
import com.intellij.javascript.jest.scope.JestScopeKind;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.execution.ParametersListUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JestUpdateSnapshotHyperlinkInfo
implements HyperlinkInfo {
    @NonNls
    private static final String WATCH_OPT = "--watch";
    @NonNls
    private static final String WATCH_ALL_OPT = "--watchAll";
    private final String myTestFilePath;
    private final List<String> myTestFqn;

    public JestUpdateSnapshotHyperlinkInfo(@Nullable String testFilePath, @Nullable List<String> testFqn) {
        this.myTestFilePath = testFilePath;
        this.myTestFqn = testFqn;
    }

    public void navigate(@NotNull Project project) {
        Component owner;
        if (project == null) {
            JestUpdateSnapshotHyperlinkInfo.$$$reportNull$$$0(0);
        }
        if ((owner = IdeFocusManager.getInstance((Project)project).getFocusOwner()) != null) {
            RunProfile runProfile;
            ExecutionEnvironment env = (ExecutionEnvironment)DataManager.getInstance().getDataContext(owner).getData(LangDataKeys.EXECUTION_ENVIRONMENT);
            RunProfile runProfile2 = runProfile = env != null ? WrappingRunConfiguration.unwrapRunProfile((RunProfile)env.getRunProfile()) : null;
            if (env != null && runProfile instanceof JestRunConfiguration) {
                JestRunConfiguration jestRc = (JestRunConfiguration)runProfile;
                jestRc = (JestRunConfiguration)jestRc.clone();
                JestRunSettings.Builder builder = jestRc.getRunSettings().toBuilder();
                builder.setScopeKind(JestScopeKind.ALL);
                if (this.myTestFilePath != null) {
                    builder.setTestFilePath(this.myTestFilePath);
                    builder.setScopeKind(JestScopeKind.TEST_FILE);
                }
                if (this.myTestFqn != null) {
                    builder.setTestNames(this.myTestFqn);
                    builder.setScopeKind(JestScopeKind.TEST);
                }
                builder.setJestOptions(JestUpdateSnapshotHyperlinkInfo.clearWatchOpts(jestRc.getRunSettings().getJestOptions()));
                jestRc.setRunSettings(builder.build());
                jestRc.setOptionUpdateSnapshot();
                jestRc.setGeneratedName();
                jestRc.setName(JavaScriptBundle.message("jest.snapshot.update.rc.name", jestRc.getName()));
                ExecutionUtil.restart((ExecutionEnvironment)ExecutionEnvironmentBuilder.create((Executor)env.getExecutor(), (RunConfiguration)jestRc).build());
            }
        }
    }

    @NotNull
    private static String clearWatchOpts(@NotNull String jestOptions) {
        if (jestOptions == null) {
            JestUpdateSnapshotHyperlinkInfo.$$$reportNull$$$0(1);
        }
        ArrayList opts = new ArrayList(ParametersListUtil.parse((String)jestOptions));
        opts.remove(WATCH_OPT);
        opts.remove(WATCH_ALL_OPT);
        String string = ParametersListUtil.join(opts);
        if (string == null) {
            JestUpdateSnapshotHyperlinkInfo.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jestOptions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/jest/JestUpdateSnapshotHyperlinkInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/jest/JestUpdateSnapshotHyperlinkInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "clearWatchOpts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "clearWatchOpts";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

