/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageHelper;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.TestResultsViewer;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.javascript.jest.JestConsoleProperties;
import com.intellij.javascript.jest.JestCoverageConfig;
import com.intellij.javascript.jest.JestCoverageConfigListener;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunProfileState;
import com.intellij.javascript.jest.JestUtil;
import com.intellij.javascript.jest.coverage.FileModificationsSettledDownTracker;
import com.intellij.javascript.jest.coverage.JestCoverageRunner;
import com.intellij.javascript.nodejs.execution.NodeRunProgramRunner;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

final class JestCoverageProgramRunner
extends AsyncProgramRunner<RunnerSettings> {
    private static final Logger LOG = Logger.getInstance(JestCoverageProgramRunner.class);
    private static final String COVERAGE_RUNNER_ID = JestCoverageProgramRunner.class.getSimpleName();

    JestCoverageProgramRunner() {
    }

    @NotNull
    public String getRunnerId() {
        String string = COVERAGE_RUNNER_ID;
        if (string == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(1);
        }
        if (profile == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(2);
        }
        return "Coverage".equals(executorId) && profile instanceof JestRunConfiguration;
    }

    public RunnerSettings createConfigurationData(@NotNull ConfigurationInfoProvider settingsProvider) {
        if (settingsProvider == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(3);
        }
        return new CoverageRunnerData();
    }

    @NotNull
    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state2) throws ExecutionException {
        if (environment == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(4);
        }
        if (state2 == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(5);
        }
        Disposable listeningForCoverageConfig = Disposer.newDisposable((Disposable)JestCoverageDisposable.getInstance(environment.getProject()), (String)"jest");
        Supplier<JestCoverageConfig> coverageConfigSupplier = JestCoverageProgramRunner.getCoverageConfigSupplier(environment, listeningForCoverageConfig);
        Promise promise = NodeRunProgramRunner.Companion.execute(state2, environment).onSuccess(descriptor2 -> {
            if (descriptor2 != null) {
                Disposer.register((Disposable)descriptor2, (Disposable)listeningForCoverageConfig);
                JestCoverageProgramRunner.doExecute(descriptor2, (JestRunProfileState)state2, environment, coverageConfigSupplier);
            }
        });
        if (promise == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(6);
        }
        return promise;
    }

    @NotNull
    private static Supplier<JestCoverageConfig> getCoverageConfigSupplier(@NotNull ExecutionEnvironment environment, @NotNull Disposable listeningForCoverageConfig) {
        if (environment == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(7);
        }
        if (listeningForCoverageConfig == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(8);
        }
        final AtomicReference coverageConfigRef = new AtomicReference();
        final RunProfile thisRunProfile = WrappingRunConfiguration.unwrapRunProfile((RunProfile)environment.getRunProfile());
        environment.getProject().getMessageBus().connect(listeningForCoverageConfig).subscribe(JestConsoleProperties.COVERAGE_CONFIG_TOPIC, (Object)new JestCoverageConfigListener(){

            @Override
            public void onJestConfigReceived(@NotNull JestRunConfiguration configuration, @NotNull JestCoverageConfig jestCoverageConfig) {
                if (configuration == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (jestCoverageConfig == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (configuration == thisRunProfile) {
                    coverageConfigRef.set(jestCoverageConfig);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "configuration";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "jestCoverageConfig";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javascript/jest/coverage/JestCoverageProgramRunner$1";
                objectArray[2] = "onJestConfigReceived";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        Supplier<JestCoverageConfig> supplier = () -> (JestCoverageConfig)coverageConfigRef.get();
        if (supplier == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(9);
        }
        return supplier;
    }

    private static void doExecute(final @NotNull RunContentDescriptor descriptor2, final @NotNull JestRunProfileState state2, final @NotNull ExecutionEnvironment environment, final @NotNull Supplier<JestCoverageConfig> coverageConfigSupplier) {
        if (descriptor2 == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(10);
        }
        if (state2 == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(11);
        }
        if (environment == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(12);
        }
        if (coverageConfigSupplier == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(13);
        }
        final AtomicBoolean restarted = new AtomicBoolean(false);
        ((SMTRunnerConsoleView)descriptor2.getExecutionConsole()).getResultsViewer().addEventsListener(new TestResultsViewer.EventsListener(){

            public void onTestingStarted(@NotNull TestResultsViewer sender) {
                if (sender == null) {
                    2.$$$reportNull$$$0(0);
                }
                restarted.set(true);
            }

            public void onTestingFinished(@NotNull TestResultsViewer sender) {
                if (sender == null) {
                    2.$$$reportNull$$$0(1);
                }
                restarted.set(false);
                JestCoverageConfig coverageConfig = (JestCoverageConfig)coverageConfigSupplier.get();
                if (coverageConfig == null) {
                    JestCoverageProgramRunner.showError(environment.getProject(), JavaScriptBundle.message("jest.coverage.directory.not.found.notification.content", new Object[0]));
                    LOG.warn("Cannot find coverageDirectory option from Jest configuration");
                    return;
                }
                final File lcovFile = new File(coverageConfig.getCoverageDirectory().toFile(), "lcov.info");
                final AtomicBoolean processedWithLcovFile = new AtomicBoolean(false);
                final FileModificationsSettledDownTracker tracker = new FileModificationsSettledDownTracker(lcovFile.toString(), 10, 100, 5, 300, () -> !environment.getProject().isDisposed() && !Disposer.isDisposed((Disposable)environment) && !restarted.get(), () -> JestCoverageProgramRunner.processWithLcovFile(environment, lcovFile, processedWithLcovFile, state2));
                ProcessHandler processHandler = descriptor2.getProcessHandler();
                if (processHandler != null) {
                    if (Disposer.isDisposed((Disposable)environment)) {
                        LOG.warn("Already disposed " + environment);
                        return;
                    }
                    processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void processTerminated(@NotNull ProcessEvent event) {
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            JestCoverageProgramRunner.processWithLcovFile(environment, lcovFile, processedWithLcovFile, state2);
                            tracker.stop();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/jest/coverage/JestCoverageProgramRunner$2$1", "processTerminated"));
                        }
                    }, (Disposable)environment);
                    if (processHandler.isProcessTerminated()) {
                        JestCoverageProgramRunner.processWithLcovFile(environment, lcovFile, processedWithLcovFile, state2);
                        tracker.stop();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "sender";
                objectArray2[1] = "com/intellij/javascript/jest/coverage/JestCoverageProgramRunner$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTestingStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTestingFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void processWithLcovFile(@NotNull ExecutionEnvironment env, @NotNull File lcovFile, @NotNull AtomicBoolean processed, @NotNull JestRunProfileState jestState) {
        if (env == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(14);
        }
        if (lcovFile == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(15);
        }
        if (processed == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(16);
        }
        if (jestState == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(17);
        }
        if (processed.compareAndSet(false, true)) {
            ReadAction.run(() -> {
                if (!Disposer.isDisposed((Disposable)env)) {
                    JestCoverageProgramRunner.updateCoverageView(env, lcovFile, jestState);
                }
            });
        }
    }

    private static void updateCoverageView(@NotNull ExecutionEnvironment env, @NotNull File lcovFile, @NotNull JestRunProfileState jestState) {
        if (env == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(18);
        }
        if (lcovFile == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(19);
        }
        if (jestState == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(20);
        }
        RunConfigurationBase runConfiguration = (RunConfigurationBase)env.getRunProfile();
        CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)runConfiguration);
        CoverageHelper.resetCoverageSuit((RunConfigurationBase)runConfiguration);
        String coverageFilePath = coverageEnabledConfiguration.getCoverageFilePath();
        if (coverageFilePath == null) {
            return;
        }
        if (!lcovFile.isFile()) {
            JestCoverageProgramRunner.showError(env.getProject(), JavaScriptBundle.message("jest.coverage.cannot.find.lcov.info.notification.content", lcovFile.getAbsolutePath()));
            LOG.warn("Cannot find Jest coverage: " + lcovFile.getAbsolutePath());
            return;
        }
        try {
            FileUtil.copy((File)lcovFile, (File)new File(coverageFilePath));
        }
        catch (IOException e) {
            LOG.error("Cannot copy " + lcovFile.getAbsolutePath() + " to " + coverageFilePath, (Throwable)e);
            return;
        }
        RunnerSettings runnerSettings = env.getRunnerSettings();
        if (runnerSettings != null) {
            JestCoverageRunner coverageRunner = JestCoverageRunner.getInstance();
            coverageRunner.setWorkingDirectory(jestState.getRunSettings().getWorkingDirSystemDependentPath());
            coverageRunner.setInterpreter(jestState.getRunSettings().getInterpreterRef().resolve(env.getProject()));
            CoverageDataManager.getInstance((Project)env.getProject()).processGatheredCoverage(runConfiguration, runnerSettings);
        }
    }

    private static void showError(@NotNull Project project, @NotNull @NlsContexts.NotificationContent String content) {
        if (project == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(21);
        }
        if (content == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(22);
        }
        JestUtil.notify(project, JavaScriptBundle.message("jest.coverage.notification.title", new Object[0]), content, NotificationType.ERROR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/jest/coverage/JestCoverageProgramRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeningForCoverageConfig";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageConfigSupplier";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lcovFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jestState";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/jest/coverage/JestCoverageProgramRunner";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageConfigSupplier";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurationData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCoverageConfigSupplier";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processWithLcovFile";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateCoverageView";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Service(value={Service.Level.PROJECT})
    public static final class JestCoverageDisposable
    implements Disposable {
        public void dispose() {
        }

        @NotNull
        public static JestCoverageDisposable getInstance(@NotNull Project project) {
            if (project == null) {
                JestCoverageDisposable.$$$reportNull$$$0(0);
            }
            JestCoverageDisposable jestCoverageDisposable = (JestCoverageDisposable)project.getService(JestCoverageDisposable.class);
            if (jestCoverageDisposable == null) {
                JestCoverageDisposable.$$$reportNull$$$0(1);
            }
            return jestCoverageDisposable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/jest/coverage/JestCoverageProgramRunner$JestCoverageDisposable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/jest/coverage/JestCoverageProgramRunner$JestCoverageDisposable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getInstance";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

