/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.local;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterTargetRunSetup;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeAsdfUtil;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.javascript.nodejs.util.DefaultNodePackageRefResolver;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsLocalInterpreter
extends NodeJsInterpreter {
    public static final String NPM_PACKAGE_NAME = "npm";
    public static final String YARN_PACKAGE_NAME = "yarn";
    private static final Logger LOG = Logger.getInstance(NodeJsLocalInterpreter.class);
    private static final String NPM_EXECUTABLE_NAME = SystemInfo.isWindows ? "npm.cmd" : "npm";
    static final String WIN_EXE_EXT = ".exe";
    private static final int BLOCKING_WAIT_TIMEOUT_MILLIS = 2000;
    private static final int TOTAL_WAIT_TIMEOUT_MILLIS = 30000;
    private static final String NPM_CLI_JS_RELATIVE_PATH = "bin" + File.separator + "npm-cli.js";
    @NlsSafe
    private final String myInterpreterSystemIndependentPath;
    @NlsSafe
    private final String myInterpreterSystemDependentPath;
    private final File myInterpreter;
    private volatile String myNpmPackageDir;
    private volatile boolean myNpmDetected;
    private FutureTask<String> myConfigPrefixFuture;
    private final Object myConfigPrefixFutureLock;
    private volatile int mySwitchesOutside;

    public NodeJsLocalInterpreter(@NotNull String interpreterPath) {
        if (interpreterPath == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(0);
        }
        this.myNpmDetected = false;
        this.myConfigPrefixFutureLock = new Object();
        this.mySwitchesOutside = -1;
        this.myInterpreterSystemIndependentPath = FileUtil.toSystemIndependentName((String)interpreterPath);
        this.myInterpreterSystemDependentPath = FileUtil.toSystemDependentName((String)interpreterPath);
        this.myInterpreter = new File(interpreterPath);
    }

    @Override
    @NotNull
    public String getReferenceName() {
        String path2 = this.myInterpreterSystemIndependentPath;
        if (SystemInfo.isWindows && path2.endsWith(WIN_EXE_EXT)) {
            path2 = path2.substring(0, path2.length() - WIN_EXE_EXT.length());
        }
        String string = path2;
        if (string == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String userHome = FileUtil.toSystemDependentName((String)SystemProperties.getUserHome());
        if (StringUtil.isEmptyOrSpaces((String)userHome)) {
            String string = this.myInterpreterSystemDependentPath;
            if (string == null) {
                NodeJsLocalInterpreter.$$$reportNull$$$0(2);
            }
            return string;
        }
        String userHomeWithSeparator = (userHome = StringUtil.trimEnd((String)userHome, (char)File.separatorChar)) + File.separatorChar;
        if (this.myInterpreterSystemDependentPath.startsWith(userHomeWithSeparator)) {
            String string = "~" + this.myInterpreterSystemDependentPath.substring(userHome.length());
            if (string == null) {
                NodeJsLocalInterpreter.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = this.myInterpreterSystemDependentPath;
        if (string == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    public Ref<SemVer> getCachedVersion() {
        return NodeJsLocalInterpreterManager.getInstance().getCachedVersion(this);
    }

    @Override
    public void fetchVersion(@NotNull NullableConsumer<? super SemVer> consumer) {
        if (consumer == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(5);
        }
        NodeJsLocalInterpreterManager.getInstance().fetchVersion(this, consumer);
    }

    @Override
    @Nullable
    public String validate(@Nullable Project project) {
        return this.isValid() ? null : JavaScriptBundle.message("node.interpreter.specified_interpreter_correctly.dialog.message", new Object[0]);
    }

    @NotNull
    public String getInterpreterSystemDependentPath() {
        String string = this.myInterpreterSystemDependentPath;
        if (string == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getInterpreterSystemIndependentPath() {
        String string = this.myInterpreterSystemIndependentPath;
        if (string == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isValid() {
        return this.myInterpreter.isFile() && this.myInterpreter.canExecute();
    }

    @NotNull
    public NodeJsLocalInterpreterType getType() {
        NodeJsLocalInterpreterType nodeJsLocalInterpreterType = NodeJsLocalInterpreterType.getInstance();
        if (nodeJsLocalInterpreterType == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(8);
        }
        return nodeJsLocalInterpreterType;
    }

    @Override
    public boolean deepEquals(@Nullable NodeJsInterpreter other) {
        return this.equals(other) && ComparatorUtil.equalsNullable((Object)this.myNpmPackageDir, (Object)((NodeJsLocalInterpreter)other).myNpmPackageDir);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeJsLocalInterpreter that = (NodeJsLocalInterpreter)o;
        return this.myInterpreterSystemIndependentPath.equals(that.myInterpreterSystemIndependentPath);
    }

    public int hashCode() {
        return this.myInterpreterSystemIndependentPath.hashCode();
    }

    public String toString() {
        return this.myInterpreterSystemIndependentPath;
    }

    @NotNull
    @NlsSafe
    public String getNpmPackageDir() {
        String npmPackageDirPath;
        if (NodeAsdfUtil.isShimsNode(this)) {
            NodeJsLocalInterpreter resolvedShimNode;
            int switches = NodeJsLocalInterpreterManager.getInstance().getSwitchesOutside();
            if (this.mySwitchesOutside != switches) {
                this.mySwitchesOutside = switches;
                this.myNpmPackageDir = null;
            }
            if (this.myNpmPackageDir == null && (resolvedShimNode = NodeAsdfUtil.resolveShimsNode(this)) != null) {
                this.myNpmPackageDir = resolvedShimNode.getNpmPackageDir();
            }
        }
        if ((npmPackageDirPath = this.myNpmPackageDir) != null) {
            String string = npmPackageDirPath;
            if (string == null) {
                NodeJsLocalInterpreter.$$$reportNull$$$0(9);
            }
            return string;
        }
        File npmPackageDir = this.detectNpmPackageDir();
        this.myNpmPackageDir = npmPackageDirPath = npmPackageDir != null ? npmPackageDir.getAbsolutePath() : "";
        this.myNpmDetected = true;
        String string = npmPackageDirPath;
        if (string == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    private File detectNpmPackageDir() {
        File npmExecutable;
        File binDir;
        if (this.myInterpreter.isFile() && (binDir = this.myInterpreter.getParentFile()) != null) {
            File npmPackageDir = NodeJsLocalInterpreter.guessNpmPackageDirByNpmBinDir(binDir);
            if (npmPackageDir != null) {
                return npmPackageDir;
            }
            npmPackageDir = this.guessNpmPackageDirForNodist();
            if (npmPackageDir != null) {
                return npmPackageDir;
            }
            npmPackageDir = this.guessNpmPackageDirForSnap();
            if (npmPackageDir != null) {
                return npmPackageDir;
            }
            if (this.myInterpreterSystemIndependentPath.contains("/Cellar/") && (npmPackageDir = new File(binDir, "libexec/npm")).isDirectory()) {
                return npmPackageDir;
            }
        }
        if ((npmExecutable = PathEnvironmentVariableUtil.findInPath((String)NPM_EXECUTABLE_NAME, null)) != null) {
            return DefaultNodePackageRefResolver.findPackageDir(npmExecutable);
        }
        return null;
    }

    @Nullable
    private File guessNpmPackageDirForSnap() {
        File dir;
        if (this.isSnapInstallation() && (dir = new File("/snap/node/current/lib/node_modules/npm")).isDirectory()) {
            return dir;
        }
        return null;
    }

    public boolean isSnapInstallation() {
        return this.myInterpreterSystemIndependentPath.equals("/snap/bin/node");
    }

    @Nullable
    private File guessNpmPackageDirForNodist() {
        File npmDir;
        String nodistPrefix = NodeJsLocalInterpreter.getWinNodistPrefixSystemIndependent();
        if (nodistPrefix != null && this.myInterpreterSystemIndependentPath.startsWith(nodistPrefix) && (npmDir = new File(nodistPrefix, NPM_PACKAGE_NAME)).isDirectory()) {
            return npmDir;
        }
        return null;
    }

    @Nullable
    private static String getWinNodistPrefixSystemIndependent() {
        String nodistPrefix;
        if (SystemInfo.isWindows && StringUtil.isNotEmpty((String)(nodistPrefix = EnvironmentUtil.getValue((String)"NODIST_PREFIX")))) {
            return (nodistPrefix = FileUtil.toSystemIndependentName((String)nodistPrefix)).endsWith("/") ? nodistPrefix : nodistPrefix + "/";
        }
        return null;
    }

    public boolean isWrapperSwitchingVersionsInside() {
        String nodistPrefix = NodeJsLocalInterpreter.getWinNodistPrefixSystemIndependent();
        if (nodistPrefix != null && this.myInterpreterSystemIndependentPath.startsWith(nodistPrefix)) {
            return PathUtil.getParentPath((String)this.myInterpreterSystemIndependentPath).equals(nodistPrefix + "bin");
        }
        return NodeAsdfUtil.isShimsNode(this);
    }

    @Nullable
    public VirtualFile getGlobalNodeModulesVirtualDir() {
        File globalNodeModulesDir;
        String configPrefix = this.getConfigPrefix();
        if (StringUtil.isNotEmpty((String)configPrefix) && (globalNodeModulesDir = SystemInfo.isWindows ? new File(configPrefix, "node_modules") : new File(configPrefix, "lib/node_modules")).isDirectory()) {
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByIoFile(globalNodeModulesDir);
            if (file2 == null) {
                if (ApplicationManager.getApplication().isWriteThread() && TransactionGuard.getInstance().isWriteSafeModality(ModalityState.defaultModalityState())) {
                    file2 = (VirtualFile)WriteAction.compute(() -> NodeJsLocalInterpreter.refresh(globalNodeModulesDir, true));
                } else {
                    ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> WriteAction.run(() -> NodeJsLocalInterpreter.refresh(globalNodeModulesDir, false)));
                }
            }
            return file2;
        }
        return null;
    }

    @Nullable
    private static VirtualFile refresh(@NotNull File globalNodeModulesDir, boolean sync) {
        if (globalNodeModulesDir == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(11);
        }
        VirtualFile result2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(globalNodeModulesDir);
        LOG.info("Npm global node_modules (" + globalNodeModulesDir + ") " + (sync ? "sync" : "async") + " refresh: " + (result2 != null ? "success" : "not found"));
        return result2;
    }

    @Nullable
    public String getConfigPrefix() {
        String configPrefix = this.fetchConfigPrefix();
        if (StringUtil.isEmpty((String)configPrefix) || !new File(configPrefix).isDirectory()) {
            configPrefix = this.guessConfigPrefix();
            LOG.info("Guessed config prefix for " + this.myInterpreterSystemDependentPath + ": " + configPrefix);
        }
        return configPrefix;
    }

    @Nullable
    private String guessConfigPrefix() {
        File npmDir;
        String appDataDirPath;
        File interpreterDir = this.myInterpreter.getParentFile();
        if (interpreterDir == null) {
            return null;
        }
        if (SystemInfo.isWindows && !NodeJsLocalInterpreter.isEmptyNpmRc(interpreterDir) && !(appDataDirPath = StringUtil.notNullize((String)EnvironmentUtil.getValue((String)"APPDATA")).trim()).isEmpty() && (npmDir = new File(appDataDirPath, NPM_PACKAGE_NAME)).isAbsolute() && npmDir.isDirectory()) {
            return npmDir.getAbsolutePath();
        }
        if (SystemInfo.isWindows) {
            return interpreterDir.getAbsolutePath();
        }
        File parentDir = interpreterDir.getParentFile();
        return parentDir != null ? parentDir.getAbsolutePath() : null;
    }

    private static boolean isEmptyNpmRc(@NotNull File interpreterDir) {
        File npmRc;
        if (interpreterDir == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(12);
        }
        return (npmRc = new File(interpreterDir, "node_modules" + File.separator + NPM_PACKAGE_NAME + File.separator + "npmrc")).isFile() && npmRc.length() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String fetchConfigPrefix() {
        FutureTask<String> future;
        Object object = this.myConfigPrefixFutureLock;
        synchronized (object) {
            future = this.myConfigPrefixFuture;
            if (future == null) {
                future = new FutureTask<String>(() -> {
                    try {
                        return this.doFetchConfigPrefix();
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to run 'npm config get prefix'", (Throwable)e);
                        return null;
                    }
                });
                ApplicationManager.getApplication().executeOnPooledThread(future);
                this.myConfigPrefixFuture = future;
            }
        }
        try {
            return future.get(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted npm global package dir calculation", (Throwable)e);
        }
        catch (ExecutionException e) {
        }
        catch (TimeoutException e) {
            LOG.warn("Npm global package dir hasn't been calculated in 2000 ms, making a guess");
        }
        return null;
    }

    @NotNull
    private String doFetchConfigPrefix() throws com.intellij.execution.ExecutionException {
        String errorMessage = this.validate(null);
        if (errorMessage != null) {
            throw new com.intellij.execution.ExecutionException(errorMessage);
        }
        long startNano = System.nanoTime();
        String npmCliJsFilePath = this.getValidNpmCliJsFilePathOrDetect();
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{this.myInterpreterSystemDependentPath, npmCliJsFilePath, "config", "get", "prefix"});
        commandLine.setCharset(StandardCharsets.UTF_8);
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
        ProcessOutput output = processHandler.runProcess(30000, true);
        if (output.isTimeout()) {
            throw new com.intellij.execution.ExecutionException(JavaScriptBundle.message("node.interpreter.command_timed_out.dialog.message", commandLine.getCommandLineString(), 30000));
        }
        String dirName = output.getStdout().trim();
        LOG.info(commandLine.getCommandLineString() + "=" + dirName + " (" + TimeoutUtil.getDurationMillis((long)startNano) + " ms)");
        String string = FileUtil.expandUserHome((String)dirName);
        if (string == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private String getValidNpmCliJsFilePathOrDetect() throws com.intellij.execution.ExecutionException {
        String string;
        try {
            string = this.getValidNpmCliJsFilePath();
        }
        catch (com.intellij.execution.ExecutionException e) {
            File npmCliJsFile;
            File npmPackageDir;
            if (!this.myNpmDetected && (npmPackageDir = this.detectNpmPackageDir()) != null && (npmCliJsFile = new File(npmPackageDir, NPM_CLI_JS_RELATIVE_PATH)).isFile()) {
                String string2 = npmCliJsFile.getAbsolutePath();
                if (string2 == null) {
                    NodeJsLocalInterpreter.$$$reportNull$$$0(15);
                }
                return string2;
            }
            throw e;
        }
        if (string == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    private static File guessNpmPackageDirByNpmBinDir(@Nullable File npmBinDir) {
        if (npmBinDir == null) {
            return null;
        }
        File npmPackageDir = null;
        if (SystemInfo.isWindows) {
            npmPackageDir = new File(npmBinDir, "node_modules\\npm");
        } else {
            File parent = npmBinDir.getParentFile();
            if (parent != null) {
                npmPackageDir = new File(parent, "lib/node_modules/npm");
            }
        }
        return npmPackageDir != null && npmPackageDir.isDirectory() ? npmPackageDir : null;
    }

    public boolean isYarnAlikePackage() {
        String packageDir2 = this.getNpmPackageDir();
        String packageName = PathUtil.getFileName((String)packageDir2);
        if (StringUtil.containsIgnoreCase((String)packageName, (String)YARN_PACKAGE_NAME)) {
            return true;
        }
        return "libexec".equals(packageName) && packageDir2.contains(YARN_PACKAGE_NAME);
    }

    @NotNull
    public String getValidNpmCliJsFilePath() throws com.intellij.execution.ExecutionException {
        String npmPackageDirPath = this.getNpmPackageDir();
        if (StringUtil.isEmpty((String)npmPackageDirPath)) {
            String string = NodeJsLocalInterpreter.invalidNpmPackage(JavaScriptBundle.message("node.npm.specify_npm_or_yarn_package.dialog.message", new Object[0]));
            if (string == null) {
                NodeJsLocalInterpreter.$$$reportNull$$$0(16);
            }
            return string;
        }
        File npmPackageDir = new File(npmPackageDirPath);
        if (!npmPackageDir.isAbsolute() || !npmPackageDir.isDirectory()) {
            String string = NodeJsLocalInterpreter.invalidNpmPackage(JavaScriptBundle.message("dialog.message.please.correct.path.to.npm.or.yarn.package.no.such.directory", npmPackageDirPath));
            if (string == null) {
                NodeJsLocalInterpreter.$$$reportNull$$$0(17);
            }
            return string;
        }
        if (this.isYarnAlikePackage()) {
            return NodeJsLocalInterpreter.findValidFile(npmPackageDir, "bin" + File.separator + "yarn.js");
        }
        return NodeJsLocalInterpreter.findValidFile(npmPackageDir, NPM_CLI_JS_RELATIVE_PATH);
    }

    @NotNull
    private static String findValidFile(@NotNull File packageDir2, @NotNull String relativePath) throws com.intellij.execution.ExecutionException {
        File mainJsFile;
        if (packageDir2 == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(18);
        }
        if (relativePath == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(19);
        }
        if (!(mainJsFile = new File(packageDir2, relativePath)).isFile()) {
            String string = NodeJsLocalInterpreter.invalidNpmPackage(JavaScriptBundle.message("dialog.message.please.specify.npm.or.yarn.package.cannot.find.inside.directory", relativePath, packageDir2));
            if (string == null) {
                NodeJsLocalInterpreter.$$$reportNull$$$0(20);
            }
            return string;
        }
        String string = mainJsFile.getAbsolutePath();
        if (string == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static String invalidNpmPackage(@NotNull @NlsContexts.DialogMessage String errorMessage) throws com.intellij.execution.ExecutionException {
        if (errorMessage == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(22);
        }
        throw new com.intellij.execution.ExecutionException(errorMessage);
    }

    public boolean isElectron() {
        return this.myInterpreterSystemIndependentPath.endsWith("/Contents/MacOS/Electron") || this.myInterpreterSystemIndependentPath.endsWith("/electron") || this.myInterpreterSystemIndependentPath.endsWith("/electron.cmd");
    }

    @Nullable
    public static NodeJsLocalInterpreter tryCast(@Nullable NodeJsInterpreter interpreter) {
        return (NodeJsLocalInterpreter)ObjectUtils.tryCast((Object)interpreter, NodeJsLocalInterpreter.class);
    }

    @NotNull
    public static NodeJsLocalInterpreter cast(@Nullable NodeJsInterpreter interpreter) throws com.intellij.execution.ExecutionException {
        if (interpreter == null) {
            throw new com.intellij.execution.ExecutionException(JavaScriptBundle.message("node.interpreter.unspecified_interpreter.dialog.message", new Object[0]));
        }
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter);
        if (localInterpreter == null) {
            throw new com.intellij.execution.ExecutionException(JavaScriptBundle.message("node.interpreter.unspecified_local_interpreter.dialog.message", new Object[0]));
        }
        NodeJsLocalInterpreter nodeJsLocalInterpreter = localInterpreter;
        if (nodeJsLocalInterpreter == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(23);
        }
        return nodeJsLocalInterpreter;
    }

    @NotNull
    public static NodeJsLocalInterpreter castAndValidate(@Nullable NodeJsInterpreter interpreter) throws com.intellij.execution.ExecutionException {
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.cast(interpreter);
        if (localInterpreter.isValid()) {
            NodeJsLocalInterpreter nodeJsLocalInterpreter = localInterpreter;
            if (nodeJsLocalInterpreter == null) {
                NodeJsLocalInterpreter.$$$reportNull$$$0(24);
            }
            return nodeJsLocalInterpreter;
        }
        throw new com.intellij.execution.ExecutionException(JavaScriptBundle.message("node.interpreter.specified_interpreter_correctly.dialog.message", new Object[0]));
    }

    @Nullable
    @NlsContexts.DialogMessage
    public static String getErrorMessage(@Nullable NodeJsInterpreter interpreter) {
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter);
        if (localInterpreter == null) {
            return JavaScriptBundle.message("node.interpreter.unspecified_local_interpreter.dialog.message", new Object[0]);
        }
        return localInterpreter.validate(null);
    }

    public static void checkForRunConfiguration(@Nullable NodeJsInterpreter interpreter) throws RuntimeConfigurationError {
        String errorMessage = NodeJsLocalInterpreter.getErrorMessage(interpreter);
        if (errorMessage != null) {
            throw new RuntimeConfigurationError(errorMessage);
        }
    }

    @Override
    @NotNull
    public NodeInterpreterTargetRunSetup createTargetRunSetup(@NotNull Project project, @NotNull NodeTargetRun.Options options) throws com.intellij.execution.ExecutionException {
        if (project == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(25);
        }
        if (options == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(26);
        }
        final LocalTargetEnvironmentRequest request = new LocalTargetEnvironmentRequest();
        request.setPtyOptions(options.getPtyOptions());
        return new NodeInterpreterTargetRunSetup((TargetEnvironmentRequest)request){

            @Override
            public void configureCommandLine(@NotNull TargetedCommandLineBuilder commandLineBuilder) {
                if (commandLineBuilder == null) {
                    1.$$$reportNull$$$0(0);
                }
                commandLineBuilder.setExePath(NodeJsLocalInterpreter.this.myInterpreterSystemDependentPath);
            }

            @Override
            public void configureEnvironment(@NotNull TargetedCommandLineBuilder commandLineBuilder, @NotNull EnvironmentVariablesData envData) {
                if (commandLineBuilder == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (envData == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.configureEnvironment(commandLineBuilder, envData);
                request.setParentEnvironmentType(envData.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "commandLineBuilder";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "envData";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "configureCommandLine";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "configureEnvironment";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalNodeModulesDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterDir";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDir";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterSystemDependentPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterSystemIndependentPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNpmPackageDir";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "doFetchConfigPrefix";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidNpmCliJsFilePathOrDetect";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidNpmCliJsFilePath";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findValidFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "cast";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "castAndValidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fetchVersion";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyNpmRc";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findValidFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "invalidNpmPackage";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createTargetRunSetup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

