/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.insight;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunContextAction;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.javascript.testing.JSTestFailedLineManager;
import com.intellij.javascript.testing.insight.SelectInTestTree;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTestFailedLineInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSTestFailedLineInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSTestFailedLineInspection.$$$reportNull$$$0(1);
        }
        final JSTestFailedLineManager manager2 = JSTestFailedLineManager.getInstance(holder.getProject());
        return new JSElementVisitor(){

            @Override
            public void visitJSCallExpression(JSCallExpression node) {
                JSFile file2;
                JSExpression methodExpr = node.getStubSafeMethodExpression();
                if (methodExpr != null && (file2 = (JSFile)ObjectUtils.tryCast((Object)node.getContainingFile(), JSFile.class)) != null) {
                    if (methodExpr instanceof JSReferenceExpression) {
                        methodExpr = ((JSReferenceExpression)methodExpr).getReferenceNameElement();
                    }
                    if (methodExpr != null) {
                        JSTestFailedLineInspection.visitCallMethodExpr(manager2, (PsiElement)methodExpr, holder);
                    }
                }
                super.visitJSCallExpression(node);
            }

            @Override
            public void visitJSDestructuringProperty(JSDestructuringProperty destructuringProperty) {
                if (!destructuringProperty.isRest()) {
                    PsiElement identifier;
                    JSVariable destructuringElement = (JSVariable)ObjectUtils.tryCast((Object)destructuringProperty.getDestructuringElement(), JSVariable.class);
                    PsiElement psiElement = identifier = destructuringElement != null ? destructuringElement.getNameIdentifier() : null;
                    if (identifier != null) {
                        JSTestFailedLineInspection.visitCallMethodExpr(manager2, identifier, holder);
                    }
                }
            }
        };
    }

    private static void visitCallMethodExpr(@NotNull JSTestFailedLineManager failedLineManager, @NotNull PsiElement methodExpr, @NotNull ProblemsHolder holder) {
        JSTestFailedLineManager.FailedTestInfo info;
        if (failedLineManager == null) {
            JSTestFailedLineInspection.$$$reportNull$$$0(2);
        }
        if (methodExpr == null) {
            JSTestFailedLineInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            JSTestFailedLineInspection.$$$reportNull$$$0(4);
        }
        if ((info = failedLineManager.getFailedLineInfoForElement(methodExpr)) != null) {
            ArrayList<RunActionFix> fixes = new ArrayList<RunActionFix>();
            ContainerUtil.addIfNotNull(fixes, (Object)DebugFailedTestFix.create(methodExpr));
            fixes.add(new RunActionFix(methodExpr));
            ContainerUtil.addIfNotNull(fixes, (Object)SelectInTestTree.create(methodExpr));
            String text = info.getMessage();
            if (StringUtil.isEmptyOrSpaces((String)text)) {
                text = JavaScriptBundle.message("inspection.message.sm.test.runner.magnitude.assertion.failed.title", new Object[0]);
            }
            ProblemDescriptor descriptor2 = InspectionManager.getInstance((Project)methodExpr.getProject()).createProblemDescriptor(methodExpr, text, holder.isOnTheFly(), fixes.toArray(LocalQuickFix.EMPTY_ARRAY), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            descriptor2.setTextAttributes(CodeInsightColors.RUNTIME_ERROR);
            holder.registerProblem(descriptor2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failedLineManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpr";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/testing/insight/JSTestFailedLineInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCallMethodExpr";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ExecutorActionFix
    implements LocalQuickFix,
    Iconable {
        private final ConfigurationContext myContext;
        private final Executor myExecutor;
        private final RunnerAndConfigurationSettings myConfiguration;

        ExecutorActionFix(@NotNull PsiElement element, @NotNull Executor executor) {
            if (element == null) {
                ExecutorActionFix.$$$reportNull$$$0(0);
            }
            if (executor == null) {
                ExecutorActionFix.$$$reportNull$$$0(1);
            }
            this.myExecutor = executor;
            this.myContext = new ConfigurationContext(element);
            this.myConfiguration = this.myContext.getConfiguration();
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            @NlsSafe String text = this.myExecutor.getStartActionText(ProgramRunnerUtil.shortenName((String)this.myConfiguration.getName(), (int)0));
            String string = UIUtil.removeMnemonic((String)text);
            if (string == null) {
                ExecutorActionFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                ExecutorActionFix.$$$reportNull$$$0(3);
            }
            if (descriptor2 == null) {
                ExecutorActionFix.$$$reportNull$$$0(4);
            }
            new RunContextAction(this.myExecutor){
                {
                    super(arg0);
                    this.perform(myContext);
                }
            };
        }

        public Icon getIcon(int flags) {
            return this.myExecutor.getIcon();
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/testing/insight/JSTestFailedLineInspection$ExecutorActionFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/testing/insight/JSTestFailedLineInspection$ExecutorActionFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RunActionFix
    extends ExecutorActionFix {
        RunActionFix(@NotNull PsiElement element) {
            if (element == null) {
                RunActionFix.$$$reportNull$$$0(0);
            }
            super(element, Objects.requireNonNull(DefaultRunExecutor.getRunExecutorInstance()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/testing/insight/JSTestFailedLineInspection$RunActionFix", "<init>"));
        }
    }

    private static class DebugFailedTestFix
    extends ExecutorActionFix {
        private final SmartPsiElementPointer<PsiElement> myPointer;
        private final XLineBreakpointType<?> myJsBreakpointType;

        DebugFailedTestFix(PsiElement element, @NotNull Executor debugExecutor, @NotNull XLineBreakpointType<?> jsBreakpointType) {
            if (debugExecutor == null) {
                DebugFailedTestFix.$$$reportNull$$$0(0);
            }
            if (jsBreakpointType == null) {
                DebugFailedTestFix.$$$reportNull$$$0(1);
            }
            super(element, debugExecutor);
            this.myPointer = SmartPointerManager.createPointer((PsiElement)element);
            this.myJsBreakpointType = jsBreakpointType;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                DebugFailedTestFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                DebugFailedTestFix.$$$reportNull$$$0(3);
            }
            PsiElement element = this.myPointer.getElement();
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element);
            if (element == null || file2 == null) {
                return;
            }
            Document document2 = FileDocumentManager.getInstance().getDocument(file2);
            if (document2 == null) {
                return;
            }
            PsiElement debugElement = (PsiElement)ObjectUtils.notNull((Object)PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class, (boolean)true), (Object)element);
            int line = document2.getLineNumber(debugElement.getTextRange().getStartOffset());
            WriteAction.run(() -> {
                XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
                boolean breakpointSet = breakpointManager.getBreakpoints(this.myJsBreakpointType).stream().anyMatch(breakpoint -> file2.getUrl().equals(breakpoint.getFileUrl()) && line == breakpoint.getLine());
                if (!breakpointSet) {
                    breakpointManager.addLineBreakpoint(this.myJsBreakpointType, file2.getUrl(), line, null, true);
                }
            });
            super.applyFix(project, descriptor2);
        }

        @Nullable
        private static DebugFailedTestFix create(@NotNull PsiElement element) {
            if (element == null) {
                DebugFailedTestFix.$$$reportNull$$$0(4);
            }
            Executor debugExecutor = DefaultDebugExecutor.getDebugExecutorInstance();
            XLineBreakpointType<?> jsLineBreakpointType = DebugFailedTestFix.findJavaScriptLineBreakpointType();
            if (debugExecutor != null && jsLineBreakpointType != null) {
                return new DebugFailedTestFix(element, debugExecutor, jsLineBreakpointType);
            }
            return null;
        }

        @Nullable
        private static XLineBreakpointType<?> findJavaScriptLineBreakpointType() {
            XBreakpointType jsType2 = (XBreakpointType)ContainerUtil.find((Iterable)XBreakpointType.EXTENSION_POINT_NAME.getExtensionList(), type -> "javascript".equals(type.getId()));
            return (XLineBreakpointType)ObjectUtils.tryCast((Object)jsType2, XLineBreakpointType.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugExecutor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jsBreakpointType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/testing/insight/JSTestFailedLineInspection$DebugFailedTestFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

