/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.linter.stylelint;

import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StylelintUtil {
    public static final String PACKAGE_NAME = "stylelint";
    public static final String DEFAULT_CONFIG_PREFIX = ".stylelintrc";
    public static final String IGNORE_FILE = ".stylelintignore";
    private static final String CONFIG_JS_FILE_NAME = "stylelint.config.js";
    private static final String[] CONFIG_EXTENSIONS = new String[]{"", ".js", ".yaml", ".yml", ".json"};
    public static final String[] CONFIG_FILE_NAMES = new String[CONFIG_EXTENSIONS.length + 1];
    public static final String[] CONFIG_FILE_NAMES_WITH_PACKAGE_JSON = new String[CONFIG_EXTENSIONS.length + 2];

    @Nullable
    public static VirtualFile findWorkingDirectory(@NotNull VirtualFile fileToLint) {
        VirtualFile parent;
        if (fileToLint == null) {
            StylelintUtil.$$$reportNull$$$0(0);
        }
        if ((parent = fileToLint.getParent()) == null) {
            return null;
        }
        VirtualFile ignoreFile = JSLinterConfigFileUtil.findFileUpToFileSystemRoot(parent, IGNORE_FILE);
        VirtualFile ignoreFileParent = ignoreFile != null ? ignoreFile.getParent() : null;
        return (VirtualFile)ObjectUtils.chooseNotNull((Object)ignoreFileParent, (Object)parent);
    }

    @NotNull
    public static Collection<VirtualFile> getPossibleConfigs(@NotNull VirtualFile dir) {
        if (dir == null) {
            StylelintUtil.$$$reportNull$$$0(1);
        }
        List<VirtualFile> list2 = JSLinterConfigFileUtil.findAllFilesUpToFileSystemRoot(dir, CONFIG_FILE_NAMES_WITH_PACKAGE_JSON);
        if (list2 == null) {
            StylelintUtil.$$$reportNull$$$0(2);
        }
        return list2;
    }

    public static boolean isStylelintConfigFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            StylelintUtil.$$$reportNull$$$0(3);
        }
        return file2.isValid() && !file2.isDirectory() && ArrayUtil.contains((String)file2.getName(), (String[])CONFIG_FILE_NAMES);
    }

    static {
        StylelintUtil.CONFIG_FILE_NAMES_WITH_PACKAGE_JSON[0] = CONFIG_JS_FILE_NAME;
        StylelintUtil.CONFIG_FILE_NAMES[0] = CONFIG_JS_FILE_NAME;
        for (int i2 = 0; i2 < CONFIG_EXTENSIONS.length; ++i2) {
            String string = DEFAULT_CONFIG_PREFIX + CONFIG_EXTENSIONS[i2];
            StylelintUtil.CONFIG_FILE_NAMES_WITH_PACKAGE_JSON[i2 + 1] = string;
            StylelintUtil.CONFIG_FILE_NAMES[i2 + 1] = string;
        }
        StylelintUtil.CONFIG_FILE_NAMES_WITH_PACKAGE_JSON[StylelintUtil.CONFIG_FILE_NAMES_WITH_PACKAGE_JSON.length - 1] = "package.json";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToLint";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/css/linter/stylelint/StylelintUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/css/linter/stylelint/StylelintUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleConfigs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findWorkingDirectory";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleConfigs";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isStylelintConfigFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

