/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNodeModulesHandlerScope
extends DelegatingGlobalSearchScope {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<String> myModules;
    @NotNull
    private final Set<String> myExcludedPackages;
    @Nullable
    protected final JSModuleStatusOwner.ModuleStatus myStatus;

    public JSNodeModulesHandlerScope(@NotNull Project project, @NotNull VirtualFile contextFile, @NotNull GlobalSearchScope baseScope, @Nullable JSModuleStatusOwner.ModuleStatus status) {
        if (project == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(0);
        }
        if (contextFile == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(1);
        }
        if (baseScope == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(2);
        }
        super(baseScope);
        this.myProject = project;
        this.myModules = JSNodeModulesHandlerScope.getAcceptableModules(project, contextFile);
        this.myExcludedPackages = JSNodeModulesHandlerScope.getExcludedModules(this.myModules);
        this.myStatus = status;
    }

    public final boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(3);
        }
        if (!super.contains(file2)) {
            return false;
        }
        NodeModuleUtil.NodeModuleStructure structure = NodeModuleUtil.getNodeModuleStructure(this.myProject, file2);
        return structure == null ? this.isAcceptableProjectFile(file2) : this.isAcceptableNodeModulesFile(file2, structure);
    }

    protected boolean isAcceptableProjectFile(@NotNull VirtualFile toCheck) {
        if (toCheck == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(4);
        }
        return true;
    }

    protected boolean isAcceptableNodeModulesFile(@NotNull VirtualFile toCheck, @NotNull NodeModuleUtil.NodeModuleStructure structure) {
        if (toCheck == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(5);
        }
        if (structure == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(6);
        }
        String packageName = structure.getPackageName();
        if (structure.isFromTypes() && !this.myModules.contains(packageName) && !this.myModules.contains(structure.getOriginalPackageName())) {
            return false;
        }
        return (this.myModules.contains(packageName) || this.myModules.contains(structure.getOriginalPackageName())) && !this.myExcludedPackages.contains(packageName);
    }

    private static Set<String> getExcludedModules(@NotNull Set<String> moduleNames) {
        if (moduleNames == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(7);
        }
        HashSet<String> toRemove = new HashSet<String>();
        for (String name : moduleNames) {
            if (!name.startsWith("@types/")) continue;
            String realName = ES6CreateImportUtil.convertScopedTypesName(name.substring("@types/".length()));
            toRemove.add(realName);
        }
        return toRemove;
    }

    @NotNull
    public static Set<String> getAcceptableModules(@NotNull Project project, @NotNull VirtualFile contextFile) {
        PackageJsonFileManager manager2;
        Set<VirtualFile> files;
        if (project == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(8);
        }
        if (contextFile == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(9);
        }
        if ((files = (manager2 = PackageJsonFileManager.getInstance(project)).getValidPackageJsonFiles()).isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                JSNodeModulesHandlerScope.$$$reportNull$$$0(10);
            }
            return set;
        }
        HashSet<String> moduleNames = new HashSet<String>();
        for (VirtualFile file2 : files) {
            VirtualFile directory = file2.getParent();
            if (!VfsUtilCore.isAncestor((VirtualFile)directory, (VirtualFile)contextFile, (boolean)true)) continue;
            PackageJsonData data = PackageJsonData.getOrCreate(file2);
            moduleNames.addAll(data.getAllDependencies());
        }
        HashSet<String> hashSet = moduleNames;
        if (hashSet == null) {
            JSNodeModulesHandlerScope.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCheck";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNames";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/JSNodeModulesHandlerScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/JSNodeModulesHandlerScope";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptableModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableProjectFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableNodeModulesFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExcludedModules";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAcceptableModules";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

