/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.EmptyNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionKeyword;
import com.intellij.lang.javascript.completion.JSKeywordInsertHandlerBase;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.macro.JSSuggestVariableNameMacro;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSKeywordTemplateInsertHandlers {
    private static final InsertHandler<LookupElement> STATEMENT_WITH_PARENS_AND_BLOCK_INSERT_HANDLER = new JSWithFollowingElementInsertHandler(){

        @Override
        @NotNull
        protected Template getTemplate() {
            Template template = STATEMENT_WITH_PARENS_AND_BLOCK_TEMPLATE;
            if (template == null) {
                1.$$$reportNull$$$0(0);
            }
            return template;
        }

        @Override
        @NotNull
        protected IElementType getElementType() {
            IElementType iElementType = JSTokenTypes.LPAR;
            if (iElementType == null) {
                1.$$$reportNull$$$0(1);
            }
            return iElementType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/javascript/completion/JSKeywordTemplateInsertHandlers$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTemplate";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementType";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    private static final InsertHandler<LookupElement> TS_REQUIRE_INSERT_HANDLER = new JSWithFollowingElementInsertHandler(){

        @Override
        @NotNull
        protected Template getTemplate() {
            Template template = REQUIRE_ARG_TEMPLATE;
            if (template == null) {
                2.$$$reportNull$$$0(0);
            }
            return template;
        }

        @Override
        @NotNull
        protected IElementType getElementType() {
            IElementType iElementType = JSTokenTypes.LPAR;
            if (iElementType == null) {
                2.$$$reportNull$$$0(1);
            }
            return iElementType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/javascript/completion/JSKeywordTemplateInsertHandlers$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTemplate";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementType";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    static final InsertHandler<LookupElement> STATEMENT_WITH_BLOCK_INSERT_HANDLER = new JSWithFollowingElementInsertHandler(){

        @Override
        @NotNull
        protected Template getTemplate() {
            Template template = ENTITY_WITH_BLOCK_TEMPLATE;
            if (template == null) {
                3.$$$reportNull$$$0(0);
            }
            return template;
        }

        @Override
        @NotNull
        protected IElementType getElementType() {
            IElementType iElementType = JSTokenTypes.LBRACE;
            if (iElementType == null) {
                3.$$$reportNull$$$0(1);
            }
            return iElementType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/javascript/completion/JSKeywordTemplateInsertHandlers$3";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTemplate";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementType";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    private static final InsertHandler<LookupElement> CATCH_BLOCK_INSERT_HANDLER = new JSWithFollowingElementInsertHandler(){

        @Override
        @NotNull
        protected Template getTemplate() {
            Template template = CATCH_BLOCK_TEMPLATE;
            if (template == null) {
                4.$$$reportNull$$$0(0);
            }
            return template;
        }

        @Override
        @NotNull
        protected IElementType getElementType() {
            IElementType iElementType = JSTokenTypes.LBRACE;
            if (iElementType == null) {
                4.$$$reportNull$$$0(1);
            }
            return iElementType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/javascript/completion/JSKeywordTemplateInsertHandlers$4";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTemplate";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementType";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    private static final InsertHandler<LookupElement> INTERFACE_KEYWORD_INSERT_HANDLER = new NamedTypeInsertHandler(){

        @Override
        @NotNull
        protected String getKeywordText() {
            return "interface";
        }
    };
    private static final InsertHandler<LookupElement> ENUM_KEYWORD_INSERT_HANDLER = new NamedTypeInsertHandler(){

        @Override
        @NotNull
        protected String getKeywordText() {
            return "enum";
        }
    };
    private static final InsertHandler<LookupElement> FUNCTION_KEYWORD_INSERT_HANDLER = new JSKeywordInsertHandlerBase(){

        @Override
        @Nullable
        protected Template applyAndCreateTemplate(InsertionContext context, PsiFile file2, PsiElement at) {
            PsiElement parent;
            Template template = null;
            if (at != null && at.getNode().getElementType() == JSTokenTypes.FUNCTION_KEYWORD && (parent = at.getParent()) instanceof JSFunction && !(at.getNextSibling() instanceof JSParameterList)) {
                if (parent instanceof JSFunctionExpression) {
                    template = FUNCTION_EXPRESSION_TEMPLATE;
                } else if (DialectDetector.isJavaScriptFamily((PsiElement)file2)) {
                    template = DialectDetector.isTypeScript((PsiElement)file2) && TypeScriptPsiUtil.isAmbientDeclaration(parent) ? FUNCTION_TEMPLATE_NO_BODY : FUNCTION_TEMPLATE;
                } else {
                    7.insertWhitespaceIfNeeded(at, context);
                }
            }
            if (template == null && 7.isKeywordWithIdentifierAppended(at, "function")) {
                7.insertWhitespace(context);
            }
            return template;
        }
    };
    private static final InsertHandler<LookupElement> CONST_ARROW_FUNCTION_INSERT_HANDLER = new JSKeywordInsertHandlerBase(){

        @Override
        @NotNull
        protected Template applyAndCreateTemplate(InsertionContext context, PsiFile file2, PsiElement at) {
            Template template = CONST_ARROW_FUNCTION_TEMPLATE;
            if (template == null) {
                8.$$$reportNull$$$0(0);
            }
            return template;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordTemplateInsertHandlers$8", "applyAndCreateTemplate"));
        }
    };
    private static final InsertHandler<LookupElement> CLASS_KEYWORD_INSERT_HANDLER = new JSKeywordInsertHandlerBase(){

        private boolean isLBrace(PsiElement element) {
            if (!(element instanceof LeafPsiElement)) {
                return false;
            }
            return ((LeafPsiElement)element).getElementType() == JSTokenTypes.LBRACE;
        }

        @Override
        @Nullable
        protected Template applyAndCreateTemplate(InsertionContext context, PsiFile file2, PsiElement at) {
            PsiElement parent;
            Template template = null;
            if (at != null && at.getNode().getElementType() == JSTokenTypes.CLASS_KEYWORD && ((parent = at.getParent()) instanceof JSClass || parent instanceof JSFile || parent instanceof TypeScriptModule) && !this.isLBrace(PsiTreeUtil.skipWhitespacesForward((PsiElement)at))) {
                if (parent instanceof JSClassExpression) {
                    template = CLASS_EXPRESSION_TEMPLATE;
                } else if (DialectDetector.isJavaScriptFamily((PsiElement)file2)) {
                    template = NAMED_TYPE_TEMPLATE;
                } else {
                    9.insertWhitespaceIfNeeded(at, context);
                }
            }
            if (template == null && 9.isKeywordWithIdentifierAppended(at, "class")) {
                9.insertWhitespace(context);
            }
            return template;
        }
    };
    private static final Template STATEMENT_WITH_PARENS_AND_BLOCK_TEMPLATE = new TemplateImpl("", " ($END$) {\n  \n}", "");
    private static final Template REQUIRE_ARG_TEMPLATE = new TemplateImpl("", "(\"$ARG$\");\n$END$", "");
    private static final Template ENTITY_WITH_BLOCK_TEMPLATE = new TemplateImpl("", " {\n  $END$\n}", "");
    private static final Template CLASS_EXPRESSION_TEMPLATE = new TemplateImpl("", " $NAME_EXTENDS$ {\n  $END$\n}", "");
    private static final Template CATCH_BLOCK_TEMPLATE = new TemplateImpl("", " $BINDING$ {\n  $END$\n}", "");
    private static final Template FUNCTION_TEMPLATE = new TemplateImpl("", " $NAME$($PARAM$) {\n  $END$\n}", "");
    private static final Template FUNCTION_TEMPLATE_NO_BODY = new TemplateImpl("", " $NAME$($END$);", "");
    private static final Template FUNCTION_EXPRESSION_TEMPLATE = new TemplateImpl("", "($PARAM$) {\n  $END$\n}", "");
    private static final Template CONST_ARROW_FUNCTION_TEMPLATE = new TemplateImpl("", " $NAME$ = ($PARAM$) => {\n  $END$\n}", "");
    private static final Template NAMED_TYPE_TEMPLATE = new TemplateImpl("", " $NAME$ {\n  $END$\n}", "");

    @Nullable
    public static Pair<String, InsertHandler<LookupElement>> getAdditionalKeywordElementData(@NotNull JSCompletionKeyword keyword, @NotNull PsiElement context) {
        if (keyword == null) {
            JSKeywordTemplateInsertHandlers.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSKeywordTemplateInsertHandlers.$$$reportNull$$$0(1);
        }
        switch (keyword) {
            case FUNCTION: {
                JSAttributeListOwner attributeListOwner;
                PsiElement parent = context.getParent();
                String tailText = null;
                if (parent instanceof JSReferenceExpression && !(parent.getParent() instanceof JSExpressionStatement)) {
                    tailText = " (params) {...}";
                } else if (parent != null && DialectDetector.isTypeScript(parent) && (attributeListOwner = (JSAttributeListOwner)PsiTreeUtil.getParentOfType((PsiElement)parent, JSAttributeListOwner.class)) != null && TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)attributeListOwner)) {
                    tailText = " name(params)";
                }
                if (tailText == null) {
                    tailText = " name(params) {...}";
                }
                return Pair.create((Object)tailText, FUNCTION_KEYWORD_INSERT_HANDLER);
            }
            case CONST: {
                DialectOptionHolder holder = DialectDetector.dialectOfElement(context);
                return holder != null && holder.hasFeature(JSLanguageFeature.ARROW_FUNCTIONS) ? Pair.create((Object)" name = (params) => {...}", CONST_ARROW_FUNCTION_INSERT_HANDLER) : null;
            }
            case SWITCH: 
            case WITH: {
                return Pair.create((Object)" (obj) {...}", STATEMENT_WITH_PARENS_AND_BLOCK_INSERT_HANDLER);
            }
            case CATCH: {
                return Pair.create((Object)" (e) {...}", CATCH_BLOCK_INSERT_HANDLER);
            }
            case CLASS: {
                PsiElement parent = context.getParent();
                String tailText = parent instanceof JSReferenceExpression && !(parent.getParent() instanceof JSExpressionStatement) ? " {...}" : " name {...}";
                return Pair.create((Object)tailText, CLASS_KEYWORD_INSERT_HANDLER);
            }
            case REQUIRE: {
                return Pair.create((Object)"('module')", TS_REQUIRE_INSERT_HANDLER);
            }
            case INTERFACE: {
                return Pair.create((Object)" name {}", INTERFACE_KEYWORD_INSERT_HANDLER);
            }
            case ENUM: {
                return Pair.create((Object)" name {}", ENUM_KEYWORD_INSERT_HANDLER);
            }
        }
        return null;
    }

    static {
        FUNCTION_TEMPLATE.addVariable("NAME", (Expression)new MacroCallNode((Macro)new JSSuggestVariableNameMacro()), true);
        FUNCTION_TEMPLATE.addVariable("PARAM", (Expression)new EmptyNode(), true);
        FUNCTION_TEMPLATE.setToReformat(true);
        FUNCTION_TEMPLATE_NO_BODY.addVariable("NAME", (Expression)new MacroCallNode((Macro)new JSSuggestVariableNameMacro()), true);
        FUNCTION_TEMPLATE_NO_BODY.setToReformat(true);
        FUNCTION_EXPRESSION_TEMPLATE.addVariable("PARAM", (Expression)new EmptyNode(), true);
        FUNCTION_EXPRESSION_TEMPLATE.setToReformat(true);
        STATEMENT_WITH_PARENS_AND_BLOCK_TEMPLATE.setToReformat(true);
        REQUIRE_ARG_TEMPLATE.addVariable("ARG", (Expression)new MacroCallNode((Macro)new CompleteMacro()), true);
        REQUIRE_ARG_TEMPLATE.setToReformat(true);
        ENTITY_WITH_BLOCK_TEMPLATE.setToReformat(true);
        CLASS_EXPRESSION_TEMPLATE.setToReformat(true);
        CLASS_EXPRESSION_TEMPLATE.addVariable("NAME_EXTENDS", (Expression)new EmptyNode(), true);
        NAMED_TYPE_TEMPLATE.addVariable("NAME", (Expression)new MacroCallNode((Macro)new JSSuggestVariableNameMacro()), true);
        NAMED_TYPE_TEMPLATE.setToReformat(true);
        CATCH_BLOCK_TEMPLATE.addVariable("BINDING", (Expression)new ConstantNode("(e)"), true);
        CATCH_BLOCK_TEMPLATE.setToReformat(true);
        CONST_ARROW_FUNCTION_TEMPLATE.addVariable("NAME", (Expression)new MacroCallNode((Macro)new JSSuggestVariableNameMacro()), true);
        CONST_ARROW_FUNCTION_TEMPLATE.addVariable("PARAM", (Expression)new EmptyNode(), true);
        CATCH_BLOCK_TEMPLATE.setToReformat(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "keyword";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/completion/JSKeywordTemplateInsertHandlers";
        objectArray[2] = "getAdditionalKeywordElementData";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class NamedTypeInsertHandler
    extends JSWithFollowingElementInsertHandler {
        private NamedTypeInsertHandler() {
        }

        @Override
        @Nullable
        protected Template getTemplate() {
            return NAMED_TYPE_TEMPLATE;
        }

        @Override
        @NotNull
        protected IElementType getElementType() {
            IElementType iElementType = JSTokenTypes.IDENTIFIER;
            if (iElementType == null) {
                NamedTypeInsertHandler.$$$reportNull$$$0(0);
            }
            return iElementType;
        }

        @Override
        protected boolean stopBeforeIdentifier() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordTemplateInsertHandlers$NamedTypeInsertHandler", "getElementType"));
        }
    }

    private static abstract class JSWithFollowingElementInsertHandler
    extends JSKeywordInsertHandlerBase {
        private JSWithFollowingElementInsertHandler() {
        }

        @Override
        @Nullable
        protected Template applyAndCreateTemplate(InsertionContext context, PsiFile file2, PsiElement at) {
            ASTNode node;
            ASTNode aSTNode = node = at == null ? null : at.getNode();
            if (node instanceof LeafPsiElement) {
                String keywordText;
                PsiElement element = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)at);
                if (element instanceof LeafPsiElement && ((LeafPsiElement)element).getElementType() == this.getElementType()) {
                    context.getEditor().getCaretModel().moveToOffset(((LeafPsiElement)element).getStartOffset() + 1);
                    return null;
                }
                if (this.stopBeforeIdentifier() && node.getElementType() == JSTokenTypes.IDENTIFIER && (keywordText = this.getKeywordText()) != null && JSWithFollowingElementInsertHandler.isKeywordWithIdentifierAppended(at, keywordText)) {
                    JSWithFollowingElementInsertHandler.insertWhitespace(context);
                    return null;
                }
            }
            return this.getTemplate();
        }

        @Nullable
        protected abstract Template getTemplate();

        @NotNull
        protected abstract IElementType getElementType();

        protected boolean stopBeforeIdentifier() {
            return false;
        }

        @Nullable
        protected String getKeywordText() {
            return null;
        }
    }
}

