/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorViewStructure;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flow.FlowJSRestartAllServersAction;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.LogicalNavigationLinkHandler;
import com.intellij.lang.javascript.flow.ResendingOSProcessHandler;
import com.intellij.lang.javascript.flow.lsp.FlowJSLanguageServerConnector;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import icons.JavaScriptLanguageIcons;
import java.awt.Font;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSToolWindowProvider
implements Disposable {
    @NotNull
    private final JSLanguageServiceToolWindowManager myToolWindow;

    @Nullable
    public static JSLanguageServiceToolWindowManager getToolWindow(Project project) {
        if (project == null || project.isDefault() || project.isDisposed()) {
            return null;
        }
        FlowJSToolWindowProvider provider = (FlowJSToolWindowProvider)project.getService(FlowJSToolWindowProvider.class);
        return provider == null ? null : provider.getToolWindow();
    }

    public FlowJSToolWindowProvider(final @NotNull Project project) {
        if (project == null) {
            FlowJSToolWindowProvider.$$$reportNull$$$0(0);
        }
        FlowJSRestartAllServersAction restartAllServersAction = new FlowJSRestartAllServersAction(){

            @Override
            protected void setEnabledAndVisible(@NotNull Presentation presentation, boolean hasStarted) {
                if (presentation == null) {
                    1.$$$reportNull$$$0(0);
                }
                presentation.setEnabled(hasStarted);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider$1", "setEnabledAndVisible"));
            }
        };
        AnAction checkAllFiles = new AnAction(JavaScriptBundle.message("javascript.flow.error.panel.all.errors", new Object[0]), JavaScriptBundle.message("javascript.flow.error.panel.all.errors", new Object[0]), AllIcons.Actions.Compile){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    FlowJSServerManager serverManager = FlowJSServerManager.getInstance(project);
                    if (serverManager != null) {
                        SmartList results;
                        List<FlowJSServerService> servers = serverManager.getAllServers();
                        if (servers.size() == 1) {
                            results = ((FlowJSServerService)ContainerUtil.getFirstItem(servers)).getAllErrors();
                        } else {
                            List errorFutures = ContainerUtil.map(servers, server -> ApplicationManager.getApplication().executeOnPooledThread(() -> server.getAllErrors()));
                            results = new SmartList();
                            for (Future errorFuture : errorFutures) {
                                List errorsFromFuture = Collections.emptyList();
                                try {
                                    errorsFromFuture = (List)errorFuture.get();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                results.addAll(errorsFromFuture);
                            }
                        }
                        ApplicationManager.getApplication().invokeLater(() -> this.lambda$actionPerformed$2((List)results));
                    }
                });
            }

            private /* synthetic */ void lambda$actionPerformed$2(List results) {
                FlowJSToolWindowProvider.this.myToolWindow.logProjectErrors((ImmutableList<JSAnnotationError>)ContainerUtil.immutableList((List)results), true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider$2", "actionPerformed"));
            }
        };
        AnAction showErrorDetails = new AnAction(JavaScriptBundle.message("flow.show.error.details", new Object[0]), JavaScriptBundle.message("flow.show.error.details", new Object[0]), AllIcons.Actions.PreviewDetails){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ErrorTreeElement selectedElement;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!((selectedElement = FlowJSToolWindowProvider.this.myToolWindow.getSelectedElement()) instanceof FlowJSNavigatableMessageElement)) {
                    return;
                }
                JSAnnotationError annotationError = ((FlowJSNavigatableMessageElement)selectedElement).getAnnotationError();
                String tooltipText = annotationError.getTooltipText();
                if (tooltipText == null) {
                    return;
                }
                JEditorPane content = this.createContentComponent(tooltipText);
                JBPopup hint = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)content, (JComponent)content).setProject(project).setResizable(true).setMovable(true).setTitle(JavaScriptBundle.message("dialog.title.error.details", new Object[0])).setModalContext(false).createPopup();
                hint.showInBestPositionFor(e.getDataContext());
            }

            @NotNull
            private JEditorPane createContentComponent(@NlsContexts.Tooltip String tooltipText) {
                JEditorPane pane = new SwingHelper.HtmlViewerBuilder().setCarryTextOver(false).create();
                pane.setText(SwingHelper.buildHtml((String)UIUtil.getCssFontDeclaration((Font)StartupUiUtil.getLabelFont(), null, null, null), (String)tooltipText));
                pane.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        String description2;
                        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (description2 = e.getDescription()).startsWith("#navigation_logical/")) {
                            LogicalNavigationLinkHandler.navigate(description2, project);
                        }
                    }
                });
                JEditorPane jEditorPane = pane;
                if (jEditorPane == null) {
                    3.$$$reportNull$$$0(1);
                }
                return jEditorPane;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createContentComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myToolWindow = new JSLanguageServiceToolWindowManager(project, JavaScriptBundle.message("js.flow.tool.window.name", new Object[0]), "reference.tool.windows.flow", JavaScriptLanguageIcons.Flowjs.Flow13, new AnAction[]{checkAllFiles, restartAllServersAction, showErrorDetails}){

            @Override
            public synchronized void connectToProcessHandler(@NotNull String serviceId, @NotNull ProcessHandler handler) {
                if (serviceId == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (handler == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (handler instanceof ResendingOSProcessHandler) {
                    ((ResendingOSProcessHandler)handler).stopAfterNextListenerAdded();
                }
                super.connectToProcessHandler(serviceId, handler);
            }

            @Override
            @NotNull
            protected ConsoleViewImpl createConsole() {
                return new ConsoleViewImpl(this.myProject, GlobalSearchScope.allScope((Project)this.myProject), true, false){
                    private static final String TIMESTAMP_FORMAT_STRING = "HH:mm:ss.SSS";
                    private final SimpleDateFormat TIMESTAMP_FORMAT;
                    {
                        this.TIMESTAMP_FORMAT = new SimpleDateFormat(TIMESTAMP_FORMAT_STRING);
                    }

                    public void print(@NotNull String s, @NotNull ConsoleViewContentType contentType) {
                        if (s == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (contentType == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        StringBuilder builder = new StringBuilder();
                        String[] lines = StringUtil.splitByLines((String)s, (boolean)true);
                        boolean first = true;
                        for (String line : lines) {
                            if (line.startsWith("Content-Length:")) continue;
                            if (first) {
                                builder.append(this.TIMESTAMP_FORMAT.format(new Date())).append(' ');
                                first = false;
                            } else {
                                builder.append(StringUtil.repeat((String)" ", (int)(TIMESTAMP_FORMAT_STRING.length() + 1)));
                            }
                            builder.append(line).append('\n');
                        }
                        super.print(builder.toString(), contentType);
                    }

                    public void attachToProcess(@NotNull ProcessHandler processHandler) {
                        if (processHandler == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (processHandler instanceof FlowJSLanguageServerConnector.FlowJSLspProcessHandler) {
                            ((FlowJSLanguageServerConnector.FlowJSLspProcessHandler)processHandler).subscribeToInputStream(s -> this.print((String)s, ConsoleViewContentType.SYSTEM_OUTPUT));
                        }
                        super.attachToProcess(processHandler);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "s";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "contentType";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "processHandler";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider$4$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "print";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "attachToProcess";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }

            @Override
            protected void doAddMessage(@NotNull NewErrorTreeViewPanel errorTreeViewPanel, @NotNull JSAnnotationError compilerResult, @Nullable VirtualFile file2, int category) {
                if (errorTreeViewPanel == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (compilerResult == null) {
                    4.$$$reportNull$$$0(3);
                }
                ErrorTreeElementKind kind = ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)category);
                String[] message = new String[]{compilerResult.getDescription()};
                ErrorViewStructure viewStructure = errorTreeViewPanel.getErrorViewStructure();
                if (file2 == null) {
                    super.doAddMessage(errorTreeViewPanel, compilerResult, null, category);
                } else {
                    String groupName = file2.getPresentableUrl();
                    FlowJSNavigatableMessageElement element = new FlowJSNavigatableMessageElement(kind, viewStructure.getGroupingElement(groupName, null, file2), message, (Navigatable)new OpenFileDescriptor(this.myProject, file2, compilerResult.getLine(), compilerResult.getColumn()), NewErrorTreeViewPanel.createExportPrefix((int)(compilerResult.getLine() + 1)), NewErrorTreeViewPanel.createRendererPrefix((int)(compilerResult.getLine() + 1), (int)(compilerResult.getColumn() + 1)), compilerResult);
                    viewStructure.addNavigatableMessage(groupName, (NavigatableMessageElement)element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "serviceId";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorTreeViewPanel";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "compilerResult";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "connectToProcessHandler";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doAddMessage";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Disposer.register((Disposable)this, (Disposable)this.myToolWindow);
    }

    public void dispose() {
    }

    @NotNull
    public JSLanguageServiceToolWindowManager getToolWindow() {
        JSLanguageServiceToolWindowManager jSLanguageServiceToolWindowManager = this.myToolWindow;
        if (jSLanguageServiceToolWindowManager == null) {
            FlowJSToolWindowProvider.$$$reportNull$$$0(1);
        }
        return jSLanguageServiceToolWindowManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FlowJSNavigatableMessageElement
    extends NavigatableMessageElement {
        @NotNull
        private final JSAnnotationError myAnnotationError;

        FlowJSNavigatableMessageElement(@NotNull ErrorTreeElementKind kind, @Nullable GroupingElement parent, String[] message, @NotNull Navigatable navigatable, String exportText, String rendererTextPrefix, @NotNull JSAnnotationError annotationError) {
            if (kind == null) {
                FlowJSNavigatableMessageElement.$$$reportNull$$$0(0);
            }
            if (navigatable == null) {
                FlowJSNavigatableMessageElement.$$$reportNull$$$0(1);
            }
            if (annotationError == null) {
                FlowJSNavigatableMessageElement.$$$reportNull$$$0(2);
            }
            super(kind, parent, message, navigatable, exportText, rendererTextPrefix);
            this.myAnnotationError = annotationError;
        }

        @NotNull
        public JSAnnotationError getAnnotationError() {
            JSAnnotationError jSAnnotationError = this.myAnnotationError;
            if (jSAnnotationError == null) {
                FlowJSNavigatableMessageElement.$$$reportNull$$$0(3);
            }
            return jSAnnotationError;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "navigatable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotationError";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider$FlowJSNavigatableMessageElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSToolWindowProvider$FlowJSNavigatableMessageElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotationError";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

