/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.javascript.JSFileReference;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.reference.NodeFileModulePsiReferenceBase;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.frameworks.modules.JSMappingReferenceSet;
import com.intellij.lang.javascript.frameworks.modules.JSReferencePathUpdater;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.SyntheticFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSModuleReferenceBase
extends JSFileReference {
    private static final String DUMMY_PREFIX = "IntellijIdeaRulezzz";

    public JSModuleReferenceBase(String text, int offset, TextRange textRange, @NotNull FileReferenceSet fileReferenceSet) {
        if (fileReferenceSet == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(0);
        }
        super(text, offset, textRange, fileReferenceSet);
    }

    public JSModuleReferenceBase(String text, int offset, TextRange textRange, @NotNull FileReferenceSet fileReferenceSet, String[] implicitExtensions) {
        if (fileReferenceSet == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(1);
        }
        super(text, offset, textRange, fileReferenceSet, implicitExtensions);
    }

    protected ResolveResult @NotNull [] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(2);
        }
        ResolveResult[] results = super.innerResolve(caseSensitive, containingFile);
        for (int i2 = 0; i2 < results.length; ++i2) {
            PsiDirectory result2;
            VirtualFile canonicalFile;
            VirtualFile file2;
            JSFile psiFile = (JSFile)ObjectUtils.tryCast((Object)results[i2].getElement(), JSFile.class);
            VirtualFile virtualFile = file2 = psiFile != null ? psiFile.getVirtualFile() : null;
            if (file2 == null || file2.equals(canonicalFile = JSModuleReferenceBase.getCanonicalPreferredFile(psiFile.getProject(), file2))) continue;
            PsiManager manager2 = psiFile.getManager();
            Object object = result2 = canonicalFile.isDirectory() ? manager2.findDirectory(canonicalFile) : manager2.findFile(canonicalFile);
            if (result2 == null) continue;
            results[i2] = new PsiElementResolveResult((PsiElement)result2);
        }
        if (results == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(3);
        }
        return results;
    }

    protected LookupElement createLookupItem(@NotNull PsiElement candidate) {
        PsiDirectory directory;
        PsiDirectory directParent;
        PsiDirectory nodeModulesCandidate;
        if (candidate == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(4);
        }
        if (candidate instanceof PsiDirectory && (nodeModulesCandidate = (directParent = (directory = (PsiDirectory)candidate).getParent())) != null) {
            if ("@types".equals(directParent.getName())) {
                nodeModulesCandidate = nodeModulesCandidate.getParent();
            }
            if (nodeModulesCandidate != null && "node_modules".equals(nodeModulesCandidate.getName())) {
                VirtualFile context = PsiUtilCore.getVirtualFile((PsiElement)this.getElement());
                CompletionModuleInfo module = this.createCompletionModuleInfo(directory.getName(), directory);
                return NodeFileModulePsiReferenceBase.createLookupElement(context, module, directory.getProject());
            }
        }
        return JSCompletionUtil.createLookupElementForJSModule(candidate, this.fixLookupItemWithRelativePath(candidate));
    }

    @NotNull
    protected CompletionModuleInfo createCompletionModuleInfo(@NotNull String name, @NotNull PsiDirectory directory) {
        if (name == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(5);
        }
        if (directory == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(6);
        }
        return new CompletionModuleInfo(name, directory.getVirtualFile(), ModuleType.NODE_MODULES_DIR);
    }

    private boolean fixLookupItemWithRelativePath(@Nullable PsiElement candidate) {
        Collection<PsiPolyVariantReference> parentReferences;
        if (!(candidate instanceof PsiFileSystemItem)) {
            return false;
        }
        PsiElement element = this.getElement();
        if (!(element instanceof ES6ImportExportDeclaration) && !(element.getParent() instanceof ES6ImportExportDeclaration)) {
            return false;
        }
        String name = ((PsiFileSystemItem)candidate).getName();
        FileReferenceSet set = this.getFileReferenceSet();
        if (set.getAllReferences().length != 1) {
            return false;
        }
        if (set instanceof JSMappingReferenceSet.MappingFileReferenceSet && !(parentReferences = ((JSMappingReferenceSet.MappingFileReferenceSet)set).getParentReferences()).isEmpty()) {
            return false;
        }
        String text = set.getPathString();
        if (text.startsWith(".")) {
            return false;
        }
        int index = text.indexOf(DUMMY_PREFIX);
        String string = text = index > 0 ? text.substring(0, index) : text;
        if (!name.startsWith(text) && !text.equals(DUMMY_PREFIX)) {
            return false;
        }
        PsiElement currentElement = this.getElement();
        PsiDirectory directory = currentElement.getContainingFile().getOriginalFile().getParent();
        return candidate.getParent() == directory && !JSCodeStyleSettings.isUseAbsolutePath(currentElement);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiElement psiElement;
        if (element == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(7);
        }
        if ((psiElement = this.processBindFromExtendedCompletion(element)) != null) {
            return psiElement;
        }
        return super.bindToElement(element);
    }

    protected PsiElement processBindFromExtendedCompletion(@NotNull PsiElement element) {
        PsiFile contextFile;
        String path2;
        if (element == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(8);
        }
        if (!this.isExtendedCompletion(element)) {
            return null;
        }
        PsiElement context = this.getElement();
        if (JSCodeStyleSettings.isUseAbsolutePath(context)) {
            String path3 = JSModuleReferenceBase.getPathFromDefaultContext(this.getFileReferenceSet(), element, false);
            if (path3 != null) {
                return this.trimPathExtension(path3);
            }
        } else if (element instanceof PsiFile && (path2 = PsiFileSystemItemUtil.findRelativePath((PsiFileSystemItem)(contextFile = context.getContainingFile()), (PsiFileSystemItem)((PsiFile)element))) != null) {
            return this.trimPathExtension((String)(path2.startsWith(".") ? path2 : "./" + path2));
        }
        return null;
    }

    private PsiElement trimPathExtension(String path2) {
        String[] extensions = this.getSortedByLengthImplicitExtensions();
        String extension = JSFileReference.findExtension(path2, extensions);
        return this.rename(extension == null ? path2 : path2.substring(0, path2.length() - extension.length()));
    }

    private boolean isExtendedCompletion(@NotNull PsiElement element) {
        if (element == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(9);
        }
        if (!(element instanceof PsiFile)) {
            return false;
        }
        PsiFile psiFile = (PsiFile)element;
        FileReferenceSet referenceSet = this.getFileReferenceSet();
        String pathString = referenceSet.getPathString();
        if (!StringUtil.equals((CharSequence)pathString, (CharSequence)psiFile.getName())) {
            return false;
        }
        Object[] types2 = referenceSet.getSuitableFileTypes();
        return types2 == FileType.EMPTY_ARRAY || ArrayUtil.contains((Object)psiFile.getFileType(), (Object[])types2);
    }

    @Override
    protected void innerResolveInContext(@NotNull String referenceText, @NotNull PsiFileSystemItem context, @NotNull Collection<ResolveResult> results, boolean caseSensitive) {
        if (referenceText == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(10);
        }
        if (context == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(11);
        }
        if (results == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(12);
        }
        super.innerResolveInContext(referenceText, context, results, caseSensitive);
        this.innerResolveScopedPackagesInsideTypesModule(referenceText, context, results);
    }

    private void innerResolveScopedPackagesInsideTypesModule(@NotNull String referenceText, @NotNull PsiFileSystemItem context, @NotNull Collection<? super ResolveResult> results) {
        if (referenceText == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(13);
        }
        if (context == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(14);
        }
        if (results == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(15);
        }
        if (referenceText.startsWith("@") && !this.isLast() && "@types".equals(context.getName())) {
            results.add((ResolveResult)new PsiElementResolveResult((PsiElement)this.createFakeScopeFileElement(referenceText, context)));
        }
    }

    @NotNull
    private SyntheticFileSystemItem createFakeScopeFileElement(@NotNull String referenceText, @NotNull PsiFileSystemItem context) {
        if (referenceText == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(16);
        }
        if (context == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(17);
        }
        String scopePrefix = referenceText.substring(1) + "__";
        return new ModuleSyntheticFileSystemItem(context, referenceText, scopePrefix);
    }

    @NotNull
    protected Collection<ResolveResult> getDirectIndexFiles(@NotNull VirtualFile directoryFile) {
        if (directoryFile == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(18);
        }
        List result2 = null;
        for (String ext : this.getImplicitExtensions()) {
            PsiFile psiFile;
            VirtualFile file2 = directoryFile.findChild("index" + ext);
            if (file2 == null || (psiFile = this.getElement().getManager().findFile(file2)) == null) continue;
            PsiElementResolveResult resultElement = new PsiElementResolveResult((PsiElement)psiFile);
            if (result2 == null) {
                if (this.shouldStopImplicitExtensionProcessing(ext)) {
                    List<PsiElementResolveResult> list2 = Collections.singletonList(resultElement);
                    if (list2 == null) {
                        JSModuleReferenceBase.$$$reportNull$$$0(19);
                    }
                    return list2;
                }
                result2 = new SmartList();
            }
            result2.add(resultElement);
            if (!this.shouldStopImplicitExtensionProcessing(ext)) continue;
            List list3 = result2;
            if (list3 == null) {
                JSModuleReferenceBase.$$$reportNull$$$0(20);
            }
            return list3;
        }
        List list4 = result2 == null ? ContainerUtil.emptyList() : result2;
        if (list4 == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(21);
        }
        return list4;
    }

    @Override
    @NotNull
    protected Collection<ResolveResult> resolveDirectory(@NotNull PsiFileSystemItem directory) {
        VirtualFile directoryFile;
        if (directory == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(22);
        }
        if (PackageJsonUtil.findChildPackageJsonFile(directoryFile = directory.getVirtualFile()) == null) {
            Collection<ResolveResult> collection = this.getDirectIndexFiles(directoryFile);
            if (collection == null) {
                JSModuleReferenceBase.$$$reportNull$$$0(23);
            }
            return collection;
        }
        NodeModuleDirectorySearchProcessor processor = this.getNodeModuleSearchProcessor();
        if (processor == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSModuleReferenceBase.$$$reportNull$$$0(24);
            }
            return list2;
        }
        List list3 = ContainerUtil.createMaybeSingletonList((Object)JSExactFileReference.resolveForNpmPackages((PsiElement)directory, processor));
        if (list3 == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(25);
        }
        return list3;
    }

    @Nullable
    protected NodeModuleDirectorySearchProcessor getNodeModuleSearchProcessor() {
        return null;
    }

    @Override
    @NotNull
    protected String fixLastNameForRename(@NotNull String beforeProcessing) {
        if (beforeProcessing == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(26);
        }
        String newName = super.fixLastNameForRename(beforeProcessing);
        String indexSuffix = "/index";
        if (this.getText().endsWith(indexSuffix) || !newName.endsWith(indexSuffix)) {
            String string = newName;
            if (string == null) {
                JSModuleReferenceBase.$$$reportNull$$$0(27);
            }
            return string;
        }
        PsiElement element = this.getElement();
        if (!element.isValid() || !JSCodeStyleSettings.isUseNodeResolution(element)) {
            String string = newName;
            if (string == null) {
                JSModuleReferenceBase.$$$reportNull$$$0(28);
            }
            return string;
        }
        String withoutIndex = newName.substring(0, newName.length() - indexSuffix.length());
        String string = withoutIndex.isEmpty() ? newName : withoutIndex;
        if (string == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public static VirtualFile getCanonicalPreferredFile(@NotNull Project project, @NotNull VirtualFile file2) {
        VirtualFile canonicalFile;
        if (project == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(30);
        }
        if (file2 == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(31);
        }
        if ((canonicalFile = file2.getCanonicalFile()) == null || canonicalFile.equals(file2)) {
            VirtualFile virtualFile = file2;
            if (virtualFile == null) {
                JSModuleReferenceBase.$$$reportNull$$$0(32);
            }
            return virtualFile;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        if (fileIndex.isInContent(canonicalFile)) {
            VirtualFile virtualFile = canonicalFile;
            if (virtualFile == null) {
                JSModuleReferenceBase.$$$reportNull$$$0(33);
            }
            return virtualFile;
        }
        if (fileIndex.isInContent(file2)) {
            VirtualFile virtualFile = file2;
            if (virtualFile == null) {
                JSModuleReferenceBase.$$$reportNull$$$0(34);
            }
            return virtualFile;
        }
        if (fileIndex.isInLibrary(canonicalFile)) {
            VirtualFile virtualFile = canonicalFile;
            if (virtualFile == null) {
                JSModuleReferenceBase.$$$reportNull$$$0(35);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = fileIndex.isInLibrary(file2) ? file2 : canonicalFile;
        if (virtualFile == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(36);
        }
        return virtualFile;
    }

    protected Collection<PsiFileSystemItem> getContextsForBindToElement(VirtualFile curVFile, Project project, FileReferenceHelper helper) {
        return this.getFileReferenceSet().getDefaultContexts();
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
        JSReferencePathUpdater updater;
        PsiElement result2;
        if (element == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(37);
        }
        return (result2 = (updater = new JSReferencePathUpdater(this, element, absolute)).bind()) != null ? result2 : super.bindToElement(element, absolute);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileReferenceSet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/modules/JSModuleReferenceBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryFile";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeProcessing";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/modules/JSModuleReferenceBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "innerResolve";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectIndexFiles";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDirectory";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "fixLastNameForRename";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalPreferredFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "innerResolve";
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createLookupItem";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCompletionModuleInfo";
                break;
            }
            case 7: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processBindFromExtendedCompletion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isExtendedCompletion";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "innerResolveInContext";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "innerResolveScopedPackagesInsideTypesModule";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createFakeScopeFileElement";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDirectIndexFiles";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolveDirectory";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "fixLastNameForRename";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalPreferredFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class ModuleSyntheticFileSystemItem
    extends SyntheticFileSystemItem {
        @NotNull
        private final PsiFileSystemItem myContext;
        @NotNull
        private final String myReferenceText;
        @NotNull
        private final String myScopePrefix;

        ModuleSyntheticFileSystemItem(@NotNull PsiFileSystemItem context, @NotNull String referenceText, String scopePrefix) {
            if (context == null) {
                ModuleSyntheticFileSystemItem.$$$reportNull$$$0(0);
            }
            if (referenceText == null) {
                ModuleSyntheticFileSystemItem.$$$reportNull$$$0(1);
            }
            if (scopePrefix == null) {
                ModuleSyntheticFileSystemItem.$$$reportNull$$$0(2);
            }
            super(JSModuleReferenceBase.this.getElement().getProject());
            this.myContext = context;
            this.myReferenceText = referenceText;
            this.myScopePrefix = scopePrefix;
        }

        public PsiFileSystemItem getParent() {
            return this.myContext;
        }

        public VirtualFile getVirtualFile() {
            return this.myContext.getVirtualFile();
        }

        @NotNull
        public String getName() {
            String string = this.myReferenceText;
            if (string == null) {
                ModuleSyntheticFileSystemItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean processChildren(@NotNull PsiElementProcessor<? super PsiFileSystemItem> processor) {
            if (processor == null) {
                ModuleSyntheticFileSystemItem.$$$reportNull$$$0(4);
            }
            PsiFileSystemItem parent = this.getParent();
            return parent.processChildren(el -> {
                String elName = el.getName();
                if (elName.startsWith(this.myScopePrefix)) {
                    String subPackageName = elName.substring(this.myScopePrefix.length());
                    if (processor instanceof PsiFileSystemItemProcessor) {
                        if (((PsiFileSystemItemProcessor)processor).acceptItem(subPackageName, el.isDirectory())) {
                            return processor.execute(el);
                        }
                        return true;
                    }
                    return processor.execute(el);
                }
                return true;
            });
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ModuleSyntheticFileSystemItem item = (ModuleSyntheticFileSystemItem)((Object)o);
            return this.myContext.equals(item.myContext) && this.myReferenceText.equals(item.myReferenceText) && Objects.equals(this.myScopePrefix, item.myScopePrefix);
        }

        public boolean isEquivalentTo(PsiElement another) {
            return this.equals(another);
        }

        public int hashCode() {
            return Objects.hash(this.myContext, this.myReferenceText, this.myScopePrefix);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scopePrefix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/frameworks/modules/JSModuleReferenceBase$ModuleSyntheticFileSystemItem";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/frameworks/modules/JSModuleReferenceBase$ModuleSyntheticFileSystemItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processChildren";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

