/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react.references;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.frameworks.react.references.JSXNamespaceReference;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.resolve.JSQualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSXResolveUtil {
    public static final String CHILDREN = "children";
    public static final String JSX_ELEMENT = "JSX.Element";
    public static final String FORWARD_REF = "forwardRef";

    @NotNull
    public static Collection<? extends PsiElement> resolveTopLevelName(@NotNull PsiElement context, @NotNull String name) {
        PsiElement local;
        if (context == null) {
            JSXResolveUtil.$$$reportNull$$$0(0);
        }
        if (name == null) {
            JSXResolveUtil.$$$reportNull$$$0(1);
        }
        if ((local = JSStubBasedPsiTreeUtil.resolveLocally(name, context)) != null || !DialectDetector.isTypeScript(context)) {
            List list2 = ContainerUtil.createMaybeSingletonList((Object)local);
            if (list2 == null) {
                JSXResolveUtil.$$$reportNull$$$0(2);
            }
            return list2;
        }
        JSTypeResolveResult result2 = TypeScriptImportHandler.getInstance().resolveName(name, context);
        Collection<? extends PsiElement> collection = result2.getElements();
        if (collection == null) {
            JSXResolveUtil.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiElement> resolveNestedName(@NotNull PsiElement context, @NotNull String name, @NotNull Collection<? extends PsiElement> scopes, @NotNull JSXNamespaceReference parent) {
        if (context == null) {
            JSXResolveUtil.$$$reportNull$$$0(4);
        }
        if (name == null) {
            JSXResolveUtil.$$$reportNull$$$0(5);
        }
        if (scopes == null) {
            JSXResolveUtil.$$$reportNull$$$0(6);
        }
        if (parent == null) {
            JSXResolveUtil.$$$reportNull$$$0(7);
        }
        if (parent.isThisQualifier()) {
            Collection collection = scopes.stream().flatMap(scope -> Stream.of(JSQualifiedNameResolver.processDeclarationsForScope(name, scope, false))).filter(ResolveResult::isValidResult).map(ResolveResult::getElement).filter(Objects::nonNull).collect(Collectors.toList());
            if (collection == null) {
                JSXResolveUtil.$$$reportNull$$$0(8);
            }
            return collection;
        }
        JSQualifiedNameResolver resolver = ES6PsiUtil.createResolver(context);
        Collection<PsiElement> collection = resolver.getLocalElements(name, scopes);
        if (collection == null) {
            JSXResolveUtil.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiElement> expandReferenceElements(@NotNull PsiElement context, @NotNull JSXNamespaceReference reference) {
        Collection<PsiElement> elements;
        if (context == null) {
            JSXResolveUtil.$$$reportNull$$$0(10);
        }
        if (reference == null) {
            JSXResolveUtil.$$$reportNull$$$0(11);
        }
        if ((elements = JSResolveResult.resolveReference(reference)).isEmpty()) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSXResolveUtil.$$$reportNull$$$0(12);
            }
            return list2;
        }
        Collection<PsiElement> collection = ES6PsiUtil.expandElements(context, elements);
        if (collection == null) {
            JSXResolveUtil.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @Nullable
    public static PsiPolyVariantReference getTopLevelReference(@NotNull JSXmlLiteralExpression xmlLiteral) {
        if (xmlLiteral == null) {
            JSXResolveUtil.$$$reportNull$$$0(14);
        }
        PsiReference tagNameReference = xmlLiteral.getReference();
        return (PsiPolyVariantReference)ObjectUtils.coalesce((Object)JSXResolveUtil.getFirstQualifierReference((XmlTag)xmlLiteral), (Object)((PsiPolyVariantReference)ObjectUtils.tryCast((Object)tagNameReference, PsiPolyVariantReference.class)));
    }

    @Nullable
    public static JSXNamespaceReference getFirstQualifierReference(@NotNull XmlTag tag) {
        PsiReference[] references;
        if (tag == null) {
            JSXResolveUtil.$$$reportNull$$$0(15);
        }
        if ((references = tag.getReferences()).length == 0) {
            return null;
        }
        for (PsiReference reference : references) {
            if (!(reference instanceof JSXNamespaceReference)) continue;
            return (JSXNamespaceReference)reference;
        }
        return null;
    }

    @Contract(value="null -> false")
    public static boolean isComponentName(@Nullable String tagName) {
        if (tagName == null) {
            return false;
        }
        if (tagName.indexOf(".") > 0 && tagName.charAt(0) != '[') {
            return true;
        }
        if (tagName.isEmpty()) {
            return false;
        }
        char firstChar = tagName.charAt(0);
        boolean isLowCaseLatin = firstChar >= 'a' && firstChar <= 'z';
        return !isLowCaseLatin;
    }

    public static boolean areReferencesResolvedOrEmpty(@NotNull JSXmlLiteralExpression expression) {
        PsiReference[] references;
        if (expression == null) {
            JSXResolveUtil.$$$reportNull$$$0(16);
        }
        if ((references = expression.getReferences()).length == 0) {
            return true;
        }
        ArrayList<PsiElement> resolved = new ArrayList<PsiElement>();
        for (PsiReference reference : references) {
            if (reference instanceof PsiPolyVariantReference) {
                ResolveResult[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
                List<PsiElement> elements = JSResolveResult.toElements(results);
                resolved.addAll(ContainerUtil.filter(elements, el -> !el.equals(expression)));
                continue;
            }
            PsiElement resolve = reference.resolve();
            if (resolve == null || resolve.equals(expression)) continue;
            resolved.add(resolve);
        }
        return !resolved.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/references/JSXResolveUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlLiteral";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/references/JSXResolveUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTopLevelName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNestedName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "expandReferenceElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveTopLevelName";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveNestedName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "expandReferenceElements";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelReference";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFirstQualifierReference";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "areReferencesResolvedOrEmpty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

