/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.ide.highlighter.EmbeddedTokenHighlighter;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSDocElementType;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptHighlightingLexer;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JSHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> keys1;
    private static final Map<IElementType, TextAttributesKey> keys2;
    @NotNull
    private final DialectOptionHolder myDialectOptionsHolder;
    protected final boolean mySkipKeywordHighlights;
    public static final TextAttributesKey JS_KEYWORD;
    public static final TextAttributesKey JS_STRING;
    protected static final TextAttributesKey JS_NUMBER;
    protected static final TextAttributesKey JS_REGEXP;
    protected static final TextAttributesKey JS_LINE_COMMENT;
    protected static final TextAttributesKey JS_BLOCK_COMMENT;
    protected static final TextAttributesKey JS_DOC_COMMENT;
    protected static final TextAttributesKey JS_OPERATION_SIGN;
    protected static final TextAttributesKey JS_PARENTHS;
    protected static final TextAttributesKey JS_BRACKETS;
    protected static final TextAttributesKey JS_BRACES;
    protected static final TextAttributesKey JS_COMMA;
    protected static final TextAttributesKey JS_DOT;
    protected static final TextAttributesKey JS_SEMICOLON;
    protected static final TextAttributesKey JS_BAD_CHARACTER;
    protected static final TextAttributesKey JS_DOC_TAG;
    public static final TextAttributesKey JS_DOC_TAG_VALUE;
    public static final TextAttributesKey JS_DOC_TYPE;
    public static final TextAttributesKey JS_VALID_STRING_ESCAPE;
    public static final TextAttributesKey JS_INVALID_STRING_ESCAPE;
    public static final TextAttributesKey JS_LOCAL_VARIABLE;
    protected static final TextAttributesKey JS_PARAMETER;
    public static final TextAttributesKey JS_INSTANCE_MEMBER_VARIABLE;
    protected static final TextAttributesKey JS_STATIC_MEMBER_VARIABLE;
    public static final TextAttributesKey JS_GLOBAL_VARIABLE;
    protected static final TextAttributesKey JS_GLOBAL_FUNCTION;
    static final TextAttributesKey JS_LOCAL_FUNCTION;
    public static final TextAttributesKey ES6_DECORATOR;
    protected static final TextAttributesKey JS_STATIC_MEMBER_FUNCTION;
    protected static final TextAttributesKey JS_INSTANCE_MEMBER_FUNCTION;
    protected static final TextAttributesKey JS_CLASS;
    protected static final TextAttributesKey JS_INTERFACE;
    static final TextAttributesKey JS_TYPE_ALIAS;
    static final TextAttributesKey JS_LABEL;
    static final TextAttributesKey JS_MODULE_NAME;
    public static final TextAttributesKey FUNCTION_ARROW;
    public static final TextAttributesKey JS_PRIMITIVE_TYPE;
    public static final TextAttributesKey JS_EXPORTED_VARIABLE;
    public static final TextAttributesKey JS_EXPORTED_FUNCTION;
    public static final TextAttributesKey JS_EXPORTED_CLASS;
    public static final TextAttributesKey JS_INJECTED_LANGUAGE_FRAGMENT;
    protected static final TokenSet OPERATORS_LIKE;

    public JSHighlighter(@NotNull DialectOptionHolder dialectOptionsHolder) {
        if (dialectOptionsHolder == null) {
            JSHighlighter.$$$reportNull$$$0(0);
        }
        this(dialectOptionsHolder, false);
    }

    public JSHighlighter(@NotNull DialectOptionHolder dialectOptionsHolder, boolean skipKeywordHighlights) {
        if (dialectOptionsHolder == null) {
            JSHighlighter.$$$reportNull$$$0(1);
        }
        this.myDialectOptionsHolder = dialectOptionsHolder;
        this.mySkipKeywordHighlights = skipKeywordHighlights;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new JavaScriptHighlightingLexer(this.myDialectOptionsHolder);
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        if (this.getKeywords().contains(tokenType)) {
            TextAttributesKey[] textAttributesKeyArray = this.mySkipKeywordHighlights ? TextAttributesKey.EMPTY_ARRAY : JSHighlighter.pack((TextAttributesKey)JS_KEYWORD);
            if (textAttributesKeyArray == null) {
                JSHighlighter.$$$reportNull$$$0(2);
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = JSHighlighter.pack((TextAttributesKey)keys1.get(tokenType), (TextAttributesKey)keys2.get(tokenType));
        if (textAttributesKeyArray == null) {
            JSHighlighter.$$$reportNull$$$0(3);
        }
        return textAttributesKeyArray;
    }

    @NotNull
    public TextAttributesKey getMappedKey(@NotNull TextAttributesKey original) {
        if (original == null) {
            JSHighlighter.$$$reportNull$$$0(4);
        }
        TextAttributesKey textAttributesKey = original;
        if (textAttributesKey == null) {
            JSHighlighter.$$$reportNull$$$0(5);
        }
        return textAttributesKey;
    }

    @NotNull
    public DialectOptionHolder getDialectOptionsHolder() {
        DialectOptionHolder dialectOptionHolder = this.myDialectOptionsHolder;
        if (dialectOptionHolder == null) {
            JSHighlighter.$$$reportNull$$$0(6);
        }
        return dialectOptionHolder;
    }

    @NotNull
    public TokenSet getKeywords() {
        TokenSet tokenSet = JSKeywordSets.JS_RESERVED_WORDS;
        if (tokenSet == null) {
            JSHighlighter.$$$reportNull$$$0(7);
        }
        return tokenSet;
    }

    static {
        IElementType[] javadoc;
        JS_KEYWORD = TextAttributesKey.createTextAttributesKey((String)"JS.KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        JS_STRING = TextAttributesKey.createTextAttributesKey((String)"JS.STRING", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        JS_NUMBER = TextAttributesKey.createTextAttributesKey((String)"JS.NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
        JS_REGEXP = TextAttributesKey.createTextAttributesKey((String)"JS.REGEXP", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        JS_LINE_COMMENT = TextAttributesKey.createTextAttributesKey((String)"JS.LINE_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
        JS_BLOCK_COMMENT = TextAttributesKey.createTextAttributesKey((String)"JS.BLOCK_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.BLOCK_COMMENT);
        JS_DOC_COMMENT = TextAttributesKey.createTextAttributesKey((String)"JS.DOC_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.DOC_COMMENT);
        JS_OPERATION_SIGN = TextAttributesKey.createTextAttributesKey((String)"JS.OPERATION_SIGN", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        JS_PARENTHS = TextAttributesKey.createTextAttributesKey((String)"JS.PARENTHS", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
        JS_BRACKETS = TextAttributesKey.createTextAttributesKey((String)"JS.BRACKETS", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
        JS_BRACES = TextAttributesKey.createTextAttributesKey((String)"JS.BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
        JS_COMMA = TextAttributesKey.createTextAttributesKey((String)"JS.COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
        JS_DOT = TextAttributesKey.createTextAttributesKey((String)"JS.DOT", (TextAttributesKey)DefaultLanguageHighlighterColors.DOT);
        JS_SEMICOLON = TextAttributesKey.createTextAttributesKey((String)"JS.SEMICOLON", (TextAttributesKey)DefaultLanguageHighlighterColors.SEMICOLON);
        JS_BAD_CHARACTER = TextAttributesKey.createTextAttributesKey((String)"JS.BADCHARACTER", (TextAttributesKey)HighlighterColors.BAD_CHARACTER);
        JS_DOC_TAG = TextAttributesKey.createTextAttributesKey((String)"JS.DOC_TAG", (TextAttributesKey)DefaultLanguageHighlighterColors.DOC_COMMENT_TAG);
        JS_DOC_TAG_VALUE = TextAttributesKey.createTextAttributesKey((String)"JS.DOC_TAG_VALUE", (TextAttributesKey)DefaultLanguageHighlighterColors.DOC_COMMENT_TAG_VALUE);
        JS_DOC_TYPE = TextAttributesKey.createTextAttributesKey((String)"JS.DOC_TYPE", (TextAttributesKey)JS_DOC_TAG_VALUE);
        JS_VALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"JS.VALID_STRING_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
        JS_INVALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"JS.INVALID_STRING_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE);
        JS_LOCAL_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"JS.LOCAL_VARIABLE", (TextAttributesKey)DefaultLanguageHighlighterColors.LOCAL_VARIABLE);
        JS_PARAMETER = TextAttributesKey.createTextAttributesKey((String)"JS.PARAMETER", (TextAttributesKey)DefaultLanguageHighlighterColors.PARAMETER);
        JS_INSTANCE_MEMBER_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"JS.INSTANCE_MEMBER_VARIABLE", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_FIELD);
        JS_STATIC_MEMBER_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"JS.STATIC_MEMBER_VARIABLE", (TextAttributesKey)DefaultLanguageHighlighterColors.STATIC_FIELD);
        JS_GLOBAL_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"JS.GLOBAL_VARIABLE", (TextAttributesKey)DefaultLanguageHighlighterColors.GLOBAL_VARIABLE);
        JS_GLOBAL_FUNCTION = TextAttributesKey.createTextAttributesKey((String)"JS.GLOBAL_FUNCTION", (TextAttributesKey)DefaultLanguageHighlighterColors.FUNCTION_DECLARATION);
        JS_LOCAL_FUNCTION = TextAttributesKey.createTextAttributesKey((String)"JS.LOCAL_FUNCTION", (TextAttributesKey)DefaultLanguageHighlighterColors.FUNCTION_DECLARATION);
        ES6_DECORATOR = TextAttributesKey.createTextAttributesKey((String)"JS.DECORATOR", (TextAttributesKey)DefaultLanguageHighlighterColors.METADATA);
        JS_STATIC_MEMBER_FUNCTION = TextAttributesKey.createTextAttributesKey((String)"JS.STATIC_MEMBER_FUNCTION", (TextAttributesKey)DefaultLanguageHighlighterColors.STATIC_METHOD);
        JS_INSTANCE_MEMBER_FUNCTION = TextAttributesKey.createTextAttributesKey((String)"JS.INSTANCE_MEMBER_FUNCTION", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_METHOD);
        JS_CLASS = TextAttributesKey.createTextAttributesKey((String)"JS.CLASS", (TextAttributesKey)DefaultLanguageHighlighterColors.CLASS_NAME);
        JS_INTERFACE = TextAttributesKey.createTextAttributesKey((String)"JS.INTERFACE", (TextAttributesKey)DefaultLanguageHighlighterColors.INTERFACE_NAME);
        JS_TYPE_ALIAS = TextAttributesKey.createTextAttributesKey((String)"JS.TYPE_ALIAS", (TextAttributesKey)JS_INTERFACE);
        JS_LABEL = TextAttributesKey.createTextAttributesKey((String)"JS.LABEL", (TextAttributesKey)DefaultLanguageHighlighterColors.LABEL);
        JS_MODULE_NAME = TextAttributesKey.createTextAttributesKey((String)"JS.MODULE_NAME", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
        FUNCTION_ARROW = TextAttributesKey.createTextAttributesKey((String)"JS.FUNCTION_ARROW", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        JS_PRIMITIVE_TYPE = TextAttributesKey.createTextAttributesKey((String)"JS.PRIMITIVE.TYPE", (TextAttributesKey)JS_KEYWORD);
        JS_EXPORTED_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"JS.EXPORTED.VARIABLE", (TextAttributesKey)JS_GLOBAL_VARIABLE);
        JS_EXPORTED_FUNCTION = TextAttributesKey.createTextAttributesKey((String)"JS.EXPORTED.FUNCTION", (TextAttributesKey)JS_GLOBAL_FUNCTION);
        JS_EXPORTED_CLASS = TextAttributesKey.createTextAttributesKey((String)"JS.EXPORTED.CLASS", (TextAttributesKey)JS_CLASS);
        JS_INJECTED_LANGUAGE_FRAGMENT = EditorColors.createInjectedLanguageFragmentKey((Language)JavascriptLanguage.INSTANCE);
        OPERATORS_LIKE = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.OPERATIONS, JSTokenTypes.ARROWS});
        keys1 = new THashMap();
        keys2 = new THashMap();
        JSHighlighter.fillMap(keys1, (TokenSet)OPERATORS_LIKE, (TextAttributesKey)JS_OPERATION_SIGN);
        keys1.put(StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN, JS_VALID_STRING_ESCAPE);
        keys1.put(StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN, JS_INVALID_STRING_ESCAPE);
        keys1.put(StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN, JS_INVALID_STRING_ESCAPE);
        keys1.put(JSTokenTypes.NUMERIC_LITERAL, JS_NUMBER);
        keys1.put(JSTokenTypes.STRING_LITERAL, JS_STRING);
        keys1.put(JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL, JS_STRING);
        keys1.put(JSTokenTypes.STRING_TEMPLATE_PART, JS_STRING);
        keys1.put(JSTokenTypes.BACKQUOTE, JS_STRING);
        keys1.put(JSTokenTypes.REGEXP_LITERAL, JS_REGEXP);
        keys1.put(JSTokenTypes.LPAR, JS_PARENTHS);
        keys1.put(JSTokenTypes.RPAR, JS_PARENTHS);
        keys1.put(JSTokenTypes.LBRACE, JS_BRACES);
        keys1.put(JSTokenTypes.RBRACE, JS_BRACES);
        keys1.put(JSTokenTypes.LBRACKET, JS_BRACKETS);
        keys1.put(JSTokenTypes.RBRACKET, JS_BRACKETS);
        keys1.put(JSTokenTypes.COMMA, JS_COMMA);
        keys1.put(JSTokenTypes.DOT, JS_DOT);
        keys1.put(JSTokenTypes.ELVIS, JS_DOT);
        keys1.put(JSTokenTypes.SHARP, JS_DOT);
        keys1.put(JSTokenTypes.SEMICOLON, JS_SEMICOLON);
        keys1.put(JSTokenTypes.C_STYLE_COMMENT, JS_BLOCK_COMMENT);
        keys1.put(JSTokenTypes.XML_STYLE_COMMENT, JS_BLOCK_COMMENT);
        keys1.put(JSTokenTypes.DOC_COMMENT, JS_DOC_COMMENT);
        keys1.put(JSTokenTypes.END_OF_LINE_COMMENT, JS_LINE_COMMENT);
        keys1.put(JSTokenTypes.BAD_CHARACTER, JS_BAD_CHARACTER);
        keys1.put(JSDocTokenTypes.DOC_TAG_NAME, JS_DOC_COMMENT);
        keys2.put(JSDocTokenTypes.DOC_TAG_NAME, JS_DOC_TAG);
        for (IElementType type2 : javadoc = IElementType.enumerate(type -> type instanceof JSDocElementType)) {
            keys1.put(type2, JS_DOC_COMMENT);
        }
        keys1.put(JSDocTokenTypes.DOC_TAG_VALUE, JS_DOC_COMMENT);
        keys1.put(JSDocTokenTypes.DOC_TAG_NAMEPATH, JS_DOC_COMMENT);
        for (IElementType type2 : JSTokenTypes.XML_TOKENS.getTypes()) {
            keys1.put(type2, XmlHighlighterColors.XML_TAG);
        }
        keys2.put(JSTokenTypes.XML_TAG_NAME, XmlHighlighterColors.XML_TAG_NAME);
        keys2.put(JSTokenTypes.XML_NAME, XmlHighlighterColors.XML_ATTRIBUTE_NAME);
        keys2.put(JSTokenTypes.XML_ATTR_VALUE, XmlHighlighterColors.XML_ATTRIBUTE_VALUE);
        keys2.put(JSTokenTypes.XML_ATTR_VALUE_END, XmlHighlighterColors.XML_ATTRIBUTE_VALUE);
        keys2.put(JSTokenTypes.XML_ATTR_VALUE_START, XmlHighlighterColors.XML_ATTRIBUTE_VALUE);
        keys2.put(JSTokenTypes.XML_ATTR_EQUAL, XmlHighlighterColors.XML_ATTRIBUTE_VALUE);
        keys2.put(JSTokenTypes.XML_ENTITY_REF, XmlHighlighterColors.XML_ENTITY_REFERENCE);
        keys1.put(JSTokenTypes.XML_STYLE_COMMENT, XmlHighlighterColors.XML_COMMENT);
        keys1.put(JSTokenTypes.XML_TAG_CONTENT, XmlHighlighterColors.XML_TAG_DATA);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectOptionsHolder";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/highlighting/JSHighlighter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSHighlighter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappedKey";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectOptionsHolder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMappedKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class JSXmlTokenHighlighter
    implements EmbeddedTokenHighlighter {
        @NotNull
        public MultiMap<IElementType, TextAttributesKey> getEmbeddedTokenAttributes() {
            HashMap keywords = new HashMap();
            SyntaxHighlighterBase.fillMap(keywords, (TokenSet)JSKeywordSets.ES6_RESERVED_WORDS, (TextAttributesKey)JS_KEYWORD);
            SyntaxHighlighterBase.fillMap(keywords, (TokenSet)JSKeywordSets.ES6_SPECIAL_WORDS, (TextAttributesKey)JS_KEYWORD);
            MultiMap map = new MultiMap();
            map.putAllValues(keywords);
            map.putAllValues(keys1);
            map.putAllValues(keys2);
            MultiMap multiMap = map;
            if (multiMap == null) {
                JSXmlTokenHighlighter.$$$reportNull$$$0(0);
            }
            return multiMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSHighlighter$JSXmlTokenHighlighter", "getEmbeddedTokenAttributes"));
        }
    }
}

