/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class JSUndefinedPropertyAssignmentInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSUndefinedPropertyAssignmentInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSUndefinedPropertyAssignmentInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSDefinitionExpression(JSDefinitionExpression node) {
                PsiElement resolvedElement;
                if (!DialectDetector.isJavaScript((PsiElement)node)) {
                    return;
                }
                JSExpression expression = node.getExpression();
                if (!(expression instanceof JSReferenceExpression)) {
                    return;
                }
                JSReferenceExpression refExpr = (JSReferenceExpression)expression;
                JSExpression qualifier = refExpr.getQualifier();
                if (qualifier == null) {
                    return;
                }
                if (qualifier instanceof JSReferenceExpression && (!((resolvedElement = ((JSReferenceExpression)qualifier).resolve()) instanceof JSVariable) || !((JSVariable)resolvedElement).requiresTypeChecking() || resolvedElement instanceof ImplicitJSVariableImpl && "arguments".equals(((ImplicitJSVariableImpl)resolvedElement).getName()) || JSCorePredefinedLibrariesProvider.isLibraryElement(resolvedElement))) {
                    return;
                }
                if (qualifier instanceof JSThisExpression) {
                    return;
                }
                JSType type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(JSResolveUtil.getExpressionJSType(qualifier));
                if (this.isExtensiblePredefinedType(type)) {
                    return;
                }
                PsiElement refExprResolve = refExpr.resolve();
                if (refExprResolve != node) {
                    return;
                }
                String property = refExpr.getReferenceName();
                if (property == null) {
                    return;
                }
                if (!(JSTypeUtils.isNewPropertiesDefinitionAllowed(type, true) || type instanceof JSRecordType && ((JSRecordType)type).hasProperty(property))) {
                    PsiElement refName = refExpr.getReferenceNameElement();
                    String message = JavaScriptBundle.message("js.undefined.property.assignment.inspection.message", property, type.getTypeText(JSType.TypeTextFormat.PRESENTABLE));
                    holder.registerProblem((PsiElement)(refName == null ? node : refName), message, new LocalQuickFix[0]);
                }
            }

            private boolean isExtensiblePredefinedType(JSType type) {
                Ref found = Ref.create((Object)false);
                JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)it -> {
                    if (!(it instanceof JSTypeImpl)) {
                        return true;
                    }
                    String typeText = it.getTypeText(JSType.TypeTextFormat.SIMPLE);
                    if (BaseJSSymbolProcessor.isNamedGlobalType(typeText, ((JSTypeImpl)it).getJSContext()) || "HTMLElement".equals(typeText) || "Element".equals(typeText)) {
                        found.set((Object)true);
                    }
                    return true;
                }), type);
                return (Boolean)found.get();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSUndefinedPropertyAssignmentInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

