/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmptyStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class JSUnnecessarySemicolonInspection
extends JSInspection
implements CleanupLocalInspectionTool {
    private static final String ALLOW_BEFORE_CHAR = "[(+*/-,.";

    @Override
    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        return new JSElementVisitor(){

            @Override
            public void visitJSEmptyStatement(JSEmptyStatement node) {
                ASTNode start;
                PsiElement nextSibling;
                PsiElement prevSibling;
                PsiElement parent = node.getParent();
                if (parent instanceof JSLoopStatement || parent instanceof JSIfStatement) {
                    return;
                }
                if (parent instanceof JSFile && parent.getContext() == null) {
                    JSEmptyStatement elt = node;
                    while ((prevSibling = elt.getPrevSibling()) != null && (prevSibling instanceof PsiWhiteSpace || prevSibling instanceof PsiComment)) {
                        elt = prevSibling;
                    }
                    if (parent.getFirstChild() == elt) {
                        return;
                    }
                }
                boolean hasNewlineBefore = false;
                prevSibling = node.getPrevSibling();
                while (prevSibling instanceof PsiWhiteSpace || prevSibling instanceof PsiComment) {
                    if (prevSibling instanceof PsiWhiteSpace && prevSibling.getText().contains("\n")) {
                        hasNewlineBefore = true;
                        break;
                    }
                    prevSibling = prevSibling.getPrevSibling();
                }
                if (hasNewlineBefore && (nextSibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)node)) != null && nextSibling.getTextLength() > 0 && StringUtil.containsChar((String)JSUnnecessarySemicolonInspection.ALLOW_BEFORE_CHAR, (char)nextSibling.getText().charAt(0))) {
                    return;
                }
                ASTNode astNode = node.getNode();
                ASTNode aSTNode = start = astNode.getFirstChildNode() == astNode.getLastChildNode() && astNode.getFirstChildNode() != null ? astNode : TreeUtil.findChildBackward((ASTNode)astNode, (IElementType)JSTokenTypes.SEMICOLON);
                if (start != null) {
                    LocalQuickFixAndIntentionActionOnPsiElement fix = JSFixFactory.getInstance().removeASTNodeFix("js.unnecessary.semicolon.fix.name", false, start.getPsi(), start.getPsi());
                    holder.registerProblem(start.getPsi(), JavaScriptBundle.message("js.unnecessary.semicolon.problem", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
                }
            }
        };
    }
}

