/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecmal4.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.stubs.JSReferenceListStub;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSElementWithSubstitutor;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.evaluable.JSQualifiedReferenceType;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSReferenceListImpl<T extends JSReferenceListStub<?>>
extends JSStubElementImpl<T>
implements JSReferenceList,
StubBasedPsiElement<T> {
    private static final Function<JSReferenceListMember, String> MEMBER_TO_STRING_REFERENCE = JSReferenceListMember::getReferenceText;
    protected static final Function<JSReferenceListMember, JSExpression> MEMBER_TO_EXPRESSION = JSReferenceListMember::getExpression;

    public JSReferenceListImpl(ASTNode node) {
        super(node);
    }

    public JSReferenceListImpl(T stub) {
        super(stub, stub.getStubType());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSReferenceListImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSReferenceList(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public JSExpression @NotNull [] getExpressions() {
        JSExpression[] jSExpressionArray = (JSExpression[])ContainerUtil.map2Array((Object[])this.getMembers(), JSExpression.class, MEMBER_TO_EXPRESSION);
        if (jSExpressionArray == null) {
            JSReferenceListImpl.$$$reportNull$$$0(1);
        }
        return jSExpressionArray;
    }

    @Override
    public String @NotNull [] getReferenceTexts() {
        Object[] members = this.getMembers();
        if (members.length == 0) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                JSReferenceListImpl.$$$reportNull$$$0(2);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)ContainerUtil.skipNulls((Collection)ContainerUtil.map2List((Object[])members, MEMBER_TO_STRING_REFERENCE)));
        if (stringArray == null) {
            JSReferenceListImpl.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    @Override
    public JSReferenceListMember @NotNull [] getMembers() {
        JSReferenceListMember[] jSReferenceListMemberArray = (JSReferenceListMember[])this.getStubOrPsiChildren(JSStubElementTypes.EXTENDS_LIST_MEMBER, JSReferenceListMember.ARRAY_FACTORY);
        if (jSReferenceListMemberArray == null) {
            JSReferenceListImpl.$$$reportNull$$$0(4);
        }
        return jSReferenceListMemberArray;
    }

    @Override
    public final JSClass @NotNull [] getReferencedClasses() {
        JSClass[] jSClassArray = this.getReferencedClassesImpl();
        if (jSClassArray == null) {
            JSReferenceListImpl.$$$reportNull$$$0(5);
        }
        return jSClassArray;
    }

    protected JSClass @NotNull [] getReferencedClassesImpl() {
        @NonNls String[] texts = this.getReferenceTexts();
        if (texts.length == 0) {
            if (JSClass.EMPTY_ARRAY == null) {
                JSReferenceListImpl.$$$reportNull$$$0(6);
            }
            return JSClass.EMPTY_ARRAY;
        }
        ArrayList<JSClass> supers = new ArrayList<JSClass>(texts.length);
        JSImportHandler importHandler = this.getImportHandler();
        for (String text : texts) {
            supers.addAll(this.resolveTextReferenceClasses(importHandler, text));
        }
        JSClass[] jSClassArray = supers.toArray(JSClass.EMPTY_ARRAY);
        if (jSClassArray == null) {
            JSReferenceListImpl.$$$reportNull$$$0(7);
        }
        return jSClassArray;
    }

    @NotNull
    protected final JSImportHandler getImportHandler() {
        return JSReferenceListImpl.getImportHandler((PsiElement)this);
    }

    @NotNull
    protected static JSImportHandler getImportHandler(@NotNull PsiElement context) {
        if (context == null) {
            JSReferenceListImpl.$$$reportNull$$$0(8);
        }
        JSImportHandler jSImportHandler = JSDialectSpecificHandlersFactory.forElement(context).getImportHandler();
        if (jSImportHandler == null) {
            JSReferenceListImpl.$$$reportNull$$$0(9);
        }
        return jSImportHandler;
    }

    @NotNull
    private Collection<JSClass> resolveTextReferenceClasses(JSImportHandler importHandler, String text) {
        if (StringUtil.isEmpty((String)text)) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSReferenceListImpl.$$$reportNull$$$0(10);
            }
            return list2;
        }
        Collection<JSClass> collection = this.resolveReferenceClasses(importHandler.resolveTypeName(text, (PsiElement)this));
        if (collection == null) {
            JSReferenceListImpl.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @NotNull
    protected Collection<JSClass> resolveReferenceClasses(JSTypeResolveResult resolveResult) {
        String text = resolveResult.getQualifiedName();
        if (DialectDetector.isActionScript((PsiElement)this)) {
            PsiElement clazz = JSClassResolver.findClassFromNamespace(text, (PsiElement)this, JSResolveUtil.getResolveScope((PsiElement)this));
            if (clazz instanceof JSClass) {
                List list2 = ContainerUtil.createMaybeSingletonList((Object)((JSClass)clazz));
                if (list2 == null) {
                    JSReferenceListImpl.$$$reportNull$$$0(12);
                }
                return list2;
            }
        } else {
            if (resolveResult.hasElements()) {
                PsiElement parentClass = this.getParent();
                SmartList result2 = new SmartList();
                for (PsiElement psiElement : resolveResult.getElements()) {
                    if (!(psiElement instanceof JSClass) || parentClass == psiElement) continue;
                    result2.add((JSClass)psiElement);
                }
                SmartList smartList = result2;
                if (smartList == null) {
                    JSReferenceListImpl.$$$reportNull$$$0(13);
                }
                return smartList;
            }
            if (!DialectDetector.isTypeScript((PsiElement)this)) {
                return JSReferenceListImpl.resolveDirectlyToClasses(text, (PsiElement)this);
            }
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            JSReferenceListImpl.$$$reportNull$$$0(14);
        }
        return list3;
    }

    @NotNull
    protected static List<JSElementWithSubstitutor<JSClass>> toListWithSubstitutor(@NotNull Collection<? extends JSClass> classes, @NotNull List<JSType> typeArguments) {
        if (classes == null) {
            JSReferenceListImpl.$$$reportNull$$$0(15);
        }
        if (typeArguments == null) {
            JSReferenceListImpl.$$$reportNull$$$0(16);
        }
        List list2 = ContainerUtil.map(classes, el -> JSReferenceListImpl.buildWith(el, typeArguments));
        if (list2 == null) {
            JSReferenceListImpl.$$$reportNull$$$0(17);
        }
        return list2;
    }

    @NotNull
    protected static JSElementWithSubstitutor<JSClass> buildWith(@NotNull JSClass jsClass, @NotNull List<JSType> types2) {
        if (jsClass == null) {
            JSReferenceListImpl.$$$reportNull$$$0(18);
        }
        if (types2 == null) {
            JSReferenceListImpl.$$$reportNull$$$0(19);
        }
        JSTypeSubstitutor jsTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jsClass instanceof TypeScriptTypeParameterListOwner) {
            TypeScriptTypeParameter[] parameters = ((TypeScriptTypeParameterListOwner)((Object)jsClass)).getTypeParameters();
            jsTypeSubstitutor = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(parameters, types2);
        }
        return new JSElementWithSubstitutor<JSClass>(jsClass, jsTypeSubstitutor);
    }

    @NotNull
    public Collection<JSElementWithSubstitutor<JSClass>> resolveMemberClasses(@NotNull JSReferenceListMember member) {
        if (member == null) {
            JSReferenceListImpl.$$$reportNull$$$0(20);
        }
        JSImportHandler importHandler = this.getImportHandler();
        String text = member.getReferenceText();
        List<JSType> argumentsAsTypes = member.getTypeArgumentsAsTypes();
        return JSReferenceListImpl.toListWithSubstitutor(this.resolveTextReferenceClasses(importHandler, text), argumentsAsTypes);
    }

    @NotNull
    protected static Collection<JSClass> resolveDirectlyToClasses(@NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            JSReferenceListImpl.$$$reportNull$$$0(21);
        }
        if (context == null) {
            JSReferenceListImpl.$$$reportNull$$$0(22);
        }
        JSQualifiedNameImpl ns = JSQualifiedNameImpl.fromQualifiedName(text);
        JSQualifiedName qualifierName = ns.getParent();
        JSNamespace qualifier = JSNamedTypeFactory.createNamespace(qualifierName, JSContext.STATIC, context);
        Collection<PsiElement> classElements = JSQualifiedReferenceType.resolveNamespaceElements(context, ns.getName(), qualifier);
        List list2 = ContainerUtil.mapNotNull(classElements, e -> {
            JSExpression initializer;
            if (e instanceof JSClass) {
                return (JSClass)e;
            }
            if (e instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)e).getInitializerOrStub()) instanceof JSClass) {
                return (JSClass)((Object)initializer);
            }
            return null;
        });
        if (list2 == null) {
            JSReferenceListImpl.$$$reportNull$$$0(23);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecmal4/impl/JSReferenceListImpl";
                break;
            }
            case 8: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecmal4/impl/JSReferenceListImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceTexts";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedClasses";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedClassesImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportHandler";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTextReferenceClasses";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReferenceClasses";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "toListWithSubstitutor";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDirectlyToClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 23: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getImportHandler";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "toListWithSubstitutor";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildWith";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveMemberClasses";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolveDirectlyToClasses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

