/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSLanguageUtil;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElvisOwner;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSEmptyExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptClassImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSElementImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.types.JSClassElementType;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSChangeUtil {
    private static final Logger LOG = Logger.getInstance((String)JSChangeUtil.class.getName());
    @NonNls
    private static final String DUMMY = "dummy.";
    private static final Set<String> WELL_KNOWN = ContainerUtil.set((Object[])ArrayUtil.mergeArrays((String[])JSCommonTypeNames.ALL, (String[])new String[]{"require", "define", "module", "exports", "window", "global", "globalThis", "arguments", "document", "navigator", "screen", "history", "location", "console"}));
    private static final TokenSet CLASS_OR_TYPE_MEMBERS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS, TypeScriptElementTypes.TYPE_MEMBERS});

    private JSChangeUtil() {
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static ASTNode createNameIdentifier(Project project, @NotNull String name, @Nullable IElementType type) {
        if (name == null) {
            JSChangeUtil.$$$reportNull$$$0(0);
        }
        if (JSKeywordSets.IDENTIFIER_NAMES.contains(type)) {
            return JSChangeUtil.createNameIdentifier(project, name, (JSLanguageDialect)null);
        }
        if (type == JSTokenTypes.STRING_LITERAL && !StringUtil.isQuotedString((String)name)) {
            return JSChangeUtil.createExpressionFromText(project, "\"" + name + "\"").getFirstChildNode();
        }
        return JSChangeUtil.createExpressionFromText(project, name).getFirstChildNode();
    }

    @NotNull
    public static JSParameterListElement createParameter(@NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            JSChangeUtil.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(2);
        }
        ASTNode statementNode = JSChangeUtil.createStatementFromTextWithContext("function foo(" + text + ") {}", context);
        assert (statementNode != null);
        PsiElement psi = statementNode.getPsi();
        assert (psi instanceof JSFunction);
        JSFunction function2 = (JSFunction)psi;
        JSParameterListElement jSParameterListElement = function2.getParameters()[0];
        if (jSParameterListElement == null) {
            JSChangeUtil.$$$reportNull$$$0(3);
        }
        return jSParameterListElement;
    }

    public static ASTNode createPropertyNameWithContext(@NotNull String name, @NotNull ASTNode nameNode) {
        if (name == null) {
            JSChangeUtil.$$$reportNull$$$0(4);
        }
        if (nameNode == null) {
            JSChangeUtil.$$$reportNull$$$0(5);
        }
        IElementType type = nameNode.getElementType();
        PsiElement psiElement = nameNode.getPsi();
        if (JSKeywordSets.IDENTIFIER_NAMES.contains(type)) {
            return JSInheritedLanguagesHelper.createNameIdentifierFromText(name, psiElement);
        }
        if (type == JSTokenTypes.STRING_LITERAL && !StringUtil.isQuotedString((String)name)) {
            char quote = nameNode.getText().charAt(0);
            PsiElement newPsiElement = JSInheritedLanguagesHelper.createExpressionFromText(quote + name + quote, psiElement);
            return newPsiElement != null ? newPsiElement.getNode().getFirstChildNode() : null;
        }
        PsiElement expression = JSInheritedLanguagesHelper.createExpressionFromText(name, nameNode.getPsi());
        if (expression == null) {
            return null;
        }
        if (type == JSElementTypes.REFERENCE_EXPRESSION) {
            return expression.getNode();
        }
        return expression.getNode().getFirstChildNode();
    }

    public static ASTNode createNameIdentifier(Project project, String name, @Nullable JSLanguageDialect dialect) {
        JSExpressionStatement expressionStatement = (JSExpressionStatement)JSChangeUtil.createJSTreeFromTextImpl(project, String.format("({%s:1});", name), dialect);
        assert (expressionStatement != null);
        JSParenthesizedExpression parenthesized = (JSParenthesizedExpression)expressionStatement.getExpression();
        assert (parenthesized != null);
        JSObjectLiteralExpression literalExpression = (JSObjectLiteralExpression)parenthesized.getInnerExpression();
        assert (literalExpression != null);
        return literalExpression.getFirstProperty().getNameIdentifier().getNode();
    }

    public static ASTNode createNameIdentifierWithContext(String name, PsiElement context) {
        return JSChangeUtil.createNameIdentifier(context.getProject(), name, DialectDetector.languageDialectOfElement(context));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public static ASTNode createExpressionFromText(Project project, @NonNls String text) {
        return JSChangeUtil.createExpressionFromText(project, text, null);
    }

    @Nullable
    public static <PsiT> PsiT createExpressionPsiWithContext(@NonNls String text, @NotNull PsiElement context, @NotNull Class<PsiT> psiClass) {
        ASTNode node;
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(6);
        }
        if (psiClass == null) {
            JSChangeUtil.$$$reportNull$$$0(7);
        }
        if ((node = JSChangeUtil.createExpressionWithContext(text, context)) == null) {
            return null;
        }
        return (PsiT)ObjectUtils.tryCast((Object)node.getPsi(), psiClass);
    }

    @Nullable
    public static ASTNode createExpressionWithContext(@NonNls String text, @NotNull PsiElement context) {
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(8);
        }
        boolean isAsyncContext = JSChangeUtil.isAsyncContext(context);
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement(context);
        return JSChangeUtil.createExpressionFromText(context.getProject(), text, dialect, isAsyncContext);
    }

    public static JSEmptyExpression createEmptyExpression(@NotNull PsiElement context) {
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(9);
        }
        PsiElement tree = JSChangeUtil.createJSTreeFromText(context.getProject(), "let [,] = 2;", DialectDetector.languageDialectOfElement(context), false);
        return (JSEmptyExpression)SyntaxTraverser.psiTraverser((PsiElement)tree).filter(JSEmptyExpression.class).first();
    }

    private static boolean isAsyncContext(@Nullable PsiElement context) {
        return context != null && ES6PsiUtil.isAsyncFunction((JSFunction)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{JSFunction.class}));
    }

    @Nullable
    public static ASTNode createExpressionFromText(Project project, @NonNls String text, @Nullable JSLanguageDialect dialect, boolean isAsyncContext) {
        ASTNode node = JSChangeUtil.tryCreateExpressionInternal(project, text, dialect, isAsyncContext);
        if (node == null) {
            LOG.error("Wasn't parsed as expression in " + dialect, new Attachment[]{new Attachment("text.txt", text)});
        }
        return node;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public static ASTNode createExpressionFromText(Project project, @NonNls String text, @Nullable JSLanguageDialect dialect) {
        return JSChangeUtil.createExpressionFromText(project, text, dialect, false);
    }

    private static ASTNode tryCreateExpressionInternal(Project project, @NotNull @NonNls String text, @Nullable JSLanguageDialect dialect, boolean isAsyncContext) {
        if (text == null) {
            JSChangeUtil.$$$reportNull$$$0(10);
        }
        text = "{\n(" + (String)text + ")\n}";
        PsiElement element = JSChangeUtil.createJSTreeFromText(project, (String)text, dialect, isAsyncContext);
        assert (element instanceof JSBlockStatement) : "\"" + (String)text + "\" was not parsed as BlockStatement in " + dialect;
        JSSourceElement[] statements = ((JSBlockStatement)element).getStatementListItems();
        JSSourceElement jSSourceElement = element = statements.length > 0 ? statements[0] : null;
        if (!(element instanceof JSExpressionStatement)) {
            LOG.error("Unexpected expression parse in " + dialect, new Attachment[]{new Attachment("text.txt", (String)text)});
            return null;
        }
        JSExpressionStatement expressionStatement = (JSExpressionStatement)element;
        JSExpression expr = (JSExpression)expressionStatement.getFirstChild();
        if (expr instanceof JSParenthesizedExpression) {
            expr = ((JSParenthesizedExpression)expr).getInnerExpression();
        }
        if (expr == null) {
            return null;
        }
        return expr.getNode();
    }

    @Nullable
    public static ASTNode tryCreateExpressionWithContext(@NonNls String text, @NotNull PsiElement context, @Nullable JSLanguageDialect dialect) {
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(11);
        }
        boolean isAsyncContext = JSChangeUtil.isAsyncContext(context);
        JSLanguageDialect languageDialect = dialect != null ? dialect : DialectDetector.languageDialectOfElement(context);
        return JSChangeUtil.tryCreateExpressionInternal(context.getProject(), text, languageDialect, isAsyncContext);
    }

    @Deprecated
    @Nullable
    public static ASTNode createStatementFromText(@NotNull Project project, @NonNls String text) {
        if (project == null) {
            JSChangeUtil.$$$reportNull$$$0(12);
        }
        return JSChangeUtil.createStatementFromText(project, text, null);
    }

    @Nullable
    public static <PsiT> PsiT createStatementPsiFromTextWithContext(@NonNls String text, @NotNull PsiElement context, @NotNull Class<PsiT> clazz) {
        ASTNode node;
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(13);
        }
        if (clazz == null) {
            JSChangeUtil.$$$reportNull$$$0(14);
        }
        if ((node = JSChangeUtil.createStatementFromTextWithContext(text, context)) == null) {
            return null;
        }
        return (PsiT)ObjectUtils.tryCast((Object)node.getPsi(), clazz);
    }

    @Nullable
    public static <PsiT> PsiT createClassMemberPsiFromTextWithContext(@NonNls String text, @NotNull PsiElement context, @NotNull Class<PsiT> clazz) {
        ASTNode node;
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(15);
        }
        if (clazz == null) {
            JSChangeUtil.$$$reportNull$$$0(16);
        }
        if ((node = JSChangeUtil.createClassMemberFromText(context.getProject(), text, DialectDetector.languageDialectOfElement(context))) == null) {
            return null;
        }
        return (PsiT)ObjectUtils.tryCast((Object)node.getPsi(), clazz);
    }

    @Nullable
    public static ASTNode createStatementFromTextWithContext(@NonNls String text, @NotNull PsiElement context) {
        JSLanguageDialect dialect;
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(17);
        }
        if ((dialect = DialectDetector.languageDialectOfElement(context)) != null && dialect.getOptionHolder().isECMA4) {
            PsiElement stmt = JSChangeUtil.createJSTreeForStatementInsideFunction(context.getProject(), "function dummy() {" + text + "\n}", dialect);
            return stmt == null ? null : stmt.getNode();
        }
        boolean isAsyncContext = JSChangeUtil.isAsyncContext(context);
        return JSChangeUtil.createStatementFromText(context.getProject(), text, dialect, isAsyncContext);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public static ASTNode createStatementFromText(@NotNull Project project, @NonNls String text, @Nullable JSLanguageDialect dialect) {
        if (project == null) {
            JSChangeUtil.$$$reportNull$$$0(18);
        }
        return JSChangeUtil.createStatementFromText(project, text, dialect, false);
    }

    @Nullable
    public static ASTNode createStatementFromText(@NotNull Project project, @NonNls String text, @Nullable JSLanguageDialect dialect, boolean isAsync) {
        PsiElement element;
        if (project == null) {
            JSChangeUtil.$$$reportNull$$$0(19);
        }
        JSSourceElement stmt = (element = JSChangeUtil.createJSTreeFromText(project, text, dialect, isAsync)) instanceof JSSourceElement ? (JSSourceElement)element : null;
        return stmt != null ? stmt.getNode() : null;
    }

    private static PsiElement createJSTreeFromText(@NotNull Project project, @NonNls String text, @Nullable JSLanguageDialect dialect, boolean isAsync) {
        if (project == null) {
            JSChangeUtil.$$$reportNull$$$0(20);
        }
        return isAsync ? JSChangeUtil.createJSTreeForStatementInsideFunction(project, "async function dummy() {" + text + "\n}", dialect) : JSChangeUtil.createJSTreeFromTextImpl(project, text, dialect);
    }

    @Nullable
    private static PsiElement createJSTreeFromTextImpl(@NotNull Project project, @NonNls String text, @Nullable JSLanguageDialect dialect) {
        if (project == null) {
            JSChangeUtil.$$$reportNull$$$0(21);
        }
        PsiFile dummyFile = JSChangeUtil.createJSFileFromText(project, text, dialect);
        return dummyFile.getFirstChild();
    }

    @Nullable
    private static PsiElement createJSTreeForStatementInsideFunction(@NotNull Project project, @NonNls String functionText, @Nullable JSLanguageDialect dialect) {
        PsiFile dummyFile;
        PsiElement child;
        if (project == null) {
            JSChangeUtil.$$$reportNull$$$0(22);
        }
        if (!((child = (dummyFile = JSChangeUtil.createJSFileFromText(project, functionText, dialect)).getFirstChild()) instanceof JSFunction)) {
            return null;
        }
        JSFunction function2 = (JSFunction)child;
        JSBlockStatement body = function2.getBlock();
        if (body == null) {
            return null;
        }
        return body.getFirstChild().getNextSibling();
    }

    @NotNull
    public static PsiFile createJSFileFromText(@NotNull Project project, @NonNls String text, @Nullable JSLanguageDialect dialect) {
        if (project == null) {
            JSChangeUtil.$$$reportNull$$$0(23);
        }
        JSLanguageDialect language = dialect != null ? dialect : JavascriptLanguage.INSTANCE;
        String ext = JSLanguageUtil.getDefaultExtension(language);
        PsiFile dummyFile = PsiFileFactory.getInstance((Project)project).createFileFromText(DUMMY + ext, (Language)language, (CharSequence)text, false, true);
        assert (dummyFile instanceof JSFile);
        PsiFile psiFile = dummyFile;
        if (psiFile == null) {
            JSChangeUtil.$$$reportNull$$$0(24);
        }
        return psiFile;
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static PsiElement createCommaPsiElement(@NotNull Project project) {
        if (project == null) {
            JSChangeUtil.$$$reportNull$$$0(25);
        }
        ASTNode text = JSChangeUtil.createJSTreeFromText(project, "dummy,dummy");
        ASTNode node = text.getFirstChildNode();
        ASTNode commaNode = node.findChildByType(JSTokenTypes.COMMA);
        assert (commaNode != null);
        PsiElement psiElement = commaNode.getPsi();
        if (psiElement == null) {
            JSChangeUtil.$$$reportNull$$$0(26);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement createCommaPsiElement(@NotNull PsiElement context) {
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(27);
        }
        return JSChangeUtil.createTokenElement(context, JSTokenTypes.COMMA, ",");
    }

    @NotNull
    public static PsiElement createSemicolonPsiElement(@NotNull PsiElement context, String text) {
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(28);
        }
        return JSChangeUtil.createTokenElement(context, JSTokenTypes.SEMICOLON, text);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static ASTNode createJSTreeFromText(Project project, @NonNls String text) {
        return JSChangeUtil.createJSTreeFromText(project, text, null);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public static ASTNode createJSTreeFromText(Project project, @NonNls String text, @Nullable JSLanguageDialect languageDialect) {
        PsiElement element = JSChangeUtil.createJSTreeFromTextImpl(project, text, languageDialect);
        if (element != null) {
            return element.getNode();
        }
        return null;
    }

    @Nullable
    public static ASTNode createJSTreeFromTextWithContext(String text, @NotNull PsiElement context) {
        PsiElement element;
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(29);
        }
        return (element = JSChangeUtil.createJSTreeFromText(context.getProject(), text, DialectDetector.languageDialectOfElement(context), JSChangeUtil.isAsyncContext(context))) != null ? element.getNode() : null;
    }

    public static JSExpression replaceExpression(@NotNull JSExpression oldExpr, @NotNull JSExpression newExpr) {
        if (oldExpr == null) {
            JSChangeUtil.$$$reportNull$$$0(30);
        }
        if (newExpr == null) {
            JSChangeUtil.$$$reportNull$$$0(31);
        }
        if (JSParenthesesUtils.needsParenthesis(oldExpr, newExpr)) {
            ASTNode parenthesized = JSChangeUtil.createExpressionWithContext("(a)", (PsiElement)oldExpr);
            JSParenthesizedExpression parenthPsi = (JSParenthesizedExpression)parenthesized.getPsi();
            parenthesized.replaceChild(parenthPsi.getInnerExpression().getNode(), newExpr.getNode().copyElement());
            oldExpr.getParent().getNode().replaceChild(oldExpr.getNode(), parenthesized);
            return parenthPsi;
        }
        return (JSExpression)JSElementImpl.replaceInParent((PsiElement)oldExpr, (PsiElement)newExpr);
    }

    public static JSElement replaceElement(@NotNull JSElement oldElement, @NotNull JSElement newElement) {
        if (oldElement == null) {
            JSChangeUtil.$$$reportNull$$$0(32);
        }
        if (newElement == null) {
            JSChangeUtil.$$$reportNull$$$0(33);
        }
        return (JSElement)oldElement.replace((PsiElement)newElement);
    }

    public static JSStatement replaceStatement(@NotNull JSStatement oldElement, @NotNull JSStatement newElement) {
        if (oldElement == null) {
            JSChangeUtil.$$$reportNull$$$0(34);
        }
        if (newElement == null) {
            JSChangeUtil.$$$reportNull$$$0(35);
        }
        return (JSStatement)JSChangeUtil.replaceElement(oldElement, newElement);
    }

    public static void doIdentifierReplacement(PsiElement parent, PsiElement identifier, String name) {
        JSChangeUtil.doIdentifierReplacement(parent.getNode(), identifier.getNode(), name, parent.getProject());
    }

    public static void doIdentifierReplacement(ASTNode parentNode, ASTNode identifierNode, String name, Project project) {
        ASTNode nameElement = JSChangeUtil.createNameIdentifier(project, name, DialectDetector.languageDialectOfElement(identifierNode.getPsi()));
        parentNode.replaceChild(identifierNode, nameElement);
    }

    public static PsiElement doAddBefore(@NotNull PsiElement parentElement, @NotNull PsiElement element, @Nullable PsiElement anchor) throws IncorrectOperationException {
        if (parentElement == null) {
            JSChangeUtil.$$$reportNull$$$0(36);
        }
        if (element == null) {
            JSChangeUtil.$$$reportNull$$$0(37);
        }
        if (!JSChangeUtil.isSourceElementOrComment(element) && !(element instanceof PsiWhiteSpace)) {
            throw new UnsupportedOperationException("js statement or whitespace expected");
        }
        return JSChangeUtil.doDoAddBefore(parentElement, element, anchor);
    }

    public static PsiElement doDoAddBeforePure(PsiElement parentElement, PsiElement elementToInsert, @Nullable PsiElement anchor) throws IncorrectOperationException {
        ASTNode elementNode = elementToInsert.getNode();
        if (elementNode == null) {
            throw new IncorrectOperationException("node should not be null");
        }
        ASTNode copiedElementNode = elementNode.copyElement();
        ASTNode parentNode = parentElement.getNode();
        ASTNode anchorNode = anchor != null ? anchor.getNode() : null;
        parentNode.addChild(copiedElementNode, anchorNode);
        return copiedElementNode.getPsi();
    }

    public static PsiElement doDoAddBefore(@NotNull PsiElement parentElement, @NotNull PsiElement elementToInsert, @Nullable PsiElement anchor) throws IncorrectOperationException {
        ASTNode anchorBefore;
        ASTNode elementNode;
        if (parentElement == null) {
            JSChangeUtil.$$$reportNull$$$0(38);
        }
        if (elementToInsert == null) {
            JSChangeUtil.$$$reportNull$$$0(39);
        }
        if ((elementNode = elementToInsert.getNode()) == null) {
            throw new IncorrectOperationException("node should not be null");
        }
        ASTNode copiedElementNode = elementNode.copyElement();
        ASTNode parentNode = parentElement.getNode();
        ASTNode aSTNode = anchorBefore = anchor != null ? anchor.getNode() : null;
        if (anchorBefore != null) {
            anchorBefore = JSChangeUtil.insertWhitespaceIfNeeded(elementNode, parentNode, null, anchorBefore);
        }
        parentNode.addChild(copiedElementNode, anchorBefore);
        ASTNode anchorAfter = copiedElementNode.getTreePrev();
        if (anchorAfter != null) {
            JSChangeUtil.insertWhitespaceIfNeeded(elementNode, parentNode, anchorAfter, null);
        }
        return copiedElementNode.getPsi();
    }

    @Nullable
    private static ASTNode insertWhitespaceIfNeeded(@NotNull ASTNode elementNode, @NotNull ASTNode parentNode, @Nullable ASTNode anchorAfter, @Nullable ASTNode anchorBefore) throws IncorrectOperationException {
        ASTNode anchor;
        ASTNode beforeWs;
        if (elementNode == null) {
            JSChangeUtil.$$$reportNull$$$0(40);
        }
        if (parentNode == null) {
            JSChangeUtil.$$$reportNull$$$0(41);
        }
        if (anchorAfter == null == (anchorBefore == null)) {
            throw new IllegalArgumentException("Exactly one of anchorAfter and anchorBefore must be null");
        }
        ParserDefinition parserDef = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(parentNode.getPsi().getLanguage());
        TokenSet comments = parserDef.getCommentTokens();
        TokenSet whitespaces = parserDef.getWhitespaceTokens();
        if (whitespaces.contains(elementNode.getElementType())) {
            return anchorBefore;
        }
        if (anchorAfter != null && whitespaces.contains(anchorAfter.getElementType()) && anchorAfter.textContains('\n')) {
            return null;
        }
        if (anchorBefore != null && comments.contains(elementNode.getElementType()) && whitespaces.contains(anchorBefore.getElementType()) && anchorBefore.textContains('\n')) {
            return anchorBefore;
        }
        ASTNode anchorBeforeOrFromAfter = anchorBefore != null ? anchorBefore : anchorAfter.getTreeNext();
        ASTNode aSTNode = beforeWs = anchorAfter != null ? anchorAfter : elementNode;
        if (beforeWs.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT || anchorBefore != null && comments.contains(anchorBefore.getElementType())) {
            return JSChangeUtil.addWs(parentNode, anchorBeforeOrFromAfter, "\n");
        }
        ASTNode aSTNode2 = anchor = anchorBefore != null ? anchorBefore : anchorAfter;
        if (!whitespaces.contains(anchor.getElementType())) {
            return JSChangeUtil.addWs(parentNode, anchorBeforeOrFromAfter, " ");
        }
        return anchorBefore;
    }

    @NotNull
    public static ASTNode addWs(@NotNull ASTNode parentNode, @Nullable ASTNode anchorBefore, @NotNull String commentString) {
        if (parentNode == null) {
            JSChangeUtil.$$$reportNull$$$0(42);
        }
        if (commentString == null) {
            JSChangeUtil.$$$reportNull$$$0(43);
        }
        ASTNode wsNode = PsiParserFacade.SERVICE.getInstance((Project)parentNode.getPsi().getProject()).createWhiteSpaceFromText(commentString).getNode();
        parentNode.addChild(wsNode, anchorBefore);
        ASTNode aSTNode = wsNode;
        if (aSTNode == null) {
            JSChangeUtil.$$$reportNull$$$0(44);
        }
        return aSTNode;
    }

    @NotNull
    public static PsiElement addWsAfter(@NotNull PsiElement parent, @Nullable PsiElement anchorAfter, @NotNull String commentString) {
        if (parent == null) {
            JSChangeUtil.$$$reportNull$$$0(45);
        }
        if (commentString == null) {
            JSChangeUtil.$$$reportNull$$$0(46);
        }
        PsiElement ws = PsiParserFacade.SERVICE.getInstance((Project)parent.getProject()).createWhiteSpaceFromText(commentString);
        PsiElement psiElement = parent.addAfter(ws, anchorAfter);
        if (psiElement == null) {
            JSChangeUtil.$$$reportNull$$$0(47);
        }
        return psiElement;
    }

    public static boolean isStatementContainer(PsiElement jsElement) {
        return jsElement instanceof JSBlockStatement || jsElement instanceof JSEmbeddedContent || jsElement instanceof JSClass || jsElement instanceof JSPackageStatement || jsElement instanceof TypeScriptModule;
    }

    public static boolean isSourceElementOrComment(PsiElement jsElement) {
        return jsElement instanceof JSSourceElement || jsElement instanceof PsiComment;
    }

    public static PsiElement doAddAfter(@NotNull PsiElement parent, @NotNull PsiElement toAdd, @Nullable PsiElement anchor) throws IncorrectOperationException {
        if (parent == null) {
            JSChangeUtil.$$$reportNull$$$0(48);
        }
        if (toAdd == null) {
            JSChangeUtil.$$$reportNull$$$0(49);
        }
        if (!JSChangeUtil.isSourceElementOrComment(toAdd) && !(toAdd instanceof PsiWhiteSpace)) {
            throw new UnsupportedOperationException("js statement or whitespace expected");
        }
        return JSChangeUtil.doDoAddAfter(parent, toAdd, anchor);
    }

    public static PsiElement doDoAddAfter(@NotNull PsiElement parent, @NotNull PsiElement toAdd, @Nullable PsiElement anchor) throws IncorrectOperationException {
        if (parent == null) {
            JSChangeUtil.$$$reportNull$$$0(50);
        }
        if (toAdd == null) {
            JSChangeUtil.$$$reportNull$$$0(51);
        }
        PsiElement anchorBefore = anchor != null ? anchor.getNextSibling() : parent.getFirstChild();
        return JSChangeUtil.doDoAddBefore(parent, toAdd, anchorBefore);
    }

    @NotNull
    public static Pair<PsiElement, PsiElement> doAddRangeBefore(@NotNull PsiElement parent, @NotNull PsiElement first, @NotNull PsiElement last, @Nullable PsiElement anchor) throws IncorrectOperationException {
        PsiElement firstAdded;
        if (parent == null) {
            JSChangeUtil.$$$reportNull$$$0(52);
        }
        if (first == null) {
            JSChangeUtil.$$$reportNull$$$0(53);
        }
        if (last == null) {
            JSChangeUtil.$$$reportNull$$$0(54);
        }
        PsiElement psiElement = firstAdded = JSChangeUtil.doAddBefore(parent, first, anchor);
        while (first != last && (first = first.getNextSibling()) != null) {
            psiElement = JSChangeUtil.doAddAfter(parent, first, psiElement);
        }
        Pair pair = Pair.create((Object)firstAdded, (Object)psiElement);
        if (pair == null) {
            JSChangeUtil.$$$reportNull$$$0(55);
        }
        return pair;
    }

    @NotNull
    public static Pair<PsiElement, PsiElement> doAddRangeAfter(@NotNull PsiElement jsElement, @NotNull PsiElement first, @NotNull PsiElement last, @Nullable PsiElement anchor) throws IncorrectOperationException {
        PsiElement firstAdded;
        if (jsElement == null) {
            JSChangeUtil.$$$reportNull$$$0(56);
        }
        if (first == null) {
            JSChangeUtil.$$$reportNull$$$0(57);
        }
        if (last == null) {
            JSChangeUtil.$$$reportNull$$$0(58);
        }
        PsiElement psiElement = firstAdded = JSChangeUtil.doAddAfter(jsElement, first, anchor);
        while (first != last && (first = first.getNextSibling()) != null) {
            psiElement = JSChangeUtil.doAddAfter(jsElement, first, psiElement);
        }
        Pair pair = Pair.create((Object)firstAdded, (Object)psiElement);
        if (pair == null) {
            JSChangeUtil.$$$reportNull$$$0(59);
        }
        return pair;
    }

    public static boolean isBlockStatementContainer(JSElement jsElement) {
        return jsElement instanceof JSIfStatement || jsElement instanceof JSLoopStatement;
    }

    public static PsiElement blockDoAddRangeBefore(PsiElement first, PsiElement last, @NotNull PsiElement anchor) throws IncorrectOperationException {
        if (anchor == null) {
            JSChangeUtil.$$$reportNull$$$0(60);
        }
        BlockAddContext addContext = new BlockAddContext(anchor){

            @Override
            PsiElement doAddElement(PsiElement ... element) throws IncorrectOperationException {
                return this.newlyAddedBlock.addRangeBefore(element[0], element[1], this.codeBlockAnchor);
            }
        };
        return addContext.doAddElement(first, last);
    }

    public static PsiElement blockDoAddRangeAfter(PsiElement first, PsiElement last, @NotNull PsiElement anchor) throws IncorrectOperationException {
        if (anchor == null) {
            JSChangeUtil.$$$reportNull$$$0(61);
        }
        BlockAddContext addContext = new BlockAddContext(anchor){

            @Override
            PsiElement doAddElement(PsiElement ... element) throws IncorrectOperationException {
                return this.newlyAddedBlock.addRangeAfter(element[0], element[1], this.codeBlockAnchor);
            }
        };
        return addContext.doAddElement(first, last);
    }

    public static PsiElement blockDoAddAfter(PsiElement element, @NotNull PsiElement anchor) throws IncorrectOperationException {
        if (anchor == null) {
            JSChangeUtil.$$$reportNull$$$0(62);
        }
        BlockAddContext addContext = new BlockAddContext(anchor){

            @Override
            PsiElement doAddElement(PsiElement ... element) throws IncorrectOperationException {
                return this.newlyAddedBlock.addAfter(element[0], this.codeBlockAnchor);
            }
        };
        return addContext.doAddElement(element);
    }

    public static PsiElement blockDoAddBefore(PsiElement element, @NotNull PsiElement anchor) throws IncorrectOperationException {
        if (anchor == null) {
            JSChangeUtil.$$$reportNull$$$0(63);
        }
        BlockAddContext addContext = new BlockAddContext(anchor){

            @Override
            PsiElement doAddElement(PsiElement ... element) throws IncorrectOperationException {
                return this.newlyAddedBlock.addBefore(element[0], this.codeBlockAnchor);
            }
        };
        return addContext.doAddElement(element);
    }

    public static <T extends JSSourceElement> T addSourceElement(@NotNull JSSourceElement statement, T toAdd, boolean before) throws IncorrectOperationException {
        ASTNode treeParent;
        if (statement == null) {
            JSChangeUtil.$$$reportNull$$$0(64);
        }
        if (!((treeParent = statement.getNode().getTreeParent()).getElementType() == JSElementTypes.BLOCK_STATEMENT || treeParent.getElementType() instanceof JSFileElementType || treeParent.getElementType() instanceof JSClassElementType || JSExtendedLanguagesTokenSetProvider.EMBEDDED_CONTENTS.contains(treeParent.getElementType()))) {
            if (before) {
                return (T)((JSSourceElement)treeParent.getPsi().addBefore(toAdd, (PsiElement)statement));
            }
            return (T)((JSSourceElement)treeParent.getPsi().addAfter(toAdd, (PsiElement)statement));
        }
        ASTNode copy = toAdd.getNode().copyElement();
        ASTNode anchorBefore = before ? statement.getNode() : statement.getNode().getTreeNext();
        treeParent.addChild(copy, anchorBefore);
        return (T)((JSSourceElement)copy.getPsi());
    }

    public static void addComments(@NotNull List<? extends PsiElement> commentsAndWs, @NotNull PsiElement newElement) {
        if (commentsAndWs == null) {
            JSChangeUtil.$$$reportNull$$$0(65);
        }
        if (newElement == null) {
            JSChangeUtil.$$$reportNull$$$0(66);
        }
        for (PsiElement psiElement : commentsAndWs) {
            if (psiElement instanceof PsiWhiteSpace) {
                JSChangeUtil.addWs(newElement.getParent().getNode(), newElement.getNode(), JSChangeUtil.zipNewLines(psiElement.getText()));
                continue;
            }
            JSChangeUtil.doDoAddBeforePure(newElement.getParent(), psiElement, newElement);
        }
    }

    private static String zipNewLines(String text) {
        boolean inNewLine = false;
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char ch = text.charAt(i2);
            if (ch == '\n') {
                if (inNewLine) continue;
                sb.append(ch);
                inNewLine = true;
                continue;
            }
            sb.append(ch);
            inNewLine = false;
        }
        return sb.toString();
    }

    @NotNull
    public static String generateNewVarName(@NotNull String varNameCandidate, @NotNull PsiElement scopeElement) {
        if (varNameCandidate == null) {
            JSChangeUtil.$$$reportNull$$$0(67);
        }
        if (scopeElement == null) {
            JSChangeUtil.$$$reportNull$$$0(68);
        }
        Set<String> existingNames = JSChangeUtil.collectExistingNames(scopeElement);
        varNameCandidate = StringUtil.isEmptyOrSpaces((String)(varNameCandidate = ((String)varNameCandidate).replace('-', '_'))) || !Character.isLetter(((String)varNameCandidate).charAt(0)) && '_' != ((String)varNameCandidate).charAt(0) ? "generated" : varNameCandidate;
        for (int i2 = 0; i2 < 1000 && existingNames.contains(varNameCandidate); ++i2) {
            varNameCandidate = (String)varNameCandidate + i2;
        }
        String string = varNameCandidate;
        if (string == null) {
            JSChangeUtil.$$$reportNull$$$0(69);
        }
        return string;
    }

    private static Set<String> collectExistingNames(PsiElement topElement) {
        HashSet<String> names = new HashSet<String>();
        Collection elements = PsiTreeUtil.findChildrenOfType((PsiElement)topElement, JSNamedElement.class);
        for (JSNamedElement element : elements) {
            String name = element.getName();
            if (StringUtil.isEmptyOrSpaces((String)name)) continue;
            names.add(name);
        }
        return names;
    }

    public static PsiElement getScopeElementInFile(@NotNull PsiElement element) {
        PsiFile topElement;
        if (element == null) {
            JSChangeUtil.$$$reportNull$$$0(70);
        }
        if (!((topElement = element.getContainingFile()) instanceof JSFile)) {
            JSEmbeddedContent embeddedContent = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)element, JSEmbeddedContent.class);
            return embeddedContent != null ? embeddedContent : topElement;
        }
        return topElement;
    }

    @NotNull
    public static String getVariablePrefix(@Nullable PsiElement context) {
        String string = JSChangeUtil.getVariableKeyword(context).getText();
        if (string == null) {
            JSChangeUtil.$$$reportNull$$$0(71);
        }
        return string;
    }

    @NotNull
    public static JSVarStatement.VarKeyword getVariableKeyword(@Nullable PsiElement context) {
        return JSChangeUtil.getVariableKeyword(context, false);
    }

    @NotNull
    public static JSVarStatement.VarKeyword getVariableKeyword(@Nullable PsiElement context, boolean preferConst) {
        if (context == null) {
            JSVarStatement.VarKeyword varKeyword = JSVarStatement.VarKeyword.VAR;
            if (varKeyword == null) {
                JSChangeUtil.$$$reportNull$$$0(72);
            }
            return varKeyword;
        }
        JSVarStatement.VarKeyword varKeyword = JSChangeUtil.getVariableKeyword(DialectDetector.dialectOfElement(context), preferConst);
        if (varKeyword == null) {
            JSChangeUtil.$$$reportNull$$$0(73);
        }
        return varKeyword;
    }

    private static JSVarStatement.VarKeyword getVariableKeyword(@Nullable DialectOptionHolder holder, boolean preferConst) {
        if (holder != null && holder.hasFeature(JSLanguageFeature.LET_DEFINITIONS)) {
            return preferConst ? JSVarStatement.VarKeyword.CONST : JSVarStatement.VarKeyword.LET;
        }
        return JSVarStatement.VarKeyword.VAR;
    }

    public static boolean isWellKnownPredefined(@NonNls @NotNull String text) {
        if (text == null) {
            JSChangeUtil.$$$reportNull$$$0(74);
        }
        return WELL_KNOWN.contains(StringUtil.toLowerCase((String)text));
    }

    @NotNull
    public static JSParenthesizedExpression wrapInParentheses(@NotNull JSExpression expression) {
        if (expression == null) {
            JSChangeUtil.$$$reportNull$$$0(75);
        }
        ASTNode text = JSChangeUtil.createExpressionWithContext("(1)", (PsiElement)expression);
        assert (text != null);
        JSParenthesizedExpression brackets = (JSParenthesizedExpression)text.getPsi(JSParenthesizedExpression.class);
        JSChangeUtil.replaceExpression(brackets.getInnerExpression(), expression);
        JSParenthesizedExpression jSParenthesizedExpression = brackets;
        if (jSParenthesizedExpression == null) {
            JSChangeUtil.$$$reportNull$$$0(76);
        }
        return jSParenthesizedExpression;
    }

    @NotNull
    public static List<PsiComment> getCommentsInBetween(@NotNull PsiElement left, @NotNull PsiElement right) {
        if (left == null) {
            JSChangeUtil.$$$reportNull$$$0(77);
        }
        if (right == null) {
            JSChangeUtil.$$$reportNull$$$0(78);
        }
        SmartList comments = new SmartList();
        for (PsiElement current = left.getNextSibling(); current != null && !right.equals(current); current = current.getNextSibling()) {
            if (current instanceof PsiComment) {
                comments.add((PsiComment)current.copy());
                continue;
            }
            if (PsiTreeUtil.processElements((PsiElement)current, arg_0 -> JSChangeUtil.lambda$getCommentsInBetween$0(right, (List)comments, arg_0))) continue;
            SmartList smartList = comments;
            if (smartList == null) {
                JSChangeUtil.$$$reportNull$$$0(79);
            }
            return smartList;
        }
        SmartList smartList = comments;
        if (smartList == null) {
            JSChangeUtil.$$$reportNull$$$0(80);
        }
        return smartList;
    }

    public static void deletePartOfCommaExpression(@NotNull JSAssignmentExpression element, @NotNull Consumer<? super PsiComment> commentConsumer) {
        if (element == null) {
            JSChangeUtil.$$$reportNull$$$0(81);
        }
        if (commentConsumer == null) {
            JSChangeUtil.$$$reportNull$$$0(82);
        }
        assert (element.getParent() instanceof JSCommaExpression);
        Consumer adapter = e -> {
            if (e instanceof PsiComment) {
                commentConsumer.consume((Object)((PsiComment)e));
            }
        };
        PsiElement forwardComma = PsiTreeUtil.findSiblingForward((PsiElement)element, (IElementType)JSTokenTypes.COMMA, (Consumer)adapter);
        PsiElement backwardComma = PsiTreeUtil.findSiblingBackward((PsiElement)element, (IElementType)JSTokenTypes.COMMA, (Consumer)adapter);
        if (forwardComma != null) {
            PsiElement nextNonSpace = PsiTreeUtil.skipWhitespacesForward((PsiElement)forwardComma);
            PsiElement rightBound = nextNonSpace == null ? forwardComma : nextNonSpace.getPrevSibling();
            element.getParent().deleteChildRange((PsiElement)(backwardComma != null ? backwardComma.getNextSibling() : element), rightBound);
        } else if (backwardComma != null) {
            element.getParent().deleteChildRange(backwardComma, (PsiElement)element);
        }
    }

    public static PsiElement findInsertionPlaceStartingFrom(PsiElement anchor, boolean skipFirstWs, Function<? super PsiElement, Boolean> skipFilter) {
        block3: {
            PsiElement anchorNextSibling;
            if (skipFirstWs && anchor instanceof PsiWhiteSpace && (anchorNextSibling = anchor.getNextSibling()) != null && ((Boolean)skipFilter.fun((Object)anchorNextSibling)).booleanValue()) {
                anchor = anchorNextSibling;
            }
            while (true) {
                PsiElement nextSibling;
                if ((nextSibling = (anchorNextSibling = anchor.getNextSibling())) instanceof PsiWhiteSpace) {
                    nextSibling = nextSibling.getNextSibling();
                }
                if (nextSibling == null || !((Boolean)skipFilter.fun((Object)nextSibling)).booleanValue()) break;
                anchor = nextSibling;
            }
            if (anchorNextSibling == null) break block3;
            anchor = anchorNextSibling;
        }
        return anchor;
    }

    public static void setElvisAfter(@NotNull PsiElement startElement) {
        if (startElement == null) {
            JSChangeUtil.$$$reportNull$$$0(83);
        }
        PsiElement grandParent = startElement.getParent();
        PsiElement elvis = JSChangeUtil.createTokenElement(grandParent, JSTokenTypes.ELVIS, "?.");
        if (grandParent instanceof JSReferenceExpression) {
            ASTNode node = grandParent.getNode().findChildByType(JSTokenTypes.DOT);
            if (node != null) {
                node.getPsi().replace(elvis);
            }
        } else if (grandParent instanceof JSCallExpression || grandParent instanceof JSIndexedPropertyAccessExpression) {
            grandParent.addAfter(elvis, startElement);
        }
    }

    public static void removeElvis(@NotNull JSElvisOwner elvisOwner) {
        ASTNode elvisToken;
        if (elvisOwner == null) {
            JSChangeUtil.$$$reportNull$$$0(84);
        }
        if ((elvisToken = elvisOwner.getNode().findChildByType(JSTokenTypes.ELVIS)) == null) {
            return;
        }
        if (elvisOwner instanceof JSIndexedPropertyAccessExpression || elvisOwner instanceof JSCallExpression) {
            elvisToken.getPsi().delete();
        } else {
            elvisToken.getPsi().replace(JSChangeUtil.createTokenElement((PsiElement)elvisOwner, JSTokenTypes.DOT, "."));
        }
    }

    public static <TElement extends PsiElement> void removeRangeWithRemovalOfCommas(@NotNull TElement element, TElement @NotNull [] listElements) {
        if (element == null) {
            JSChangeUtil.$$$reportNull$$$0(85);
        }
        if (listElements == null) {
            JSChangeUtil.$$$reportNull$$$0(86);
        }
        boolean isLast = ArrayUtil.indexOf((Object[])listElements, element) == listElements.length - 1;
        ASTNode myNode = element.getNode();
        ASTNode parent = myNode.getTreeParent();
        ASTNode nextComma = JSChangeUtil.findComma(myNode, true);
        if (nextComma != null) {
            ASTNode to = nextComma.getTreeNext();
            if (JSChangeUtil.isWhitespaceToDelete(to, isLast)) {
                to = to.getTreeNext();
            }
            parent.removeRange(myNode, to);
            return;
        }
        ASTNode to = myNode.getTreeNext();
        ASTNode prevComma = JSChangeUtil.findComma(myNode, false);
        ASTNode from = (ASTNode)ObjectUtils.coalesce((Object)prevComma, (Object)myNode);
        if (JSChangeUtil.isWhitespaceToDelete(to, isLast)) {
            to = to.getTreeNext();
        }
        parent.removeRange(from, to);
    }

    private static boolean isWhitespaceToDelete(@Nullable ASTNode to, boolean isLast) {
        return to != null && to.getElementType() == JSTokenTypes.WHITE_SPACE && (!isLast || !to.textContains('\n'));
    }

    @Nullable
    private static ASTNode findComma(@NotNull ASTNode node, boolean forward) {
        if (node == null) {
            JSChangeUtil.$$$reportNull$$$0(87);
        }
        ASTNode result2 = TreeUtil.skipWhitespaceAndComments((ASTNode)(forward ? node.getTreeNext() : node.getTreePrev()), (boolean)forward);
        return result2 != null && result2.getElementType() == JSTokenTypes.COMMA ? result2 : null;
    }

    public static PsiElement createObjectLiteralPropertyFromText(@NotNull String text, @NotNull PsiElement context) {
        PsiElement objectLiteralPsi;
        if (text == null) {
            JSChangeUtil.$$$reportNull$$$0(88);
        }
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(89);
        }
        text = "z = { " + (String)text + " }";
        ASTNode node = JSChangeUtil.createJSTreeFromTextWithContext((String)text, context);
        assert (node != null && node.getPsi() instanceof JSExpressionStatement) : "\"" + (String)text + "\" was not parsed as JSExpressionStatement";
        ASTNode assignment = node.findChildByType(JSStubElementTypes.ASSIGNMENT_EXPRESSION);
        assert (assignment != null && assignment.getPsi() instanceof JSAssignmentExpression) : "\"" + (String)text + "\" was not parsed as JSAssignmentExpression";
        ASTNode objectLiteral = assignment.findChildByType(JSStubElementTypes.OBJECT_LITERAL_EXPRESSION);
        PsiElement psiElement = objectLiteralPsi = objectLiteral == null ? null : objectLiteral.getPsi();
        assert (objectLiteralPsi instanceof JSObjectLiteralExpression);
        return ((JSObjectLiteralExpression)objectLiteralPsi).getProperties()[0];
    }

    public static ASTNode createClassMemberFromText(Project project, String text, @Nullable JSLanguageDialect dialect) {
        text = "class Foo {" + (String)text + "}";
        ASTNode node = JSChangeUtil.createJSTreeFromText(project, (String)text, dialect);
        assert (node.getPsi() instanceof JSClass) : "\"" + (String)text + "\" was not parsed as JSClass";
        return node.findChildByType(dialect != null && dialect.getOptionHolder().isTypeScript ? TypeScriptClassImpl.MEMBERS : CLASS_OR_TYPE_MEMBERS);
    }

    @Deprecated
    public static void rebindIfThereAreUsages(@NotNull PsiElement variable, @NotNull PsiElement topElement, @NotNull Convertor<? super Collection<PsiReference>, ? extends PsiElement> replaceCreator, @NotNull Processor<? super PsiReference> conversionFilter) {
        SearchScope limitedScope;
        Collection references;
        if (variable == null) {
            JSChangeUtil.$$$reportNull$$$0(90);
        }
        if (topElement == null) {
            JSChangeUtil.$$$reportNull$$$0(91);
        }
        if (replaceCreator == null) {
            JSChangeUtil.$$$reportNull$$$0(92);
        }
        if (conversionFilter == null) {
            JSChangeUtil.$$$reportNull$$$0(93);
        }
        if ((references = ReferencesSearch.search((PsiElement)variable, (SearchScope)(limitedScope = GlobalSearchScope.fileScope((PsiFile)variable.getContainingFile()).intersectWith(new LocalSearchScope(topElement)))).findAll()).isEmpty()) {
            return;
        }
        PsiElement target = (PsiElement)replaceCreator.convert((Object)references);
        if (target == null) {
            return;
        }
        JSNamedElement replaceTarget = JSChangeUtil.correctRebindTarget(target);
        for (PsiReference ref : references) {
            PsiElement refElement;
            if (!(ref instanceof PsiElement) || JSResolveUtil.isSelfReference(refElement = ref.getElement()) || !conversionFilter.process((Object)ref)) continue;
            if (replaceTarget instanceof JSQualifiedNamedElement && ((JSQualifiedNamedElement)replaceTarget).getNamespace() != null) {
                JSExpressionStatement expressionStatement = JSPsiElementFactory.createJSStatement(replaceTarget.getText() + ";", (PsiElement)replaceTarget, JSExpressionStatement.class);
                refElement.replace((PsiElement)expressionStatement.getExpression());
                continue;
            }
            ref.bindToElement((PsiElement)replaceTarget);
        }
    }

    @Deprecated
    public static void rebindVariableUsages(@NotNull PsiElement variable, @NotNull PsiElement createdReferenceTarget, @NotNull PsiElement topElement) {
        if (variable == null) {
            JSChangeUtil.$$$reportNull$$$0(94);
        }
        if (createdReferenceTarget == null) {
            JSChangeUtil.$$$reportNull$$$0(95);
        }
        if (topElement == null) {
            JSChangeUtil.$$$reportNull$$$0(96);
        }
        JSNamedElement element = JSChangeUtil.correctRebindTarget(createdReferenceTarget);
        SearchScope scope = GlobalSearchScope.fileScope((PsiFile)variable.getContainingFile()).intersectWith(new LocalSearchScope(topElement));
        for (PsiReference ref : ReferencesSearch.search((PsiElement)variable, (SearchScope)scope).findAll()) {
            if (!(ref instanceof PsiElement) || JSResolveUtil.isSelfReference(ref.getElement())) continue;
            ref.bindToElement((PsiElement)element);
        }
    }

    private static JSNamedElement correctRebindTarget(@NotNull PsiElement createdReferenceTarget) {
        JSNamedElement element;
        if (createdReferenceTarget == null) {
            JSChangeUtil.$$$reportNull$$$0(97);
        }
        if (!(createdReferenceTarget instanceof JSNamedElement)) {
            JSVarStatement varStatement = JSPsiElementFactory.createJSStatement("var " + createdReferenceTarget.getText() + ";", createdReferenceTarget, JSVarStatement.class);
            element = varStatement.getVariables()[0];
        } else {
            element = (JSNamedElement)createdReferenceTarget;
        }
        return element;
    }

    public static PsiElement deepResolve(@NotNull JSReferenceExpression expression) {
        if (expression == null) {
            JSChangeUtil.$$$reportNull$$$0(98);
        }
        JSReferenceExpression reference = expression;
        block0: for (int i2 = 0; i2 < 10; ++i2) {
            PsiElement resolved = JSChangeUtil.insistinglyResolve(reference);
            while (resolved != null) {
                if (!((resolved = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolved)) instanceof JSInitializerOwner)) {
                    List<? extends PsiElement> exportedFromFile;
                    if (resolved instanceof JSFile && !(exportedFromFile = JSResolveUtil.getExportedElements((JSFile)resolved)).isEmpty()) {
                        resolved = (PsiElement)exportedFromFile.iterator().next();
                        continue;
                    }
                    return resolved;
                }
                JSExpression initializer = ((JSInitializerOwner)resolved).getInitializer();
                if (initializer instanceof JSReferenceExpression) {
                    reference = (JSReferenceExpression)initializer;
                    continue block0;
                }
                return initializer;
            }
        }
        return null;
    }

    public static CompositeElement createCompositeElementWithDummyHolder(@NotNull PsiElement context, @NotNull IElementType compositeType) {
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(99);
        }
        if (compositeType == null) {
            JSChangeUtil.$$$reportNull$$$0(100);
        }
        CompositeElement composite = ASTFactory.composite((IElementType)compositeType);
        FileElement holder = DummyHolderFactory.createHolder((PsiManager)context.getManager(), (PsiElement)context).getTreeElement();
        holder.rawAddChildren((TreeElement)composite);
        return composite;
    }

    public static PsiElement createTwoTokenComposite(@NotNull PsiElement context, @NotNull IElementType compositeType, @NotNull IElementType tokenType1, @NotNull IElementType tokenType2, @NotNull CharSequence token1Text, @NotNull CharSequence token2Text) {
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(101);
        }
        if (compositeType == null) {
            JSChangeUtil.$$$reportNull$$$0(102);
        }
        if (tokenType1 == null) {
            JSChangeUtil.$$$reportNull$$$0(103);
        }
        if (tokenType2 == null) {
            JSChangeUtil.$$$reportNull$$$0(104);
        }
        if (token1Text == null) {
            JSChangeUtil.$$$reportNull$$$0(105);
        }
        if (token2Text == null) {
            JSChangeUtil.$$$reportNull$$$0(106);
        }
        CompositeElement composite = JSChangeUtil.createCompositeElementWithDummyHolder(context, compositeType);
        LeafElement leaf1 = ASTFactory.leaf((IElementType)tokenType1, (CharSequence)token1Text);
        composite.addChild((ASTNode)leaf1);
        LeafElement leaf2 = ASTFactory.leaf((IElementType)tokenType2, (CharSequence)token2Text);
        composite.addChild((ASTNode)leaf2);
        PsiElement psi = composite.getPsi();
        assert (psi != null);
        return psi;
    }

    @NotNull
    public static PsiElement createTokenElement(@NotNull PsiElement context, @NotNull IElementType tokenType, @NotNull CharSequence text) {
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(107);
        }
        if (tokenType == null) {
            JSChangeUtil.$$$reportNull$$$0(108);
        }
        if (text == null) {
            JSChangeUtil.$$$reportNull$$$0(109);
        }
        LeafElement leaf = ASTFactory.leaf((IElementType)tokenType, (CharSequence)text);
        FileElement holder = DummyHolderFactory.createHolder((PsiManager)context.getManager(), (PsiElement)context).getTreeElement();
        holder.rawAddChildren((TreeElement)leaf);
        PsiElement psi = leaf.getPsi();
        assert (psi != null);
        PsiElement psiElement = psi;
        if (psiElement == null) {
            JSChangeUtil.$$$reportNull$$$0(110);
        }
        return psiElement;
    }

    public static PsiElement createNewLine(@NotNull PsiElement context) {
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(111);
        }
        return JSChangeUtil.createNewLine(context, "\n");
    }

    public static PsiElement createNewLine(@NotNull PsiElement context, @NotNull CharSequence text) {
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(112);
        }
        if (text == null) {
            JSChangeUtil.$$$reportNull$$$0(113);
        }
        return JSChangeUtil.createTokenElement(context, TokenType.WHITE_SPACE, text);
    }

    @Nullable
    private static PsiElement insistinglyResolve(JSReferenceExpression expression) {
        ResolveResult[] results;
        PsiElement resolved = expression.resolve();
        if (resolved == null && (results = expression.multiResolve(false)).length == 1) {
            String problemKey;
            ResolveResult result2 = results[0];
            if (result2.getElement() == null) {
                return null;
            }
            if (result2 instanceof JSResolveResult && ("javascript.element.need.to.be.imported".equals(problemKey = ((JSResolveResult)result2).getResolveProblemKey()) || "javascript.element.need.to.be.exported".equals(problemKey))) {
                return result2.getElement();
            }
            if (result2.isValidResult()) {
                return result2.getElement();
            }
        }
        return resolved;
    }

    @NotNull
    public static TypeScriptType createTypeScriptType(@NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            JSChangeUtil.$$$reportNull$$$0(114);
        }
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(115);
        }
        PsiElement typeElement = JSChangeUtil.tryCreateTypeElement(text, context);
        assert (typeElement instanceof TypeScriptType) : String.format("Could not parse TS type from '%s'", text);
        TypeScriptType typeScriptType = (TypeScriptType)typeElement;
        if (typeScriptType == null) {
            JSChangeUtil.$$$reportNull$$$0(116);
        }
        return typeScriptType;
    }

    @Nullable
    public static PsiElement tryCreateTypeElement(@NotNull String text, @NotNull PsiElement context) {
        JSVarStatement statement;
        JSVariable[] variables;
        if (text == null) {
            JSChangeUtil.$$$reportNull$$$0(117);
        }
        if (context == null) {
            JSChangeUtil.$$$reportNull$$$0(118);
        }
        return (variables = (statement = JSPsiElementFactory.createJSStatement("var x: " + text + ";", context, JSVarStatement.class)).getVariables()).length == 1 ? variables[0].getTypeElement() : null;
    }

    public static void addCommaIfNeeded(@NotNull PsiElement elt, @NotNull IElementType leftBracket, @NotNull IElementType rightBracket, @NotNull BiConsumer<? super PsiElement, ? super PsiElement> addBefore, @NotNull BiConsumer<? super PsiElement, ? super PsiElement> addAfter) {
        PsiElement prevSibling;
        PsiElement nextSibling;
        if (elt == null) {
            JSChangeUtil.$$$reportNull$$$0(119);
        }
        if (leftBracket == null) {
            JSChangeUtil.$$$reportNull$$$0(120);
        }
        if (rightBracket == null) {
            JSChangeUtil.$$$reportNull$$$0(121);
        }
        if (addBefore == null) {
            JSChangeUtil.$$$reportNull$$$0(122);
        }
        if (addAfter == null) {
            JSChangeUtil.$$$reportNull$$$0(123);
        }
        if ((nextSibling = PsiTreeUtil.skipWhitespacesForward((PsiElement)elt)) instanceof JSEmptyExpression) {
            nextSibling = PsiTreeUtil.skipWhitespacesForward((PsiElement)nextSibling);
        }
        if (!JSChangeUtil.isCommaOrBrace(nextSibling, rightBracket)) {
            addAfter.accept((PsiElement)JSChangeUtil.createTokenElement(elt.getParent(), JSTokenTypes.COMMA, ","), (PsiElement)elt);
        }
        if ((prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)elt)) instanceof JSEmptyExpression) {
            prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)prevSibling);
        }
        if (!JSChangeUtil.isCommaOrBrace(prevSibling, leftBracket)) {
            addBefore.accept((PsiElement)JSChangeUtil.createTokenElement(elt.getParent(), JSTokenTypes.COMMA, ","), (PsiElement)elt);
        }
    }

    private static boolean isCommaOrBrace(@Nullable PsiElement nextSibling, @NotNull IElementType bracket) {
        if (bracket == null) {
            JSChangeUtil.$$$reportNull$$$0(124);
        }
        if (!(nextSibling instanceof LeafPsiElement)) {
            return false;
        }
        IElementType type = ((LeafPsiElement)nextSibling).getElementType();
        return type == JSTokenTypes.COMMA || type == bracket;
    }

    private static /* synthetic */ boolean lambda$getCommentsInBetween$0(PsiElement right, List comments, PsiElement element) {
        if (element.equals(right)) {
            return false;
        }
        if (element instanceof PsiComment) {
            comments.add((PsiComment)element);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 24: 
            case 26: 
            case 44: 
            case 47: 
            case 55: 
            case 59: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 79: 
            case 80: 
            case 110: 
            case 116: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 24: 
            case 26: 
            case 44: 
            case 47: 
            case 55: 
            case 59: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 79: 
            case 80: 
            case 110: 
            case 116: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 10: 
            case 74: 
            case 88: 
            case 109: 
            case 113: 
            case 114: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 27: 
            case 28: 
            case 29: 
            case 89: 
            case 99: 
            case 101: 
            case 107: 
            case 111: 
            case 112: 
            case 115: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 24: 
            case 26: 
            case 44: 
            case 47: 
            case 55: 
            case 59: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 79: 
            case 80: 
            case 110: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSChangeUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldExpr";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpr";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 33: 
            case 35: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 37: 
            case 70: 
            case 81: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToInsert";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementNode";
                break;
            }
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentString";
                break;
            }
            case 45: 
            case 48: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdd";
                break;
            }
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 54: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsElement";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentsAndWs";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varNameCandidate";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 75: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentConsumer";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elvisOwner";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listElements";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 90: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 91: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topElement";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceCreator";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conversionFilter";
                break;
            }
            case 95: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdReferenceTarget";
                break;
            }
            case 100: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compositeType";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType1";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType2";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token1Text";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token2Text";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftBracket";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightBracket";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addBefore";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addAfter";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bracket";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSChangeUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameter";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createJSFileFromText";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommaPsiElement";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "addWs";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "addWsAfter";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "doAddRangeBefore";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "doAddRangeAfter";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNewVarName";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariablePrefix";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableKeyword";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInParentheses";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentsInBetween";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokenElement";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeScriptType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createNameIdentifier";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createParameter";
                break;
            }
            case 3: 
            case 24: 
            case 26: 
            case 44: 
            case 47: 
            case 55: 
            case 59: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 79: 
            case 80: 
            case 110: 
            case 116: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPropertyNameWithContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionPsiWithContext";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionWithContext";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyExpression";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryCreateExpressionInternal";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryCreateExpressionWithContext";
                break;
            }
            case 12: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createStatementFromText";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createStatementPsiFromTextWithContext";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createClassMemberPsiFromTextWithContext";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createStatementFromTextWithContext";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createJSTreeFromText";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createJSTreeFromTextImpl";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createJSTreeForStatementInsideFunction";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createJSFileFromText";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createCommaPsiElement";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createSemicolonPsiElement";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createJSTreeFromTextWithContext";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpression";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "replaceElement";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "replaceStatement";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "doAddBefore";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "doDoAddBefore";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "insertWhitespaceIfNeeded";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addWs";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addWsAfter";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "doAddAfter";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "doDoAddAfter";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "doAddRangeBefore";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "doAddRangeAfter";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "blockDoAddRangeBefore";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "blockDoAddRangeAfter";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "blockDoAddAfter";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "blockDoAddBefore";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "addSourceElement";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "addComments";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "generateNewVarName";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getScopeElementInFile";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "isWellKnownPredefined";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "wrapInParentheses";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getCommentsInBetween";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "deletePartOfCommaExpression";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "setElvisAfter";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "removeElvis";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "removeRangeWithRemovalOfCommas";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "findComma";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "createObjectLiteralPropertyFromText";
                break;
            }
            case 90: 
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "rebindIfThereAreUsages";
                break;
            }
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "rebindVariableUsages";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "correctRebindTarget";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "deepResolve";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "createCompositeElementWithDummyHolder";
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "createTwoTokenComposite";
                break;
            }
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "createTokenElement";
                break;
            }
            case 111: 
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "createNewLine";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "createTypeScriptType";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "tryCreateTypeElement";
                break;
            }
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "addCommaIfNeeded";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "isCommaOrBrace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 24: 
            case 26: 
            case 44: 
            case 47: 
            case 55: 
            case 59: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 79: 
            case 80: 
            case 110: 
            case 116: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static abstract class BlockAddContext {
        final JSBlockStatement newlyAddedBlock;
        final PsiElement codeBlockAnchor;

        BlockAddContext(@NotNull PsiElement _anchor) throws IncorrectOperationException {
            if (_anchor == null) {
                BlockAddContext.$$$reportNull$$$0(0);
            }
            JSBlockStatement codeBlockNode = JSPsiElementFactory.createJSStatement("{ a }", _anchor, JSBlockStatement.class);
            this.newlyAddedBlock = (JSBlockStatement)_anchor.replace((PsiElement)codeBlockNode);
            JSStatement artificiallyAddedBlockAnchor = (JSStatement)this.newlyAddedBlock.getStatementListItems()[0];
            CodeEditUtil.replaceChild((ASTNode)this.newlyAddedBlock.getNode(), (ASTNode)artificiallyAddedBlockAnchor.getNode(), (ASTNode)_anchor.getNode());
            this.codeBlockAnchor = _anchor;
        }

        abstract PsiElement doAddElement(PsiElement ... var1) throws IncorrectOperationException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_anchor", "com/intellij/lang/javascript/psi/impl/JSChangeUtil$BlockAddContext", "<init>"));
        }
    }
}

