/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSElementImpl;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReferenceSet;
import com.intellij.lang.javascript.psi.types.JSImportType;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class JSDocTagReferencesHolderImpl
extends JSElementImpl {
    private static final Pattern REPLACE_ASTERISKS_PATTERN = Pattern.compile("\\n\\s*\\*?");
    private static final Key<ParameterizedCachedValue<PsiReference[], JSDocTagReferencesHolderImpl>> REFERENCES_KEY = new Key("js.doc.tag.references");
    private static final ParameterizedCachedValueProvider<PsiReference[], JSDocTagReferencesHolderImpl> REFERENCES_PROVIDER = param -> CachedValueProvider.Result.create((Object)param.createRefs(), (Object[])new Object[]{param});

    JSDocTagReferencesHolderImpl(IElementType elementType) {
        super(elementType);
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, REFERENCES_KEY, REFERENCES_PROVIDER, false, (Object)this);
        if (psiReferenceArray == null) {
            JSDocTagReferencesHolderImpl.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    public PsiReference getReference() {
        return (PsiReference)ArrayUtil.getLastElement((Object[])this.getReferences());
    }

    protected abstract PsiReference[] createRefs();

    protected PsiReference @NotNull [] createReferencesFromText(@NotNull String text, boolean soft, boolean event, boolean module, boolean isNamepath) {
        boolean parsedSuccessfully;
        if (text == null) {
            JSDocTagReferencesHolderImpl.$$$reportNull$$$0(1);
        }
        int offset = 0;
        if (text.startsWith("{")) {
            text = text.substring(1);
            ++offset;
            soft = false;
        }
        text = StringUtil.trimEnd((String)text, (String)"}");
        ArrayList<PsiReference> result2 = new ArrayList<PsiReference>();
        Matcher matcher = REPLACE_ASTERISKS_PATTERN.matcher(text);
        StringBuilder builder = new StringBuilder(text);
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            builder.replace(start, end, StringUtil.repeatSymbol((char)' ', (int)(end - start)));
        }
        text = builder.toString();
        text = StringUtil.trimEnd((String)text, (String)"()");
        SmartList myReferences = new SmartList();
        SmartList myImportTypes = new SmartList();
        JSTypeParser typeParser = new JSTypeParser(this.getProject(), text, new JSTypeVisitor((List)myImportTypes, (List)myReferences){
            final /* synthetic */ List val$myImportTypes;
            final /* synthetic */ List val$myReferences;
            {
                this.val$myImportTypes = list2;
                this.val$myReferences = list3;
            }

            @Override
            public void visitSingleType(int startOffset, @Nullable JSType type, @NotNull String name) {
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!JSCommonTypeNames.NON_REFERENCE_TYPES.contains(name)) {
                    Pair pair = Pair.create((Object)startOffset, (Object)name);
                    if (type instanceof JSImportType) {
                        this.val$myImportTypes.add(pair);
                    } else {
                        this.val$myReferences.add(pair);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocTagReferencesHolderImpl$1", "visitSingleType"));
            }
        });
        boolean bl = parsedSuccessfully = (isNamepath ? typeParser.parseNamepath() : typeParser.parseParameterType()) != null;
        if (parsedSuccessfully) {
            this.fillNamepathReferences(soft, event, module, offset, result2, (List<Pair<Integer, String>>)myReferences);
            this.fillImportTypeReferences(soft, offset, result2, (List<Pair<Integer, String>>)myImportTypes);
        } else if (JSDocumentationUtils.isExtendedTypeName(text) || DialectDetector.isActionScript((PsiElement)this)) {
            JSDocReferenceSet set = new JSDocReferenceSet((PsiElement)this, text, offset, soft);
            Collections.addAll(result2, set.getReferences());
        }
        PsiReference[] psiReferenceArray = result2.isEmpty() ? PsiReference.EMPTY_ARRAY : result2.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            JSDocTagReferencesHolderImpl.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    private void fillNamepathReferences(boolean soft, boolean event, boolean module, int offset, @NotNull List<PsiReference> result2, @NotNull List<Pair<Integer, String>> myReferences) {
        if (result2 == null) {
            JSDocTagReferencesHolderImpl.$$$reportNull$$$0(3);
        }
        if (myReferences == null) {
            JSDocTagReferencesHolderImpl.$$$reportNull$$$0(4);
        }
        for (Pair<Integer, String> reference : myReferences) {
            String qName = (String)reference.second;
            JSDocReferenceSet set = new JSDocReferenceSet((PsiElement)this, qName, offset + (Integer)reference.first, soft, event, module);
            Collections.addAll(result2, set.getReferences());
        }
    }

    private void fillImportTypeReferences(boolean soft, int offset, List<PsiReference> result2, List<Pair<Integer, String>> myImportTypes) {
        for (Pair<Integer, String> reference : myImportTypes) {
            int separator;
            int last;
            int first;
            String importStart = (String)reference.second;
            int start = importStart.indexOf("import");
            if (start < 0 || (first = StringUtil.findFirst((CharSequence)importStart, ch -> ch == '\'' || ch == '\"')) <= 0 || (last = importStart.lastIndexOf(separator = importStart.charAt(first) == '\'' ? 39 : 34)) <= 0 || last <= first || last + 1 >= importStart.length()) continue;
            int fileReferenceOffset = offset + (Integer)reference.first + first + 1;
            String fileReferenceText = importStart.substring(first, last + 1);
            PsiReference[] references = JSFileReferencesUtil.createImportExportFromClauseReferences((PsiElement)this, fileReferenceOffset, fileReferenceText, null);
            Collections.addAll(result2, references);
            int docOffset = start + offset + (Integer)reference.first;
            JSDocReferenceSet docSet = new JSDocReferenceSet((PsiElement)this, importStart.substring(start), docOffset, soft, false, false);
            Collections.addAll(result2, docSet.getReferences());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocTagReferencesHolderImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocTagReferencesHolderImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferencesFromText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createReferencesFromText";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fillNamepathReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

