/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceField;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.introduce.BaseIntroduceSettings;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduce.JSIntroducedExpressionUtil;
import com.intellij.lang.javascript.refactoring.introduceField.JSFieldInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduceField.JSIntroduceFieldDialog;
import com.intellij.lang.javascript.refactoring.introduceField.JSIntroduceFieldSettings;
import com.intellij.lang.javascript.refactoring.introduceVariable.InplaceSettings;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntroduceFieldHandler
extends JSBaseIntroduceHandler<JSElement, BaseIntroduceSettings, JSIntroduceFieldDialog> {
    private static final String LAST_IS_READONLY = "js.last.introduce.field.readonly";
    private static final String LAST_INIT_PLACE = "js.last.introduce.field.init";
    private static final String LAST_MODIFIER = "js.last.introduce.field.modifier";
    private boolean myForceReadonly;
    private final Ref<SmartPsiElementPointer<JSAssignmentExpression>> myInsertedExtra = Ref.create();

    public JSIntroduceFieldHandler() {
    }

    public JSIntroduceFieldHandler(boolean forceReadonly) {
        this();
        this.myForceReadonly = forceReadonly;
    }

    @Override
    @Nullable
    @NonNls
    public String getRefactoringId() {
        return "refactoring.javascript.introduceField";
    }

    @Override
    protected String getRefactoringName() {
        return JavaScriptBundle.message("javascript.introduce.field.title", new Object[0]);
    }

    @Override
    protected String getCannotIntroduceMessagePropertyKey() {
        return "javascript.introduce.field.error.no.expression.selected";
    }

    @Override
    protected String getCannotIntroduceVoidExpressionTypeMessagePropertyKey() {
        return "javascript.introduce.field.error.expression.has.void.type";
    }

    @Override
    protected JSExecutionScope getScopeWhenHavingParameterReferences(JSExecutionScope scope) {
        return null;
    }

    public static void setLastIsReadonly(@NotNull Project project, boolean isReadonly) {
        if (project == null) {
            JSIntroduceFieldHandler.$$$reportNull$$$0(0);
        }
        PropertiesComponent.getInstance((Project)project).setValue(LAST_IS_READONLY, isReadonly);
    }

    public static boolean getLastIsReadonly(@NotNull Project project) {
        String value;
        if (project == null) {
            JSIntroduceFieldHandler.$$$reportNull$$$0(1);
        }
        return (value = PropertiesComponent.getInstance((Project)project).getValue(LAST_IS_READONLY)) != null && Boolean.parseBoolean(value);
    }

    public static void setLastInitPlace(@NotNull Project project, @NotNull JSIntroduceFieldSettings.InitializationPlace place) {
        if (project == null) {
            JSIntroduceFieldHandler.$$$reportNull$$$0(2);
        }
        if (place == null) {
            JSIntroduceFieldHandler.$$$reportNull$$$0(3);
        }
        PropertiesComponent.getInstance((Project)project).setValue(LAST_INIT_PLACE, place.name());
    }

    @NotNull
    public static JSIntroduceFieldSettings.InitializationPlace getLastInitPlace(@NotNull Project project) {
        String value;
        if (project == null) {
            JSIntroduceFieldHandler.$$$reportNull$$$0(4);
        }
        JSIntroduceFieldSettings.InitializationPlace initializationPlace = (value = PropertiesComponent.getInstance((Project)project).getValue(LAST_INIT_PLACE)) == null ? JSIntroduceFieldSettings.InitializationPlace.Constructor : JSIntroduceFieldSettings.InitializationPlace.valueOf(value);
        if (initializationPlace == null) {
            JSIntroduceFieldHandler.$$$reportNull$$$0(5);
        }
        return initializationPlace;
    }

    public static void setLastModifier(@NotNull Project project, @NotNull JSAttributeList.AccessType place) {
        if (project == null) {
            JSIntroduceFieldHandler.$$$reportNull$$$0(6);
        }
        if (place == null) {
            JSIntroduceFieldHandler.$$$reportNull$$$0(7);
        }
        PropertiesComponent.getInstance((Project)project).setValue(LAST_MODIFIER, place.name());
    }

    @NotNull
    public static JSAttributeList.AccessType getLastModifier(@NotNull Project project) {
        String value;
        if (project == null) {
            JSIntroduceFieldHandler.$$$reportNull$$$0(8);
        }
        JSAttributeList.AccessType accessType = (value = PropertiesComponent.getInstance((Project)project).getValue(LAST_MODIFIER)) == null ? JSAttributeList.AccessType.PACKAGE_LOCAL : JSAttributeList.AccessType.valueOf(value);
        if (accessType == null) {
            JSIntroduceFieldHandler.$$$reportNull$$$0(9);
        }
        return accessType;
    }

    @Override
    public JSIntroduceFieldDialog createDialog(Project project, JSExpression expression, JSExpression[] occurrences, PsiElement scope) {
        Collection<JSIntroduceFieldSettings.InitializationPlace> places = JSIntroduceFieldHandler.calculateAvailableInitializationPlaces((Pair<JSExpression, TextRange>)Pair.create((Object)expression, null), occurrences);
        return new JSIntroduceFieldDialog(project, occurrences, expression, scope, places, this.myForceReadonly);
    }

    @Override
    protected JSElement findAnchor(JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> context, boolean replaceAllOccurrences) {
        return JSIntroduceFieldHandler.findClassAnchor((PsiElement)context.expressionDescriptor.first);
    }

    @Override
    protected JSVariable addStatementBefore(JSElement anchor, JSVarStatement declaration) throws IncorrectOperationException {
        return JSIntroduceFieldHandler.addToClassAnchor(anchor, declaration);
    }

    @Override
    public String getDeclText(JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> baseIntroduceContext, JSElement anchor) {
        String textField = DialectDetector.isActionScript((PsiElement)anchor) ? "var" : "";
        @NonNls Object baseDeclText = this.calcDeclText(baseIntroduceContext, textField, anchor);
        if (DialectDetector.isTypeScript((PsiElement)anchor) && ((JSIntroduceFieldSettings)baseIntroduceContext.settings).isMakeReadonly()) {
            baseDeclText = "readonly " + (String)baseDeclText;
        }
        return JSIntroduceFieldHandler.prependAccessModifier(baseIntroduceContext, (String)baseDeclText);
    }

    @Override
    protected boolean shouldAddTypeAnnotation(JSExpression expression, BaseIntroduceSettings settings) {
        return super.shouldAddTypeAnnotation(expression, settings) || DialectDetector.isTypeScript((PsiElement)expression) && ((JSIntroduceFieldSettings)settings).getInitializationPlace() != JSIntroduceFieldSettings.InitializationPlace.FieldDeclaration;
    }

    @Override
    @Nullable
    protected List<Pair<JSExpression, TextRange>> getCandidateExpressions(@NotNull Editor editor, @NotNull PsiFile file2, int start, int end) {
        JSElement element;
        PsiElement elementAt;
        JSClass containingClass;
        if (editor == null) {
            JSIntroduceFieldHandler.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            JSIntroduceFieldHandler.$$$reportNull$$$0(11);
        }
        if ((containingClass = JSResolveUtil.getClassOfContext(elementAt = file2.findElementAt(start))) == null) {
            this.showErrorHint(editor, file2, JavaScriptBundle.message("javascript.introduce.field.error.no.enclosing.class", new Object[0]));
            return null;
        }
        PsiElement directParent = elementAt.getParent();
        if (elementAt instanceof PsiWhiteSpace && directParent instanceof JSClass) {
            this.showDefaultErrorHint(editor, file2);
            return null;
        }
        if (directParent instanceof JSVariable) {
            ASTNode elementAtNode = elementAt.getNode();
            if (elementAtNode != null && elementAtNode.getElementType() == JSTokenTypes.COLON) {
                elementAt = elementAt.getPrevSibling();
            }
            if (elementAt instanceof PsiWhiteSpace) {
                elementAt = elementAt.getPrevSibling();
            }
            if (elementAt instanceof JSReferenceExpression) {
                directParent = elementAt;
            }
        } else if (directParent instanceof JSReferenceExpression && ((element = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)directParent, (Class[])new Class[]{JSReferenceListMember.class, JSAttributeList.class, JSClass.class})) instanceof JSAttributeList || element instanceof JSReferenceListMember)) {
            this.showDefaultErrorHint(editor, file2);
            return null;
        }
        if (JSIntroduceFieldHandler.introduceOverVariableNameRef(directParent)) {
            return Collections.singletonList(new Pair((Object)((JSReferenceExpression)directParent), null));
        }
        return super.getCandidateExpressions(editor, file2, start, end);
    }

    @Override
    protected JSExpression @NotNull [] findOccurrences(@NotNull Pair<JSExpression, TextRange> expressionDescriptor, @NotNull JSElement scope) {
        if (expressionDescriptor == null) {
            JSIntroduceFieldHandler.$$$reportNull$$$0(12);
        }
        if (scope == null) {
            JSIntroduceFieldHandler.$$$reportNull$$$0(13);
        }
        Object[] occurrences = super.findOccurrences(expressionDescriptor, scope);
        JSClass containingClass = JSResolveUtil.getClassOfContext((PsiElement)expressionDescriptor.first);
        assert (containingClass != null);
        JSExpression[] jSExpressionArray = (JSExpression[])ContainerUtil.toArray((Collection)ContainerUtil.filter((Object[])occurrences, p -> {
            JSClass context = JSResolveUtil.getClassOfContext((PsiElement)p);
            return context != null && context == containingClass;
        }), JSExpression[]::new);
        if (jSExpressionArray == null) {
            JSIntroduceFieldHandler.$$$reportNull$$$0(14);
        }
        return jSExpressionArray;
    }

    @Override
    protected boolean validateSelectedExpression(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Pair<JSExpression, TextRange> introducedExpression) {
        if (file2 == null) {
            JSIntroduceFieldHandler.$$$reportNull$$$0(15);
        }
        if (editor == null) {
            JSIntroduceFieldHandler.$$$reportNull$$$0(16);
        }
        if (introducedExpression == null) {
            JSIntroduceFieldHandler.$$$reportNull$$$0(17);
        }
        if (!super.validateSelectedExpression(file2, editor, introducedExpression)) {
            return false;
        }
        JSClass containingClass = JSResolveUtil.getClassOfContext((PsiElement)introducedExpression.first);
        if (containingClass == null && introducedExpression.first instanceof JSClassExpression) {
            this.showDefaultErrorHint(editor, file2);
            return false;
        }
        JSFunction jsFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)introducedExpression.first), JSFunction.class);
        if (jsFunction != null && jsFunction.isConstructor()) {
            int expressionOffset = ((JSExpression)introducedExpression.first).getTextOffset();
            if (SyntaxTraverser.psiTraverser((PsiElement)jsFunction).filter(JSSuperExpression.class).filter(e -> e.getParent() instanceof JSCallExpression).filter(e -> e.getTextOffset() > expressionOffset).isNotEmpty()) {
                this.showErrorHint(editor, file2, JavaScriptBundle.message("javascript.introduce.field.before.super.call", new Object[0]));
                return false;
            }
        }
        return true;
    }

    @Override
    protected JSExpression getReplacementExpression(Pair<JSExpression, TextRange> expressionDescriptor) {
        if (JSIntroduceFieldHandler.introduceOverVariableNameRef((PsiElement)expressionDescriptor.first)) {
            return ((JSVariable)((JSExpression)expressionDescriptor.first).getParent()).getInitializer();
        }
        return super.getReplacementExpression(expressionDescriptor);
    }

    @Override
    public JSExpression createRefExpr(PsiElement context, BaseIntroduceSettings settings, PsiElement scope, JSLanguageDialect languageDialect) {
        if (languageDialect.isKindOf(JavaScriptSupportLoader.ECMA_SCRIPT_L4)) {
            return super.createRefExpr(context, settings, scope, languageDialect);
        }
        return JSPsiElementFactory.createJSExpression("this." + settings.getVariableName(), context);
    }

    @Override
    public Pair<JSVarStatement, Boolean> prepareDeclaration(String varDeclText, JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> context, Project project, @Nullable JSLanguageDialect languageDialect, JSElement anchorStatement, Editor editor) throws IncorrectOperationException {
        Pair result2;
        JSExpression initializer;
        JSIntroduceFieldSettings.InitializationPlace place = ((JSIntroduceFieldSettings)context.settings).getInitializationPlace();
        if (place == JSIntroduceFieldSettings.InitializationPlace.FieldDeclaration) {
            JSExpression initializerReplacementExpression = this.getReplacementExpression(context.expressionDescriptor);
            String fieldText = varDeclText + (initializerReplacementExpression != null ? " = 0" : "");
            JSVarStatement declaration = (JSVarStatement)JSIntroduceFieldHandler.createField(fieldText, project, languageDialect, anchorStatement);
            this.replaceInitializer(initializerReplacementExpression, declaration);
            return Pair.create((Object)declaration, (Object)Boolean.FALSE);
        }
        boolean replacedOriginal = false;
        String introducedExpressionText = JSIntroduceFieldHandler.introduceOverVariableNameRef((PsiElement)context.expressionDescriptor.first) ? ((initializer = this.getReplacementExpression(context.expressionDescriptor)) != null ? initializer.getText() : null) : this.getIntroducedExpressionText(context.expressionDescriptor);
        String nameAccess = StringUtil.notNullize((String)JSClassUtils.getDefaultFieldQualifier((PsiElement)anchorStatement, true)) + context.settings.getVariableName();
        String assignmentText = nameAccess + (String)(introducedExpressionText != null ? "=" + introducedExpressionText : "") + JSIntroduceFieldHandler.getSemicolonWithStatementASI((JSElement)ObjectUtils.coalesce((Object)this.getAnchorToAddMethod(context), (Object)anchorStatement), (JSExpression)context.expressionDescriptor.first, false);
        JSStatement psiToInsert = JSPsiElementFactory.createJSStatement(assignmentText, (PsiElement)context.expressionDescriptor.first);
        if (place == JSIntroduceFieldSettings.InitializationPlace.CurrentMethod) {
            replacedOriginal = this.addValueAssignmentInCurrentMethod(context, project, (PsiElement)psiToInsert);
        } else if (place == JSIntroduceFieldSettings.InitializationPlace.Constructor) {
            this.createConstructorAndAddValueAssignment(context, project, editor, languageDialect, (PsiElement)psiToInsert);
        }
        PsiElement field = JSIntroduceFieldHandler.createField(varDeclText, project, languageDialect, anchorStatement);
        if (replacedOriginal) {
            JSVariable addedField = this.addStatementBefore(anchorStatement, (JSVarStatement)field);
            result2 = Pair.create((Object)addedField.getStatement(), (Object)Boolean.TRUE);
            JSIntroduceFieldHandler.fixFormat((SmartPsiElementPointer<? extends PsiElement>)SmartPointerManager.createPointer((PsiElement)addedField), project, editor);
        } else {
            result2 = Pair.create((Object)((JSVarStatement)field), (Object)Boolean.FALSE);
        }
        return result2;
    }

    @Override
    protected boolean isForExpressionStatement(Pair<JSExpression, TextRange> descriptor2, JSElement sourceElement) {
        return ((JSExpression)descriptor2.first).getParent() instanceof JSExpressionStatement && !JSIntroduceFieldHandler.isIntroducingPartOfExpression(descriptor2);
    }

    private static String getSemicolonWithFieldASI(JSElement anchorStatement) {
        JSAttributeList list2;
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)anchorStatement);
        if (StringUtil.isEmpty((String)semicolon) && anchorStatement instanceof JSFunction && ((JSFunction)anchorStatement).isGenerator() && !((JSFunction)anchorStatement).isAsync() && ((list2 = ((JSAttributeListOwner)anchorStatement).getAttributeList()) == null || list2.getExplicitAccessType() == null && !list2.hasModifier(JSAttributeList.ModifierType.READONLY))) {
            return ";";
        }
        return semicolon;
    }

    private boolean addValueAssignmentInCurrentMethod(JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> context, Project project, PsiElement psiToInsert) {
        JSExpression expression;
        PsiElement addedElement;
        boolean replacedOriginal = false;
        JSElement element = this.getAnchorToAddMethod(context);
        PsiElement parent = element.getParent();
        if (JSIntroduceFieldHandler.isExprStatementWithUnneededRef(context.settings, element, context.expressionDescriptor)) {
            addedElement = element.replace(psiToInsert);
            replacedOriginal = true;
            parent = addedElement.getParent();
        } else if (JSIntroduceFieldHandler.introduceOverVariableNameRef((PsiElement)context.expressionDescriptor.first)) {
            JSVariable[] variables = ((JSVarStatement)element).getVariables();
            if (variables.length == 1) {
                addedElement = element.replace(psiToInsert);
            } else {
                addedElement = element.getParent().addBefore(psiToInsert, (PsiElement)element);
                ((JSExpression)context.expressionDescriptor.first).getParent().delete();
            }
            replacedOriginal = true;
            parent = addedElement.getParent();
        } else {
            addedElement = parent.addBefore(psiToInsert, (PsiElement)element);
        }
        SmartPsiElementPointer pointer = SmartPointerManager.createPointer((PsiElement)addedElement);
        CodeStyleManager.getInstance((Project)project).reformatNewlyAddedElement(parent.getNode(), addedElement.getNode());
        PsiElement psiElement = pointer.getElement();
        if (psiElement instanceof JSExpressionStatement && (expression = ((JSExpressionStatement)psiElement).getExpression()) instanceof JSAssignmentExpression) {
            this.myInsertedExtra.set((Object)SmartPointerManager.createPointer((PsiElement)((JSAssignmentExpression)expression)));
        }
        return replacedOriginal;
    }

    private JSElement getAnchorToAddMethod(JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> context) {
        JSExpression expression = (JSExpression)context.expressionDescriptor.first;
        if (DialectDetector.isActionScript((PsiElement)expression)) {
            return super.findAnchor(context, context.settings.isReplaceAllOccurrences());
        }
        return JSUtils.findSourceAnchor((PsiElement)expression, true);
    }

    private void createConstructorAndAddValueAssignment(JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> context, Project project, Editor editor, JSLanguageDialect languageDialect, PsiElement psiToInsert) {
        JSExpression expression;
        JSStatement finalStatement;
        JSBlockStatement body;
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)context.expressionDescriptor.first), (Class[])new Class[]{JSClass.class, JSFile.class});
        if (parent instanceof JSFile) {
            PsiFile containingFile = parent.getContext().getContainingFile();
            assert (containingFile instanceof XmlFile);
            parent = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)containingFile);
        }
        assert (parent instanceof JSClass);
        JSClass clazz = (JSClass)parent;
        JSFunction fun = clazz.getConstructor();
        if (fun == null) {
            boolean isPublic = clazz.getAttributeList() != null && clazz.getAttributeList().getAccessType() == JSAttributeList.AccessType.PUBLIC;
            @NonNls String constr = JSClassUtils.createConstructorSignatureForClass(clazz, isPublic) + "() {}";
            ASTNode member = JSChangeUtil.createClassMemberFromText(project, constr, languageDialect);
            fun = (JSFunction)BaseCreateMembersFix.addMethodToClassWithoutAnchor(clazz, languageDialect, member.getPsi(), null);
        }
        JSSourceElement[] items = (body = fun.getBlock()) == null ? JSSourceElement.EMPTY_ARRAY : body.getStatementListItems();
        JSStatement statement = null;
        boolean after = true;
        for (JSSourceElement item : items) {
            if (PsiTreeUtil.isAncestor((PsiElement)item, (PsiElement)((PsiElement)context.expressionDescriptor.first), (boolean)false)) {
                if (!(item instanceof JSStatement)) break;
                after = false;
                statement = (JSStatement)item;
                break;
            }
            if (!(item instanceof JSStatement)) continue;
            statement = (JSStatement)item;
        }
        if (statement != null) {
            JSStatement jsStatement = after ? statement.addStatementAfter((JSStatement)psiToInsert) : statement.addStatementBefore((JSStatement)psiToInsert);
            SmartPsiElementPointer pointer = SmartPointerManager.createPointer((PsiElement)jsStatement);
            JSIntroduceFieldHandler.fixFormat((SmartPsiElementPointer<? extends PsiElement>)pointer, project, editor);
            finalStatement = (JSStatement)pointer.getElement();
        } else {
            assert (body != null);
            finalStatement = (JSStatement)ObjectUtils.tryCast((Object)body.add(psiToInsert), JSStatement.class);
        }
        if (finalStatement instanceof JSExpressionStatement && (expression = ((JSExpressionStatement)finalStatement).getExpression()) instanceof JSAssignmentExpression) {
            this.myInsertedExtra.set((Object)SmartPointerManager.createPointer((PsiElement)((JSAssignmentExpression)expression)));
        }
    }

    private static PsiElement createField(String varDeclText, Project project, JSLanguageDialect languageDialect, JSElement anchorStatement) {
        String newValue = varDeclText + JSIntroduceFieldHandler.getSemicolonWithFieldASI(anchorStatement);
        return JSChangeUtil.createClassMemberFromText(project, newValue, languageDialect).getPsi();
    }

    private static boolean isExprStatementWithUnneededRef(BaseIntroduceSettings settings, JSElement introduceContext, Pair<JSExpression, TextRange> expressionDescriptor) {
        if (((JSIntroduceFieldSettings)settings).getInitializationPlace() == JSIntroduceFieldSettings.InitializationPlace.CurrentMethod) {
            return introduceContext instanceof JSExpressionStatement && (expressionDescriptor.second == null || ((TextRange)expressionDescriptor.second).equals((Object)((JSExpression)expressionDescriptor.first).getTextRange())) && ((JSExpression)expressionDescriptor.first).getParent() instanceof JSExpressionStatement;
        }
        return false;
    }

    public static Collection<JSIntroduceFieldSettings.InitializationPlace> calculateAvailableInitializationPlaces(Pair<JSExpression, TextRange> mainOccurrenceAndRange, JSExpression[] occurrences) {
        JSExpression mainOccurrence = (JSExpression)mainOccurrenceAndRange.first;
        DialectOptionHolder optionHolder = DialectDetector.dialectOfElement((PsiElement)mainOccurrence);
        EnumSet<JSIntroduceFieldSettings.InitializationPlace> values = EnumSet.allOf(JSIntroduceFieldSettings.InitializationPlace.class);
        boolean localContextDependent = JSIntroduceFieldHandler.isLocalContextDependent(mainOccurrence, (TextRange)mainOccurrenceAndRange.second);
        boolean canHaveInitializeFieldInConstructor = JSIntroduceFieldHandler.canHaveInitializerInConstructor(mainOccurrence);
        boolean canHaveInitializerInMethod = JSIntroduceFieldHandler.canHaveInitializerInMethod(mainOccurrence, optionHolder);
        if (!canHaveInitializeFieldInConstructor) {
            values.remove((Object)JSIntroduceFieldSettings.InitializationPlace.Constructor);
        }
        if (!canHaveInitializerInMethod) {
            values.remove((Object)JSIntroduceFieldSettings.InitializationPlace.CurrentMethod);
        }
        if (localContextDependent) {
            if (canHaveInitializerInMethod) {
                values.remove((Object)JSIntroduceFieldSettings.InitializationPlace.Constructor);
            }
            values.remove((Object)JSIntroduceFieldSettings.InitializationPlace.FieldDeclaration);
        }
        for (JSExpression occurrence : occurrences) {
            JSExpression initializer;
            JSField field = (JSField)PsiTreeUtil.getParentOfType((PsiElement)occurrence, JSField.class);
            if (field == null || (initializer = field.getInitializer()) == null || PsiTreeUtil.getParentOfType((PsiElement)occurrence, JSFunction.class, (boolean)true, (Class[])new Class[]{JSField.class}) != null || !PsiTreeUtil.isAncestor((PsiElement)initializer, (PsiElement)occurrence, (boolean)false)) continue;
            values.remove((Object)JSIntroduceFieldSettings.InitializationPlace.Constructor);
            break;
        }
        return values;
    }

    private static boolean isLocalContextDependent(JSExpression mainOccurence, TextRange range) {
        JSExpression elementToCheckDependence;
        JSExpression jSExpression = elementToCheckDependence = JSBaseIntroduceHandler.introduceOverVariableNameRef((PsiElement)mainOccurence) ? mainOccurence.getParent() : mainOccurence;
        if (JSBaseIntroduceHandler.calcDependsOnContext((PsiElement)elementToCheckDependence, range, true, true)) {
            return true;
        }
        JBIterable yieldExpressions = SyntaxTraverser.psiTraverser((PsiElement)mainOccurence).filter(JSYieldExpression.class);
        if (range != null) {
            yieldExpressions = yieldExpressions.filter(e -> range.contains(e.getTextRange()));
        }
        return yieldExpressions.isNotEmpty();
    }

    private static boolean canHaveInitializerInMethod(JSExpression mainOccurrence, DialectOptionHolder dialectOptionHolder) {
        JSFunction function2 = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)mainOccurrence, JSFunction.class);
        if (function2 != null && function2.isConstructor()) {
            return false;
        }
        return dialectOptionHolder == null || dialectOptionHolder.isECMA4 || !(JSUtils.findSourceAnchor((PsiElement)mainOccurrence, false) instanceof JSClass);
    }

    private static boolean canHaveInitializerInConstructor(JSExpression mainOccurrence) {
        PsiFile file2 = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)mainOccurrence, PsiFile.class);
        return (file2 == null || file2.getContext() == null) && !JSResolveUtil.calculateStaticFromContext((PsiElement)mainOccurrence) && !JSIntroduceFieldHandler.containsAwaitExpressions(mainOccurrence) && !JSIntroduceFieldHandler.containsYieldExpressions(mainOccurrence);
    }

    @Override
    protected boolean isInplaceIntroduce(Editor editor, JSElement scope, PsiFile file2) {
        return !DialectDetector.isActionScript((PsiElement)scope) && editor.getSettings().isVariableInplaceRenameEnabled();
    }

    @Override
    protected boolean canInplaceIntroduceForSubexpression() {
        return true;
    }

    @Override
    public InplaceSettings<BaseIntroduceSettings> getInplaceSettings(Pair<JSExpression, TextRange> expr, JSExpression[] occurrences, PsiElement scope, final OccurrencesChooser.ReplaceChoice choice) {
        JSExpression firstExpression = (JSExpression)expr.first;
        final Project project = firstExpression.getProject();
        BasicIntroducedEntityInfoProvider entityInfoProvider = new BasicIntroducedEntityInfoProvider(firstExpression, occurrences, scope);
        final String[] candidateNames = entityInfoProvider.suggestCandidateNames();
        final String myIntroducedName = candidateNames.length > 0 ? candidateNames[0].trim() : "newVar";
        final Collection<JSIntroduceFieldSettings.InitializationPlace> places = JSIntroduceFieldHandler.calculateAvailableInitializationPlaces(expr, occurrences);
        final boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)firstExpression);
        final String typeText = JSIntroducedExpressionUtil.willReplacePartOfExpression(expr) ? null : JSFieldInplaceIntroducer.getFieldType(firstExpression);
        return new InplaceSettings<BaseIntroduceSettings>(){

            @Override
            public String[] getSuggestedNames() {
                return candidateNames;
            }

            @Override
            public BaseIntroduceSettings getSettings() {
                return new JSIntroduceFieldSettings(){

                    @Override
                    public JSAttributeList.AccessType getAccessType() {
                        JSAttributeList.AccessType modifier = JSIntroduceFieldHandler.getLastModifier(project);
                        if (modifier == JSAttributeList.AccessType.PACKAGE_LOCAL && isTypeScript) {
                            return JSAttributeList.AccessType.PRIVATE;
                        }
                        return modifier;
                    }

                    @Override
                    public JSIntroduceFieldSettings.InitializationPlace getInitializationPlace() {
                        if (places.contains((Object)JSIntroduceFieldSettings.InitializationPlace.FieldDeclaration)) {
                            return JSIntroduceFieldSettings.InitializationPlace.FieldDeclaration;
                        }
                        JSIntroduceFieldSettings.InitializationPlace place = JSIntroduceFieldHandler.getLastInitPlace(project);
                        return places.contains((Object)place) ? place : (JSIntroduceFieldSettings.InitializationPlace)((Object)places.iterator().next());
                    }

                    @Override
                    public Collection<JSIntroduceFieldSettings.InitializationPlace> getAllPlaces() {
                        return places;
                    }

                    @Override
                    public boolean isMakeReadonly() {
                        return (JSIntroduceFieldHandler.this.myForceReadonly || JSIntroduceFieldHandler.getLastIsReadonly(project)) && this.getInitializationPlace() != JSIntroduceFieldSettings.InitializationPlace.CurrentMethod;
                    }

                    @Override
                    public boolean isReplaceAllOccurrences() {
                        return choice == OccurrencesChooser.ReplaceChoice.ALL;
                    }

                    @Override
                    public String getVariableName() {
                        return myIntroducedName;
                    }

                    @Override
                    public String getVariableType() {
                        return typeText;
                    }
                };
            }
        };
    }

    public JSFieldInplaceIntroducer createInplaceIntroducer(JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> context, JSElement scope, Editor editor, Project project, JSExpression[] occurences, Runnable callback) {
        return new JSFieldInplaceIntroducer(project, editor, occurences, this, context, callback, this.myInsertedExtra);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/introduceField/JSIntroduceFieldHandler";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionDescriptor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introducedExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduceField/JSIntroduceFieldHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastInitPlace";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastModifier";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findOccurrences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setLastIsReadonly";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLastIsReadonly";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setLastInitPlace";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLastInitPlace";
                break;
            }
            case 5: 
            case 9: 
            case 14: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setLastModifier";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLastModifier";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCandidateExpressions";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findOccurrences";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "validateSelectedExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

