/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.statistics;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.PairConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public final class JSResolveStatisticsCollector
implements PairConsumer<ResolveSource, Integer>,
Disposable {
    private static final Logger LOG = Logger.getInstance(JSResolveStatisticsCollector.class);
    private static final PairConsumer<ResolveSource, Integer> INSTANCE = new JSResolveStatisticsCollector();
    private static final PairConsumer<ResolveSource, Integer> DUMMY_INSTANCE = (source2, integer) -> {};
    private final Collection<ResolveSourceAndCount> myResults = Collections.synchronizedList(new ArrayList());

    private JSResolveStatisticsCollector() {
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this);
    }

    @NotNull
    public static PairConsumer<ResolveSource, Integer> getInstance() {
        PairConsumer<ResolveSource, Integer> pairConsumer = LOG.isDebugEnabled() ? INSTANCE : DUMMY_INSTANCE;
        if (pairConsumer == null) {
            JSResolveStatisticsCollector.$$$reportNull$$$0(0);
        }
        return pairConsumer;
    }

    public void consume(ResolveSource resolveSource, Integer count) {
        this.myResults.add(new ResolveSourceAndCount(resolveSource, count));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResultsCountDistribution() {
        int[] groups = new int[]{0, 1, 2, 5, 10, 20, 50, 100};
        int[][] results = new int[ResolveSource.values().length][groups.length];
        Collection<ResolveSourceAndCount> collection = this.myResults;
        synchronized (collection) {
            for (ResolveSourceAndCount result2 : this.myResults) {
                int group = Arrays.binarySearch(groups, result2.myCount);
                if (group < 0) {
                    group = -group - 2;
                }
                int[] nArray = results[result2.mySource.ordinal()];
                int n = group;
                nArray[n] = nArray[n] + 1;
            }
        }
        StringBuilder builder = new StringBuilder();
        for (int i2 = 0; i2 < results.length; ++i2) {
            for (int group = 0; group < groups.length; ++group) {
                builder.append(ResolveSource.values()[i2].name()).append(", ");
                if (group == groups.length - 1) {
                    builder.append(groups[group]).append('+');
                } else {
                    int from = groups[group];
                    int to = groups[group + 1] - 1;
                    builder.append(from);
                    if (to > from) {
                        builder.append(" - ").append(to);
                    }
                }
                builder.append(" : ").append(results[i2][group]).append('\n');
            }
        }
        return builder.toString();
    }

    public void dispose() {
        if (LOG.isDebugEnabled()) {
            Logger.getInstance(JSResolveStatisticsCollector.class).info(this.getResultsCountDistribution());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/statistics/JSResolveStatisticsCollector", "getInstance"));
    }

    private static class ResolveSourceAndCount {
        ResolveSource mySource;
        int myCount;

        ResolveSourceAndCount(ResolveSource source2, int count) {
            this.mySource = source2;
            this.myCount = count;
        }
    }

    public static enum ResolveSource {
        LOCAL,
        QUALIFIED,
        PROCESSED_BY_QNAME,
        PROCESSED_BY_NAME,
        SYMBOL;

    }
}

