/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.tabs.JBTabPainter;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBEditorTabPainter;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabPainterAdapter;
import com.intellij.ui.tabs.impl.themes.TabTheme;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ui/tabs/impl/EditorTabPainterAdapter;", "Lcom/intellij/ui/tabs/impl/TabPainterAdapter;", "()V", "magicOffset", "", "painter", "Lcom/intellij/ui/tabs/impl/JBEditorTabPainter;", "tabPainter", "Lcom/intellij/ui/tabs/JBTabPainter;", "getTabPainter", "()Lcom/intellij/ui/tabs/JBTabPainter;", "paintBackground", "", "label", "Lcom/intellij/ui/tabs/impl/TabLabel;", "g", "Ljava/awt/Graphics;", "tabs", "Lcom/intellij/ui/tabs/impl/JBTabsImpl;", "paintBorders", "Ljava/awt/Graphics2D;", "intellij.platform.ide"})
public final class EditorTabPainterAdapter
implements TabPainterAdapter {
    private final int magicOffset;
    private final JBEditorTabPainter painter = new JBEditorTabPainter();

    @Override
    @NotNull
    public JBTabPainter getTabPainter() {
        return this.painter;
    }

    @Override
    public void paintBackground(@NotNull TabLabel label, @NotNull Graphics g, @NotNull JBTabsImpl tabs) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)tabs, (String)"tabs");
        TabInfo info = label.getInfo();
        boolean isSelected = Intrinsics.areEqual((Object)info, (Object)tabs.getSelectedInfo());
        Rectangle rect = new Rectangle(0, 0, label.getWidth(), label.getHeight());
        Graphics2D g2d = (Graphics2D)g;
        if (isSelected) {
            JBTabsPosition jBTabsPosition = tabs.getPosition();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)jBTabsPosition), (String)"tabs.position");
            int n = tabs.getBorderThickness();
            TabInfo tabInfo = info;
            Intrinsics.checkNotNullExpressionValue((Object)tabInfo, (String)"info");
            this.painter.paintSelectedTab(jBTabsPosition, g2d, rect, n, tabInfo.getTabColor(), tabs.isActiveTabs(info), tabs.isHoveredTab(label));
            this.paintBorders(g2d, label, tabs);
        } else {
            JBTabsPosition jBTabsPosition = tabs.getPosition();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)jBTabsPosition), (String)"tabs.position");
            int n = tabs.getBorderThickness();
            TabInfo tabInfo = info;
            Intrinsics.checkNotNullExpressionValue((Object)tabInfo, (String)"info");
            this.painter.paintTab(jBTabsPosition, g2d, rect, n, tabInfo.getTabColor(), tabs.isActiveTabs(info), tabs.isHoveredTab(label));
            this.paintBorders(g2d, label, tabs);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void paintBorders(Graphics2D g, TabLabel label, JBTabsImpl tabs) {
        if (!tabs.isSingleRow()) ** GOTO lbl-1000
        v0 = tabs.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"tabs.position");
        if (!v0.isSide() && Registry.is((String)"ide.new.editor.tabs.vertical.borders")) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        paintStandardBorder = v1;
        lastPinned = label.isLastPinned();
        nextToLastPinned = label.isNextToLastPinned();
        rect = new Rectangle(0, 0, label.getWidth(), label.getHeight());
        if (paintStandardBorder || lastPinned || nextToLastPinned) {
            bounds = label.getBounds();
            if (bounds.x > this.magicOffset && (paintStandardBorder || nextToLastPinned)) {
                v2 = tabs.getPosition();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"tabs.position");
                this.painter.paintLeftGap(v2, g, rect, tabs.getBorderThickness());
            }
            if (bounds.x + bounds.width < tabs.getWidth() - this.magicOffset && (paintStandardBorder || lastPinned)) {
                v3 = tabs.getPosition();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"tabs.position");
                this.painter.paintRightGap(v3, g, rect, tabs.getBorderThickness());
            }
        }
        v4 = tabs.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"tabs.position");
        if (v4.isSide() && lastPinned) {
            bounds = label.getBounds();
            if (bounds.y + bounds.height < tabs.getHeight() - this.magicOffset) {
                v5 = tabs.getPosition();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"tabs.position");
                this.painter.paintBottomGap(v5, g, rect, tabs.getBorderThickness());
            }
        }
        v6 = tabs.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"tabs.position");
        if (v6.isSide() && nextToLastPinned) {
            bounds = label.getBounds();
            if (bounds.y + bounds.height < tabs.getHeight() - this.magicOffset) {
                v7 = tabs.getPosition();
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"tabs.position");
                this.painter.paintTopGap(v7, g, rect, tabs.getBorderThickness());
            }
        }
    }

    public EditorTabPainterAdapter() {
        this.magicOffset = 1;
    }

    @Override
    @NotNull
    public TabTheme getTabTheme() {
        return TabPainterAdapter.DefaultImpls.getTabTheme(this);
    }
}

