/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.singleRow;

import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowPassInfo;
import java.util.Iterator;

public class CompressibleSingleRowLayout
extends SingleRowLayout {
    public CompressibleSingleRowLayout(JBTabsImpl tabs) {
        super(tabs);
    }

    @Override
    protected void recomputeToLayout(SingleRowPassInfo data) {
        this.calculateRequiredLength(data);
    }

    @Override
    protected void layoutLabels(SingleRowPassInfo data) {
        if (this.myTabs.getPresentation().getTabsPosition() != JBTabsPosition.top && this.myTabs.getPresentation().getTabsPosition() != JBTabsPosition.bottom) {
            super.layoutLabels(data);
            return;
        }
        int spentLength = 0;
        int lengthEstimation = 0;
        for (TabInfo tabInfo : data.toLayout) {
            lengthEstimation += Math.max(CompressibleSingleRowLayout.getMinTabWidth(), this.myTabs.myInfo2Label.get((Object)tabInfo).getPreferredSize().width);
        }
        int extraWidth = data.toFitLength - lengthEstimation;
        Iterator<TabInfo> iterator = data.toLayout.iterator();
        while (iterator.hasNext()) {
            TabInfo tabInfo = iterator.next();
            TabLabel label = this.myTabs.myInfo2Label.get(tabInfo);
            int lengthIncrement = label.getPreferredSize().width;
            int length = !iterator.hasNext() ? Math.min(data.toFitLength - spentLength, lengthIncrement) : (extraWidth <= 0 ? (int)((float)lengthIncrement * (float)data.toFitLength / (float)lengthEstimation) : lengthIncrement);
            if (tabInfo.isPinned()) {
                length = Math.min(CompressibleSingleRowLayout.getMaxPinnedTabWidth(), length);
            }
            spentLength += length + this.myTabs.getTabHGap();
            this.applyTabLayout(data, label, length);
            data.position = (int)label.getBounds().getMaxX() + this.myTabs.getTabHGap();
        }
        for (TabInfo eachInfo : data.toDrop) {
            JBTabsImpl.resetLayout(this.myTabs.myInfo2Label.get(eachInfo));
        }
    }

    @Override
    protected boolean applyTabLayout(SingleRowPassInfo data, TabLabel label, int length) {
        boolean result = super.applyTabLayout(data, label, length);
        label.setAlignmentToCenter(false);
        return result;
    }
}

