/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.Url;
import com.intellij.util.io.CountingGZIPInputStream;
import com.intellij.util.io.HttpUrlConnectionUtil;
import com.intellij.util.io.ProgressMonitorInputStream;
import com.intellij.util.io.RequestBuilder;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.NetUtils;
import com.intellij.util.net.ssl.CertificateManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequests {
    private static final Logger LOG = Logger.getInstance(HttpRequests.class);
    public static final String JSON_CONTENT_TYPE = "application/json; charset=utf-8";
    public static final int CONNECTION_TIMEOUT = SystemProperties.getIntProperty((String)"idea.connection.timeout", (int)10000);
    public static final int READ_TIMEOUT = SystemProperties.getIntProperty((String)"idea.read.timeout", (int)60000);
    public static final int REDIRECT_LIMIT = SystemProperties.getIntProperty((String)"idea.redirect.limit", (int)10);
    private static final int[] REDIRECTS = new int[]{302, 307, 301, 303, 308};

    private HttpRequests() {
    }

    public static RequestBuilder request(@NotNull Url url) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(0);
        }
        return HttpRequests.request(url.toExternalForm());
    }

    public static RequestBuilder request(@NotNull String url) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(1);
        }
        return new RequestBuilderImpl(url, null);
    }

    public static RequestBuilder head(@NotNull String url) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(2);
        }
        return new RequestBuilderImpl(url, connection -> ((HttpURLConnection)connection).setRequestMethod("HEAD"));
    }

    public static RequestBuilder delete(@NotNull String url) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(3);
        }
        return new RequestBuilderImpl(url, connection -> ((HttpURLConnection)connection).setRequestMethod("DELETE"));
    }

    public static RequestBuilder delete(@NotNull String url, @Nullable String contentType) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(4);
        }
        return HttpRequests.requestWithBody(url, "DELETE", contentType, null);
    }

    public static RequestBuilder post(@NotNull String url, @Nullable String contentType) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(5);
        }
        return HttpRequests.requestWithBody(url, "POST", contentType, null);
    }

    public static RequestBuilder put(@NotNull String url, @Nullable String contentType) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(6);
        }
        return HttpRequests.requestWithBody(url, "PUT", contentType, null);
    }

    public static RequestBuilder patch(@NotNull String url, @Nullable String contentType) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(7);
        }
        return HttpRequests.requestWithBody(url, "POST", contentType, connection -> connection.setRequestProperty("X-HTTP-Method-Override", "PATCH"));
    }

    public static RequestBuilder requestWithRange(@NotNull String url, @NotNull String bytes) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(8);
        }
        if (bytes == null) {
            HttpRequests.$$$reportNull$$$0(9);
        }
        return HttpRequests.requestWithBody(url, "GET", null, connection -> connection.setRequestProperty("Range", "bytes=" + bytes));
    }

    private static RequestBuilder requestWithBody(String url, String requestMethod, @Nullable String contentType, @Nullable ConnectionTuner tuner) {
        return new RequestBuilderImpl(url, rawConnection -> {
            HttpURLConnection connection = (HttpURLConnection)rawConnection;
            connection.setRequestMethod(requestMethod);
            connection.setDoOutput(true);
            if (contentType != null) {
                connection.setRequestProperty("Content-Type", contentType);
            }
            if (tuner != null) {
                tuner.tune(connection);
            }
        });
    }

    @NotNull
    public static String createErrorMessage(@NotNull IOException e, @NotNull Request request, boolean includeHeaders) {
        if (e == null) {
            HttpRequests.$$$reportNull$$$0(10);
        }
        if (request == null) {
            HttpRequests.$$$reportNull$$$0(11);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Cannot download '").append(request.getURL()).append("': ").append(e.getMessage());
        try {
            URLConnection connection = request.getConnection();
            if (includeHeaders) {
                builder.append("\n, headers: ").append(connection.getHeaderFields());
            }
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                builder.append("\n, response: ").append(httpConnection.getResponseCode()).append(' ').append(httpConnection.getResponseMessage());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String string = builder.toString();
        if (string == null) {
            HttpRequests.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static <T> T process(RequestBuilderImpl builder, RequestProcessor<T> processor) throws IOException {
        Application app = ApplicationManager.getApplication();
        LOG.assertTrue(app == null || app.isUnitTestMode() || app.isHeadlessEnvironment() || !app.isReadAccessAllowed(), (Object)"Network shouldn't be accessed in EDT or inside read action");
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        if (contextLoader != null && HttpRequests.shouldOverrideContextClassLoader()) {
            try {
                T t;
                try (URLClassLoader cl = new URLClassLoader(new URL[0], contextLoader);){
                    Thread.currentThread().setContextClassLoader(cl);
                    t = HttpRequests.doProcess(builder, processor);
                }
                return t;
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextLoader);
            }
        }
        return HttpRequests.doProcess(builder, processor);
    }

    private static boolean shouldOverrideContextClassLoader() {
        return SystemProperties.getBooleanProperty((String)"http.requests.override.context.classloader", (boolean)true);
    }

    private static <T> T doProcess(RequestBuilderImpl builder, RequestProcessor<T> processor) throws IOException {
        try (RequestImpl request = new RequestImpl(builder);){
            HttpURLConnection urlConnection;
            int responseCode;
            URLConnection connection;
            T result = processor.process(request);
            if (builder.myThrowStatusCodeException && (connection = request.myConnection) != null && connection.getDoOutput() && (responseCode = (urlConnection = (HttpURLConnection)connection).getResponseCode()) >= 400) {
                HttpRequests.throwHttpStatusError(urlConnection, request, builder, responseCode);
            }
            T t = result;
            return t;
        }
    }

    private static URLConnection openConnection(RequestBuilderImpl builder, RequestImpl request) throws IOException {
        if (builder.myForceHttps && request.myUrl.startsWith("http:")) {
            request.myUrl = "https:" + request.myUrl.substring(5);
        }
        for (int i = 0; i < builder.myRedirectLimit; ++i) {
            String url;
            block22: {
                URLConnection connection;
                block20: {
                    int responseCode;
                    HttpURLConnection httpURLConnection;
                    block21: {
                        url = request.myUrl;
                        connection = !builder.myUseProxy ? new URL(url).openConnection(Proxy.NO_PROXY) : (ApplicationManager.getApplication() == null ? new URL(url).openConnection() : HttpConfigurable.getInstance().openConnection(url));
                        if (connection instanceof HttpsURLConnection) {
                            HttpRequests.configureSslConnection(url, (HttpsURLConnection)connection);
                        }
                        connection.setConnectTimeout(builder.myConnectTimeout);
                        connection.setReadTimeout(builder.myTimeout);
                        if (builder.myUserAgent != null) {
                            connection.setRequestProperty("User-Agent", builder.myUserAgent);
                        }
                        if (builder.myHostnameVerifier != null && connection instanceof HttpsURLConnection) {
                            ((HttpsURLConnection)connection).setHostnameVerifier(builder.myHostnameVerifier);
                        }
                        if (builder.myGzip) {
                            connection.setRequestProperty("Accept-Encoding", "gzip");
                        }
                        if (builder.myAccept != null) {
                            connection.setRequestProperty("Accept", builder.myAccept);
                        }
                        connection.setUseCaches(false);
                        if (builder.myInternalTuner != null) {
                            builder.myInternalTuner.tune(connection);
                        }
                        if (builder.myTuner != null) {
                            builder.myTuner.tune(connection);
                        }
                        HttpRequests.checkRequestHeadersForNulBytes(connection);
                        if (!(connection instanceof HttpURLConnection)) {
                            return connection;
                        }
                        if (connection.getDoOutput()) {
                            return connection;
                        }
                        httpURLConnection = (HttpURLConnection)connection;
                        String method = httpURLConnection.getRequestMethod();
                        LOG.assertTrue(method.equals("GET") || method.equals("HEAD") || method.equals("DELETE"), (Object)("'" + method + "' not supported; please use GET, HEAD, DELETE, PUT or POST"));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("connecting to " + url);
                        }
                        try {
                            responseCode = httpURLConnection.getResponseCode();
                        }
                        catch (SSLHandshakeException e) {
                            throw !NetUtils.isSniEnabled() ? new SSLException("SSL error probably caused by disabled SNI", e) : e;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("response from " + url + ": " + responseCode);
                        }
                        if (responseCode >= 200 && (responseCode < 300 || responseCode == 304)) break block20;
                        if (ArrayUtil.indexOf((int[])REDIRECTS, (int)responseCode) < 0) break block21;
                        httpURLConnection.disconnect();
                        url = connection.getHeaderField("Location");
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("redirect from " + url + ": " + url);
                        }
                        if (url != null) break block22;
                    }
                    if (builder.myThrowStatusCodeException) {
                        HttpRequests.throwHttpStatusError(httpURLConnection, request, builder, responseCode);
                    }
                }
                return connection;
            }
            request.myUrl = url;
        }
        throw new IOException(IdeBundle.message("error.connection.failed.redirects", new Object[0]));
    }

    private static void throwHttpStatusError(@NotNull HttpURLConnection connection, RequestImpl request, RequestBuilderImpl builder, int responseCode) throws IOException {
        InputStream errorStream;
        if (connection == null) {
            HttpRequests.$$$reportNull$$$0(13);
        }
        Object message = null;
        if (builder.myIsReadResponseOnError && (errorStream = connection.getErrorStream()) != null) {
            errorStream = request.unzipStreamIfNeeded(connection, errorStream);
            message = HttpUrlConnectionUtil.readString(errorStream, connection);
        }
        if (Strings.isEmpty(message)) {
            message = "Request failed with status code " + responseCode;
        }
        connection.disconnect();
        throw new HttpStatusException((String)message, responseCode, Objects.requireNonNullElse(request.myUrl, "Empty URL"));
    }

    private static void configureSslConnection(@NotNull String url, @NotNull HttpsURLConnection connection) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(14);
        }
        if (connection == null) {
            HttpRequests.$$$reportNull$$$0(15);
        }
        if (ApplicationManager.getApplication() == null) {
            LOG.info("Application is not initialized yet; Using default SSL configuration to connect to " + url);
            return;
        }
        try {
            SSLSocketFactory factory = CertificateManager.getInstance().getSslContext().getSocketFactory();
            if (factory == null) {
                LOG.info("SSLSocketFactory is not defined by the IDE Certificate Manager; Using default SSL configuration to connect to " + url);
            } else {
                connection.setSSLSocketFactory(factory);
            }
        }
        catch (Throwable e) {
            LOG.info("Problems configuring SSL connection to " + url, e);
        }
    }

    private static void checkRequestHeadersForNulBytes(URLConnection connection) {
        block0: for (Map.Entry<String, List<String>> header : connection.getRequestProperties().entrySet()) {
            for (String headerValue : header.getValue()) {
                if (headerValue.indexOf(0) < 0) continue;
                connection.setRequestProperty(header.getKey(), null);
                LOG.error(String.format("Problem during request to '%s'. Header's '%s' value contains NUL bytes: '%s'. Omitting this header.", connection.getURL().toString(), header.getKey(), headerValue));
                continue block0;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/HttpRequests";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/HttpRequests";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "request";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "head";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "post";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "patch";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "requestWithRange";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createErrorMessage";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "throwHttpStatusError";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "configureSslConnection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class RequestImpl
    implements Request,
    AutoCloseable {
        private final RequestBuilderImpl myBuilder;
        private String myUrl;
        private URLConnection myConnection;
        private InputStream myInputStream;
        private BufferedReader myReader;

        private RequestImpl(RequestBuilderImpl builder) {
            this.myBuilder = builder;
            this.myUrl = this.myBuilder.myUrl;
        }

        @Override
        @NotNull
        public String getURL() {
            String string = this.myUrl;
            if (string == null) {
                RequestImpl.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public URLConnection getConnection() throws IOException {
            if (this.myConnection == null) {
                this.myConnection = HttpRequests.openConnection(this.myBuilder, this);
            }
            URLConnection uRLConnection = this.myConnection;
            if (uRLConnection == null) {
                RequestImpl.$$$reportNull$$$0(1);
            }
            return uRLConnection;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            if (this.myInputStream == null) {
                URLConnection connection = this.getConnection();
                this.myInputStream = this.unzipStreamIfNeeded(connection, connection.getInputStream());
            }
            InputStream inputStream = this.myInputStream;
            if (inputStream == null) {
                RequestImpl.$$$reportNull$$$0(2);
            }
            return inputStream;
        }

        private InputStream unzipStreamIfNeeded(URLConnection connection, InputStream stream) throws IOException {
            return this.myBuilder.myGzip && "gzip".equalsIgnoreCase(connection.getContentEncoding()) ? CountingGZIPInputStream.create((InputStream)stream) : stream;
        }

        @Override
        @NotNull
        public BufferedReader getReader() throws IOException {
            BufferedReader bufferedReader = this.getReader(null);
            if (bufferedReader == null) {
                RequestImpl.$$$reportNull$$$0(3);
            }
            return bufferedReader;
        }

        @Override
        @NotNull
        public BufferedReader getReader(@Nullable ProgressIndicator indicator) throws IOException {
            if (this.myReader == null) {
                int contentLength;
                InputStream inputStream = this.getInputStream();
                if (indicator != null && (contentLength = this.getConnection().getContentLength()) > 0) {
                    inputStream = new ProgressMonitorInputStream(indicator, inputStream, contentLength);
                }
                this.myReader = new BufferedReader(new InputStreamReader(inputStream, this.getCharset()));
            }
            BufferedReader bufferedReader = this.myReader;
            if (bufferedReader == null) {
                RequestImpl.$$$reportNull$$$0(4);
            }
            return bufferedReader;
        }

        @NotNull
        private Charset getCharset() throws IOException {
            Charset charset = HttpUrlConnectionUtil.getCharset(this.getConnection());
            if (charset == null) {
                RequestImpl.$$$reportNull$$$0(5);
            }
            return charset;
        }

        @Override
        public boolean isSuccessful() throws IOException {
            URLConnection connection = this.getConnection();
            return !(connection instanceof HttpURLConnection) || ((HttpURLConnection)connection).getResponseCode() == 200;
        }

        @Override
        public byte @NotNull [] readBytes(@Nullable ProgressIndicator indicator) throws IOException {
            byte[] byArray = this.doReadBytes(indicator).toByteArray();
            if (byArray == null) {
                RequestImpl.$$$reportNull$$$0(6);
            }
            return byArray;
        }

        @NotNull
        private BufferExposingByteArrayOutputStream doReadBytes(@Nullable ProgressIndicator indicator) throws IOException {
            BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream = HttpUrlConnectionUtil.readBytes(this.getInputStream(), this.getConnection(), indicator);
            if (bufferExposingByteArrayOutputStream == null) {
                RequestImpl.$$$reportNull$$$0(7);
            }
            return bufferExposingByteArrayOutputStream;
        }

        @Override
        @NotNull
        public String readString(@Nullable ProgressIndicator indicator) throws IOException {
            String string = HttpUrlConnectionUtil.readString(this.getInputStream(), this.getConnection(), indicator);
            if (string == null) {
                RequestImpl.$$$reportNull$$$0(8);
            }
            return string;
        }

        @Override
        @NotNull
        public CharSequence readChars(@Nullable ProgressIndicator indicator) throws IOException {
            BufferExposingByteArrayOutputStream byteStream = this.doReadBytes(indicator);
            if (byteStream.size() == 0) {
                CharSequence charSequence = Strings.EMPTY_CHAR_SEQUENCE;
                if (charSequence == null) {
                    RequestImpl.$$$reportNull$$$0(9);
                }
                return charSequence;
            }
            CharBuffer charBuffer = this.getCharset().decode(ByteBuffer.wrap(byteStream.getInternalBuffer(), 0, byteStream.size()));
            if (charBuffer == null) {
                RequestImpl.$$$reportNull$$$0(10);
            }
            return charBuffer;
        }

        @Override
        @NotNull
        public File saveToFile(@NotNull File file, @Nullable ProgressIndicator indicator) throws IOException {
            if (file == null) {
                RequestImpl.$$$reportNull$$$0(11);
            }
            FileUtilRt.createParentDirs((File)file);
            boolean deleteFile = true;
            try (FileOutputStream out = new FileOutputStream(file);){
                NetUtils.copyStreamContent((ProgressIndicator)indicator, (InputStream)this.getInputStream(), (OutputStream)out, (int)this.getConnection().getContentLength());
                deleteFile = false;
            }
            catch (HttpStatusException e) {
                throw e;
            }
            catch (IOException e) {
                throw new IOException(HttpRequests.createErrorMessage(e, this, false), e);
            }
            finally {
                if (deleteFile) {
                    FileUtilRt.delete((File)file);
                }
            }
            File file2 = file;
            if (file2 == null) {
                RequestImpl.$$$reportNull$$$0(12);
            }
            return file2;
        }

        @Override
        @NotNull
        public Path saveToFile(@NotNull Path file, @Nullable ProgressIndicator indicator) throws IOException {
            if (file == null) {
                RequestImpl.$$$reportNull$$$0(13);
            }
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            boolean deleteFile = true;
            try (OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
                NetUtils.copyStreamContent((ProgressIndicator)indicator, (InputStream)this.getInputStream(), (OutputStream)out, (int)this.getConnection().getContentLength());
                deleteFile = false;
            }
            catch (HttpStatusException e) {
                throw e;
            }
            catch (IOException e) {
                throw new IOException(HttpRequests.createErrorMessage(e, this, false), e);
            }
            finally {
                if (deleteFile) {
                    Files.deleteIfExists(file);
                }
            }
            Path path2 = file;
            if (path2 == null) {
                RequestImpl.$$$reportNull$$$0(14);
            }
            return path2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try (InputStream s = this.myInputStream;){
                BufferedReader r = this.myReader;
                if (r != null) {
                    ((Reader)r).close();
                }
            }
            finally {
                if (this.myConnection instanceof HttpURLConnection) {
                    ((HttpURLConnection)this.myConnection).disconnect();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 11: 
                case 13: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 11: 
                case 13: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/io/HttpRequests$RequestImpl";
                    break;
                }
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getURL";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConnection";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInputStream";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReader";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCharset";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readBytes";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doReadBytes";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readString";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readChars";
                    break;
                }
                case 11: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/io/HttpRequests$RequestImpl";
                    break;
                }
                case 12: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "saveToFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 11: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "saveToFile";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 11: 
                case 13: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class RequestBuilderImpl
    extends RequestBuilder {
        private final String myUrl;
        private int myConnectTimeout;
        private int myTimeout;
        private int myRedirectLimit;
        private boolean myGzip;
        private boolean myForceHttps;
        private boolean myUseProxy;
        private boolean myIsReadResponseOnError;
        private HostnameVerifier myHostnameVerifier;
        private String myUserAgent;
        private String myAccept;
        private ConnectionTuner myTuner;
        private final ConnectionTuner myInternalTuner;
        private boolean myThrowStatusCodeException;

        private RequestBuilderImpl(@NotNull String url, @Nullable ConnectionTuner internalTuner) {
            if (url == null) {
                RequestBuilderImpl.$$$reportNull$$$0(0);
            }
            this.myConnectTimeout = CONNECTION_TIMEOUT;
            this.myTimeout = READ_TIMEOUT;
            this.myRedirectLimit = REDIRECT_LIMIT;
            this.myGzip = true;
            this.myUseProxy = true;
            this.myThrowStatusCodeException = true;
            this.myUrl = url;
            this.myInternalTuner = internalTuner;
        }

        @Override
        public RequestBuilder connectTimeout(int value2) {
            this.myConnectTimeout = value2;
            return this;
        }

        @Override
        public RequestBuilder readTimeout(int value2) {
            this.myTimeout = value2;
            return this;
        }

        @Override
        public RequestBuilder redirectLimit(int redirectLimit) {
            this.myRedirectLimit = redirectLimit;
            return this;
        }

        @Override
        public RequestBuilder gzip(boolean value2) {
            this.myGzip = value2;
            return this;
        }

        @Override
        public RequestBuilder forceHttps(boolean forceHttps) {
            this.myForceHttps = forceHttps;
            return this;
        }

        @Override
        public RequestBuilder useProxy(boolean useProxy) {
            this.myUseProxy = useProxy;
            return this;
        }

        @Override
        public RequestBuilder isReadResponseOnError(boolean isReadResponseOnError) {
            this.myIsReadResponseOnError = isReadResponseOnError;
            return this;
        }

        @Override
        public RequestBuilder hostNameVerifier(@Nullable HostnameVerifier hostnameVerifier) {
            this.myHostnameVerifier = hostnameVerifier;
            return this;
        }

        @Override
        public RequestBuilder userAgent(@Nullable String userAgent) {
            this.myUserAgent = userAgent;
            return this;
        }

        @Override
        public RequestBuilder productNameAsUserAgent() {
            Application app = ApplicationManager.getApplication();
            if (app != null && !app.isDisposed()) {
                String productName = ApplicationNamesInfo.getInstance().getFullProductName();
                String version = ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode();
                return this.userAgent(productName + "/" + version);
            }
            return this.userAgent("IntelliJ");
        }

        @Override
        public RequestBuilder accept(@Nullable String mimeType) {
            this.myAccept = mimeType;
            return this;
        }

        @Override
        public RequestBuilder tuner(@Nullable ConnectionTuner tuner) {
            this.myTuner = tuner;
            return this;
        }

        @Override
        @NotNull
        public RequestBuilder throwStatusCodeException(boolean shouldThrow) {
            this.myThrowStatusCodeException = shouldThrow;
            RequestBuilderImpl requestBuilderImpl = this;
            if (requestBuilderImpl == null) {
                RequestBuilderImpl.$$$reportNull$$$0(1);
            }
            return requestBuilderImpl;
        }

        @Override
        public <T> T connect(@NotNull RequestProcessor<T> processor) throws IOException {
            if (processor == null) {
                RequestBuilderImpl.$$$reportNull$$$0(2);
            }
            return HttpRequests.process(this, processor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/io/HttpRequests$RequestBuilderImpl";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/io/HttpRequests$RequestBuilderImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "throwStatusCodeException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "connect";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class HttpStatusException
    extends IOException {
        private final int myStatusCode;
        private final String myUrl;

        public HttpStatusException(@NotNull String message, int statusCode, @NotNull String url) {
            if (message == null) {
                HttpStatusException.$$$reportNull$$$0(0);
            }
            if (url == null) {
                HttpStatusException.$$$reportNull$$$0(1);
            }
            super(message);
            this.myStatusCode = statusCode;
            this.myUrl = url;
        }

        public int getStatusCode() {
            return this.myStatusCode;
        }

        @NotNull
        public String getUrl() {
            String string = this.myUrl;
            if (string == null) {
                HttpStatusException.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public String toString() {
            return super.toString() + ". Status=" + this.myStatusCode + ", Url=" + this.myUrl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/io/HttpRequests$HttpStatusException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/io/HttpRequests$HttpStatusException";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ConnectionTuner {
        public void tune(@NotNull URLConnection var1) throws IOException;
    }

    public static interface RequestProcessor<T> {
        public T process(@NotNull Request var1) throws IOException;
    }

    public static interface Request {
        @NotNull
        public String getURL();

        @NotNull
        public URLConnection getConnection() throws IOException;

        @NotNull
        public InputStream getInputStream() throws IOException;

        @NotNull
        public BufferedReader getReader() throws IOException;

        @NotNull
        public BufferedReader getReader(@Nullable ProgressIndicator var1) throws IOException;

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
        public boolean isSuccessful() throws IOException;

        @NotNull
        public File saveToFile(@NotNull File var1, @Nullable ProgressIndicator var2) throws IOException;

        @NotNull
        public Path saveToFile(@NotNull Path var1, @Nullable ProgressIndicator var2) throws IOException;

        public byte @NotNull [] readBytes(@Nullable ProgressIndicator var1) throws IOException;

        @NotNull
        public String readString(@Nullable ProgressIndicator var1) throws IOException;

        @NotNull
        default public String readString() throws IOException {
            String string = this.readString(null);
            if (string == null) {
                Request.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public CharSequence readChars(@Nullable ProgressIndicator var1) throws IOException;

        default public void write(@NotNull String data) throws IOException {
            if (data == null) {
                Request.$$$reportNull$$$0(1);
            }
            this.write(data.getBytes(StandardCharsets.UTF_8));
        }

        default public void write(byte @NotNull [] data) throws IOException {
            if (data == null) {
                Request.$$$reportNull$$$0(2);
            }
            HttpURLConnection connection = (HttpURLConnection)this.getConnection();
            connection.setFixedLengthStreamingMode(data.length);
            try (OutputStream stream = connection.getOutputStream();){
                stream.write(data);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/io/HttpRequests$Request";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readString";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/io/HttpRequests$Request";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "write";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

