/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.proxy;

import com.intellij.openapi.application.PathManager;
import com.intellij.util.proxy.PropertiesEncryptionSupport;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SharedProxyConfig {
    private static final Path CONFIG_FILE = PathManager.getConfigDir().resolve("proxy_config");
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String LOGIN = "login";
    private static final String PASSWORD = "password";
    private static final PropertiesEncryptionSupport ourEncryptionSupport = new PropertiesEncryptionSupport();

    public static boolean clear() {
        try {
            return Files.deleteIfExists(CONFIG_FILE);
        }
        catch (IOException e) {
            return false;
        }
    }

    @Nullable
    public static ProxyParameters load() {
        try {
            Properties props = ourEncryptionSupport.load(CONFIG_FILE);
            String password = props.getProperty(PASSWORD, "");
            return new ProxyParameters(props.getProperty(HOST, null), Integer.parseInt(props.getProperty(PORT, "0")), props.getProperty(LOGIN, null), password.toCharArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean store(@NotNull ProxyParameters params) {
        if (params == null) {
            SharedProxyConfig.$$$reportNull$$$0(0);
        }
        if (params.host != null) {
            try {
                Properties props = new Properties();
                props.setProperty(HOST, params.host);
                props.setProperty(PORT, String.valueOf(params.port));
                if (params.login != null) {
                    props.setProperty(LOGIN, params.login);
                    props.setProperty(PASSWORD, new String(params.password));
                }
                ourEncryptionSupport.store(props, "Proxy Configuration", CONFIG_FILE);
                return true;
            }
            catch (Exception exception) {}
        } else {
            try {
                Files.deleteIfExists(CONFIG_FILE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/util/proxy/SharedProxyConfig", "store"));
    }

    public static final class ProxyParameters {
        @Nullable
        public final String host;
        public final int port;
        @Nullable
        public final String login;
        public final char @NotNull [] password;

        public ProxyParameters(@Nullable String host, int port) {
            this(host, port, null, new char[0]);
        }

        public ProxyParameters(@Nullable String host, int port, @Nullable String login, char @NotNull [] password) {
            if (password == null) {
                ProxyParameters.$$$reportNull$$$0(0);
            }
            this.host = host;
            this.port = port;
            this.login = login;
            this.password = password;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", SharedProxyConfig.PASSWORD, "com/intellij/util/proxy/SharedProxyConfig$ProxyParameters", "<init>"));
        }
    }
}

