/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLanguageSupportManager;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrStackFrame
extends XStackFrame
implements UserDataHolderEx {
    @NotNull
    private final UserDataHolderBase myUserDataHolder;
    @NotNull
    private final CidrDebugProcess myProcess;
    @NotNull
    private final LLThread myThread;
    @NotNull
    private final LLFrame myFrame;
    @Nullable
    private final CidrSuspensionCause mySuspensionCause;
    public static final Key THROW_ON_VARIABLES_COLLECTION = Key.create((String)"THROW_ON_VARIABLES_COLLECTION");
    @NotNull
    private final NotNullLazyValue<Pair<XSourcePosition, Boolean>> mySourceOrDisasmLazyValue;

    public CidrStackFrame(@NotNull CidrDebugProcess process, @NotNull LLThread thread, @NotNull LLFrame frame, @Nullable CidrSuspensionCause suspensionCause) {
        if (process == null) {
            CidrStackFrame.$$$reportNull$$$0(0);
        }
        if (thread == null) {
            CidrStackFrame.$$$reportNull$$$0(1);
        }
        if (frame == null) {
            CidrStackFrame.$$$reportNull$$$0(2);
        }
        this.myUserDataHolder = new UserDataHolderBase();
        this.mySourceOrDisasmLazyValue = NotNullLazyValue.createValue(this::doGetSourceOrDisasm);
        this.myProcess = process;
        this.myThread = thread;
        this.myFrame = frame;
        this.mySuspensionCause = suspensionCause;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            CidrStackFrame.$$$reportNull$$$0(3);
        }
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            CidrStackFrame.$$$reportNull$$$0(4);
        }
        this.myUserDataHolder.putUserData(key, value);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        if (key == null) {
            CidrStackFrame.$$$reportNull$$$0(5);
        }
        if (value == null) {
            CidrStackFrame.$$$reportNull$$$0(6);
        }
        Object object = this.myUserDataHolder.putUserDataIfAbsent(key, value);
        if (object == null) {
            CidrStackFrame.$$$reportNull$$$0(7);
        }
        return (T)object;
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        if (key == null) {
            CidrStackFrame.$$$reportNull$$$0(8);
        }
        return this.myUserDataHolder.replace(key, oldValue, newValue);
    }

    @NotNull
    public CidrDebugProcess getProcess() {
        CidrDebugProcess cidrDebugProcess = this.myProcess;
        if (cidrDebugProcess == null) {
            CidrStackFrame.$$$reportNull$$$0(9);
        }
        return cidrDebugProcess;
    }

    @NotNull
    public LLThread getThread() {
        LLThread lLThread = this.myThread;
        if (lLThread == null) {
            CidrStackFrame.$$$reportNull$$$0(10);
        }
        return lLThread;
    }

    public long getThreadId() {
        return this.myThread.getId();
    }

    @NotNull
    public LLFrame getFrame() {
        LLFrame lLFrame = this.myFrame;
        if (lLFrame == null) {
            CidrStackFrame.$$$reportNull$$$0(11);
        }
        return lLFrame;
    }

    public int getFrameIndex() {
        return this.myFrame.getIndex();
    }

    public Object getEqualityObject() {
        return Pair.create((Object)this.myThread.getId(), (Object)this.myFrame.getIndex());
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.getSourcePosition(true);
    }

    @Nullable
    public XSourcePosition getSourcePosition(boolean disassembleIfNeeded) {
        Pair sourceOrDisasm = (Pair)this.mySourceOrDisasmLazyValue.getValue();
        return disassembleIfNeeded || (Boolean)sourceOrDisasm.second != false ? (XSourcePosition)sourceOrDisasm.first : null;
    }

    public boolean hasSourceFile() {
        return this.getSourcePosition(false) != null;
    }

    @NotNull
    protected Pair<XSourcePosition, Boolean> doGetSourceOrDisasm() {
        Pair<XSourcePosition, Boolean> pair = this.myProcess.createSourceOrDisasmPosition(this.myFrame.getFile(), this.myFrame.getHash(), this.myFrame.getLine(), this.myFrame.getProgramCounter());
        if (pair == null) {
            CidrStackFrame.$$$reportNull$$$0(12);
        }
        return pair;
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        String functionName;
        if (component == null) {
            CidrStackFrame.$$$reportNull$$$0(13);
        }
        component.setIcon(AllIcons.Debugger.Frame);
        XSourcePosition position = this.getSourcePosition(false);
        boolean hasFunctionName = this.myFrame.hasSymbolInfo();
        String string = functionName = hasFunctionName ? this.myFrame.getFunction() : CidrDebuggerBundle.message("debug.frames.unknownFunction", new Object[0]);
        if (position != null) {
            component.append(functionName, hasFunctionName ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
            component.append(" " + position.getFile().getName() + ":" + (position.getLine() + 1), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        } else {
            component.append(functionName, hasFunctionName ? SimpleTextAttributes.GRAYED_ATTRIBUTES : SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
            component.append(" " + this.myFrame.getProgramCounter(), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        }
    }

    public final void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            CidrStackFrame.$$$reportNull$$$0(14);
        }
        if (CidrDebugProcess.viewsUpdatesDisabledInTests(node)) {
            return;
        }
        this.myProcess.postCommand(driver -> {
            try {
                this.doComputeChildren(driver, node);
            }
            catch (DebuggerCommandException e) {
                node.setErrorMessage(e.getMessage());
            }
            catch (ExecutionException e) {
                node.setErrorMessage(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                throw e;
            }
        });
    }

    private void doComputeChildren(@NotNull DebuggerDriver driver, @NotNull XCompositeNode node) throws DebuggerCommandException, ExecutionException {
        if (driver == null) {
            CidrStackFrame.$$$reportNull$$$0(15);
        }
        if (node == null) {
            CidrStackFrame.$$$reportNull$$$0(16);
        }
        if (node.isObsolete()) {
            return;
        }
        if (this.mySuspensionCause != null) {
            XValueChildrenList list = new XValueChildrenList(1);
            list.add(new XNamedValue(this.mySuspensionCause.type){

                public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (place == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    node.setPresentation(CidrStackFrame.this.mySuspensionCause.icon, null, CidrStackFrame.this.mySuspensionCause.reason, false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "node";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "place";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/cidr/execution/debugger/CidrStackFrame$1";
                    objectArray[2] = "computePresentation";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            node.addChildren(list, false);
        }
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_VARIABLES_COLLECTION);
        XSourcePosition framePosition = this.getSourcePosition(false);
        driver.setValuesFilteringEnabled(CidrDebuggerSettings.getInstance().VALUES_FILTER_ENABLED);
        List<LLValue> vars = this.myFrame.getLanguage() == DebuggerDriver.StandardDebuggerLanguage.SWIFT ? ((LLDBDriver)driver).getVariables(this.myThread.getId(), this.myFrame.getIndex(), true, true) : driver.getVariables(this.myThread, this.myFrame);
        this.myProcess.getTypesHelper(this).filterLocalVariables(framePosition, vars, () -> ((XCompositeNode)node).isObsolete()).whenComplete((filteredVars, t) -> {
            if (filteredVars != null) {
                CidrValue.addLocalValues(filteredVars, this.myProcess, framePosition, this, node);
            } else {
                vars.forEach(v -> v.setValid(false));
                CidrValue.addLocalValues(vars, this.myProcess, framePosition, this, node);
            }
        });
    }

    public CidrEvaluator getEvaluator() {
        return CidrDebuggerLanguageSupportManager.getInstance().createEvaluator(this);
    }

    public String toString() {
        return this.myFrame.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrStackFrame";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrStackFrame";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcess";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getThread";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrame";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetSourceOrDisasm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "customizePresentation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doComputeChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

