/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.javascript.debugger.FileResolverByContentKt;
import com.intellij.javascript.debugger.sourcemap.SourceMapLoaderKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.io.AsarFileSystem;
import com.intellij.util.io.FileItem;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ScriptDebuggerUrls;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/util/io/AsarFileFinder;", "", "()V", "pathToAsarFs", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/util/io/AsarFileSystem;", "findFileIfAsar", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "Lcom/intellij/util/Url;", "project", "Lcom/intellij/openapi/project/Project;", "getAsarFs", "path", "intellij.javascript.debugger"})
public final class AsarFileFinder {
    private final ConcurrentHashMap<String, AsarFileSystem> pathToAsarFs = new ConcurrentHashMap();

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final VirtualFile findFileIfAsar(@NotNull Url url, @NotNull Project project) {
        Collection files2;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!url.isInLocalFileSystem()) {
            return null;
        }
        String string = ScriptDebuggerUrls.INSTANCE.toFilePath(url);
        if (string == null) {
            return null;
        }
        String scriptPath = string;
        int index = StringsKt.indexOf$default((CharSequence)scriptPath, (String)".asar/", (int)0, (boolean)false, (int)6, null);
        if (index <= 0) {
            return null;
        }
        String string2 = scriptPath;
        int n = 0;
        int n2 = index + 5;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        AsarFileSystem asarFileSystem = this.getAsarFs(string4, project);
        if (asarFileSystem == null) {
            return null;
        }
        AsarFileSystem fs = asarFileSystem;
        String string5 = scriptPath;
        n2 = index + ".asar/".length();
        bl = false;
        String string6 = string5;
        if (string6 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string7 = string6.substring(n2);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
        String scriptRelativePath = string7;
        FileItem fileItem = fs.getFile(scriptRelativePath);
        if (fileItem == null) {
            return null;
        }
        FileItem fileItem2 = fileItem;
        VirtualFile virtualFile = fs.getVfsRoot();
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile2;
            boolean bl3 = false;
            VirtualFile virtualFile3 = it.findFileByRelativePath(scriptRelativePath);
            if (virtualFile3 != null) {
                VirtualFile virtualFile4 = virtualFile3;
                boolean bl4 = false;
                boolean bl5 = false;
                VirtualFile it2 = virtualFile4;
                boolean bl6 = false;
                return it2;
            }
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getContentScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"ProjectScope.getContentScope(project)");
        GlobalSearchScope scope = globalSearchScope;
        boolean $i$f$runReadAction22 = false;
        Object object = ApplicationManager.getApplication().runReadAction(new Computable(scriptRelativePath, scope){
            final /* synthetic */ String $scriptRelativePath$inlined;
            final /* synthetic */ GlobalSearchScope $scope$inlined;
            {
                this.$scriptRelativePath$inlined = string;
                this.$scope$inlined = globalSearchScope;
            }

            public final T compute() {
                boolean bl = false;
                return (T)FilenameIndex.getVirtualFilesByName((String)PathUtilRt.getFileName((String)this.$scriptRelativePath$inlined), (GlobalSearchScope)this.$scope$inlined);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction { Filename\u2026ptRelativePath), scope) }");
        Iterable $i$f$runReadAction22 = files2 = (Collection)object;
        boolean it = false;
        if (!$i$f$runReadAction22.isEmpty()) {
            void $this$filterTo$iv;
            $i$f$runReadAction22 = files2;
            Collection destination$iv = (Collection)new SmartList();
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                VirtualFile it3 = (VirtualFile)element$iv;
                boolean bl7 = false;
                VirtualFile virtualFile5 = it3;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile5, (String)"it");
                String string8 = virtualFile5.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"it.path");
                if (!FileUtilKt.endsWithName((String)string8, (String)scriptRelativePath)) continue;
                destination$iv.add(element$iv);
            }
            Collection collection = files2 = destination$iv;
            boolean bl8 = false;
            if (!collection.isEmpty()) {
                return FileResolverByContentKt.selectMostSimilarFile$default(files2, fs.loadText(fileItem2), null, 4, null);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final AsarFileSystem getAsarFs(@NotNull String path, @NotNull Project project) {
        void fs;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = this.pathToAsarFs.get(path);
        if ((AsarFileSystem)fs.element == null) {
            void it;
            Path path2 = SourceMapLoaderKt.regularFile(path);
            if (path2 == null) {
                return null;
            }
            Path path3 = path2;
            boolean bl = false;
            boolean bl2 = false;
            Path path4 = path3;
            void var17_12 = fs;
            boolean bl3 = false;
            AsarFileSystem asarFileSystem = new AsarFileSystem((Path)it);
            var17_12.element = asarFileSystem;
            String packageJson = "package.json";
            FileItem fileItem = ((AsarFileSystem)fs.element).getFile(packageJson);
            if (fileItem != null) {
                Collection files2;
                FileItem fileItem2 = fileItem;
                bl2 = false;
                boolean bl4 = false;
                FileItem fileItem3 = fileItem2;
                boolean bl5 = false;
                GlobalSearchScope globalSearchScope = ProjectScope.getContentScope((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"ProjectScope.getContentScope(project)");
                GlobalSearchScope scope = globalSearchScope;
                boolean $i$f$runReadAction = false;
                Object object = ApplicationManager.getApplication().runReadAction(new Computable(scope, project, packageJson, (Ref.ObjectRef)fs){
                    final /* synthetic */ GlobalSearchScope $scope$inlined;
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ String $packageJson$inlined;
                    final /* synthetic */ Ref.ObjectRef $fs$inlined;
                    {
                        this.$scope$inlined = globalSearchScope;
                        this.$project$inlined = project;
                        this.$packageJson$inlined = string;
                        this.$fs$inlined = objectRef;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)FilenameIndex.getVirtualFilesByName((String)this.$packageJson$inlined, (GlobalSearchScope)this.$scope$inlined);
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction { Filename\u2026ame(packageJson, scope) }");
                Collection collection = files2 = (Collection)object;
                boolean bl6 = false;
                if (!collection.isEmpty()) {
                    VirtualFile virtualFile = FileResolverByContentKt.selectMostSimilarFile$default(files2, ((AsarFileSystem)fs.element).loadText(fileItem3), null, 4, null);
                    if (virtualFile != null) {
                        collection = virtualFile;
                        bl6 = false;
                        boolean bl7 = false;
                        Collection it2 = collection;
                        boolean bl8 = false;
                        ((AsarFileSystem)fs.element).setVfsRoot(it2.getParent());
                    }
                }
            }
            AsarFileSystem asarFileSystem2 = this.pathToAsarFs.putIfAbsent(path, (AsarFileSystem)fs.element);
            if (asarFileSystem2 != null) {
                AsarFileSystem asarFileSystem3 = asarFileSystem2;
                bl2 = false;
                boolean bl9 = false;
                AsarFileSystem it3 = asarFileSystem3;
                boolean bl10 = false;
                return it3;
            }
        }
        return (AsarFileSystem)fs.element;
    }
}

