/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.EdgeRealizerProvider;
import com.intellij.openapi.graph.GraphLayoutOrientation;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.hierarchic.HierarchicGroupLayouter;
import com.intellij.openapi.graph.services.GraphEdgeRealizerService;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import java.util.Objects;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
public final class GraphSettings {
    @NotNull
    public static final String USE_SNAPPING_REGKEY = "diagrams.use.snapping";
    @NotNull
    private volatile Layouter myCurrentLayouter;
    @NotNull
    private volatile GraphLayoutOrientation myCurrentLayoutOrientation;
    @NotNull
    private volatile EdgeRealizerProvider myCurrentEdgeRealizerProvider;
    private volatile boolean myDoFitContentAfterLayout;
    private volatile boolean myDoShowEdgeLabels;
    private volatile boolean myDoShowBridges;
    private volatile boolean myDoMergeEdgeBySources;
    private volatile boolean myDoMergeEdgeByTargets;
    @NotNull
    private final EventDispatcher<ChangeListener> myDispatcher;

    public GraphSettings() {
        this.myCurrentLayouter = GraphLayoutService.getInstance().getHierarchicLayouter();
        this.myCurrentLayoutOrientation = GraphLayoutOrientation.BOTTOM_TO_TOP;
        this.myCurrentEdgeRealizerProvider = GraphEdgeRealizerService.getInstance().getSmoothedPolylineEdgeRealizerProvider();
        this.myDoFitContentAfterLayout = true;
        this.myDoShowEdgeLabels = true;
        this.myDoShowBridges = true;
        this.myDoMergeEdgeBySources = true;
        this.myDoMergeEdgeByTargets = true;
        this.myDispatcher = EventDispatcher.create(ChangeListener.class);
    }

    private GraphSettings(@NotNull Layouter currentLayouter, boolean doFitContentAfterLayout, boolean doShowEdgeLabels, boolean doShowBridges, boolean doMergeEdgeBySources, boolean doMergeEdgeByTargets) {
        if (currentLayouter == null) {
            GraphSettings.$$$reportNull$$$0(0);
        }
        this.myCurrentLayouter = GraphLayoutService.getInstance().getHierarchicLayouter();
        this.myCurrentLayoutOrientation = GraphLayoutOrientation.BOTTOM_TO_TOP;
        this.myCurrentEdgeRealizerProvider = GraphEdgeRealizerService.getInstance().getSmoothedPolylineEdgeRealizerProvider();
        this.myDoFitContentAfterLayout = true;
        this.myDoShowEdgeLabels = true;
        this.myDoShowBridges = true;
        this.myDoMergeEdgeBySources = true;
        this.myDoMergeEdgeByTargets = true;
        this.myDispatcher = EventDispatcher.create(ChangeListener.class);
        this.setFrom(currentLayouter, doFitContentAfterLayout, doShowEdgeLabels, doShowBridges, doMergeEdgeBySources, doMergeEdgeByTargets);
    }

    private GraphSettings(@NotNull GraphSettings that) {
        if (that == null) {
            GraphSettings.$$$reportNull$$$0(1);
        }
        this.myCurrentLayouter = GraphLayoutService.getInstance().getHierarchicLayouter();
        this.myCurrentLayoutOrientation = GraphLayoutOrientation.BOTTOM_TO_TOP;
        this.myCurrentEdgeRealizerProvider = GraphEdgeRealizerService.getInstance().getSmoothedPolylineEdgeRealizerProvider();
        this.myDoFitContentAfterLayout = true;
        this.myDoShowEdgeLabels = true;
        this.myDoShowBridges = true;
        this.myDoMergeEdgeBySources = true;
        this.myDoMergeEdgeByTargets = true;
        this.myDispatcher = EventDispatcher.create(ChangeListener.class);
        this.setFrom(that);
    }

    private void setFrom(@NotNull Layouter currentLayouter, boolean doFitContentAfterLayout, boolean doShowEdgeLabels, boolean doShowBridges, boolean doMergeEdgeBySources, boolean doMergeEdgeByTargets) {
        if (currentLayouter == null) {
            GraphSettings.$$$reportNull$$$0(2);
        }
        this.myCurrentLayouter = currentLayouter;
        this.myDoFitContentAfterLayout = doFitContentAfterLayout;
        this.myDoShowEdgeLabels = doShowEdgeLabels;
        this.myDoShowBridges = doShowBridges;
        this.myDoMergeEdgeBySources = doMergeEdgeBySources;
        this.myDoMergeEdgeByTargets = doMergeEdgeByTargets;
    }

    public void setFrom(@NotNull GraphSettings that) {
        if (that == null) {
            GraphSettings.$$$reportNull$$$0(3);
        }
        this.setFrom(that.myCurrentLayouter, that.myDoFitContentAfterLayout, that.myDoShowEdgeLabels, that.myDoShowBridges, that.myDoMergeEdgeBySources, that.myDoMergeEdgeByTargets);
    }

    @NotNull
    public GraphSettings copy() {
        return new GraphSettings(this);
    }

    public void addListener(@NotNull Disposable parent, @NotNull ChangeListener listener) {
        if (parent == null) {
            GraphSettings.$$$reportNull$$$0(4);
        }
        if (listener == null) {
            GraphSettings.$$$reportNull$$$0(5);
        }
        this.myDispatcher.addListener((EventListener)listener, parent);
    }

    private void fireSettingsChanged(@NotNull GraphSettings old) {
        if (old == null) {
            GraphSettings.$$$reportNull$$$0(6);
        }
        ((ChangeListener)this.myDispatcher.getMulticaster()).settingsChanged(old, this.copy());
    }

    @NotNull
    public Layouter getCurrentLayouter() {
        Layouter layouter = this.myCurrentLayouter;
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(7);
        }
        return layouter;
    }

    public void setCurrentLayouter(@NotNull Layouter currentLayouter) {
        if (currentLayouter == null) {
            GraphSettings.$$$reportNull$$$0(8);
        }
        GraphSettings old = this.copy();
        this.myCurrentLayouter = currentLayouter;
        this.fireSettingsChanged(old);
    }

    @NotNull
    public GraphLayoutOrientation getCurrentLayoutOrientation() {
        GraphLayoutOrientation graphLayoutOrientation = this.myCurrentLayoutOrientation;
        if (graphLayoutOrientation == null) {
            GraphSettings.$$$reportNull$$$0(9);
        }
        return graphLayoutOrientation;
    }

    public void setCurrentLayoutOrientation(@NotNull GraphLayoutOrientation currentLayoutOrientation) {
        if (currentLayoutOrientation == null) {
            GraphSettings.$$$reportNull$$$0(10);
        }
        GraphSettings old = this.copy();
        this.myCurrentLayoutOrientation = currentLayoutOrientation;
        this.fireSettingsChanged(old);
    }

    @NotNull
    public EdgeRealizerProvider getCurrentEdgeRealizerProvider() {
        EdgeRealizerProvider edgeRealizerProvider = this.myCurrentEdgeRealizerProvider;
        if (edgeRealizerProvider == null) {
            GraphSettings.$$$reportNull$$$0(11);
        }
        return edgeRealizerProvider;
    }

    public void setCurrentEdgeRealizerProvider(@NotNull EdgeRealizerProvider currentEdgeRealizerProvider) {
        if (currentEdgeRealizerProvider == null) {
            GraphSettings.$$$reportNull$$$0(12);
        }
        GraphSettings old = this.copy();
        this.myCurrentEdgeRealizerProvider = currentEdgeRealizerProvider;
        this.fireSettingsChanged(old);
    }

    public boolean isFitContentAfterLayout() {
        return this.myDoFitContentAfterLayout;
    }

    public void setFitContentAfterLayout(boolean fitContentAfterLayout) {
        GraphSettings old = this.copy();
        this.myDoFitContentAfterLayout = fitContentAfterLayout;
        this.fireSettingsChanged(old);
    }

    public boolean isShowEdgeLabels() {
        return this.myDoShowEdgeLabels;
    }

    public void setShowEdgeLabels(boolean showEdgeLabels) {
        GraphSettings old = this.copy();
        this.myDoShowEdgeLabels = showEdgeLabels;
        this.fireSettingsChanged(old);
    }

    public boolean isShowBridges() {
        return this.myDoShowBridges;
    }

    public void setShowBridges(boolean doShowBridges) {
        GraphSettings old = this.copy();
        this.myDoShowBridges = doShowBridges;
        this.fireSettingsChanged(old);
    }

    public boolean isMergeEdgeBySources() {
        return this.myDoMergeEdgeBySources;
    }

    public void setMergeEdgeBySources(boolean doMergeEdgeBySources) {
        GraphSettings old = this.copy();
        this.myDoMergeEdgeBySources = doMergeEdgeBySources;
        this.fireSettingsChanged(old);
    }

    public boolean isMergeEdgeByTargets() {
        return this.myDoMergeEdgeByTargets;
    }

    public void setMergeEdgeByTargets(boolean doMergeEdgeByTargets) {
        GraphSettings old = this.copy();
        this.myDoMergeEdgeByTargets = doMergeEdgeByTargets;
        this.fireSettingsChanged(old);
    }

    @Deprecated
    @NotNull
    public HierarchicGroupLayouter getGroupLayouter() {
        HierarchicGroupLayouter hierarchicGroupLayouter = GraphLayoutService.getInstance().getGroupLayouter();
        if (hierarchicGroupLayouter == null) {
            GraphSettings.$$$reportNull$$$0(13);
        }
        return hierarchicGroupLayouter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphSettings settings = (GraphSettings)o;
        return this.myDoFitContentAfterLayout == settings.myDoFitContentAfterLayout && this.myDoShowEdgeLabels == settings.myDoShowEdgeLabels && this.myDoShowBridges == settings.myDoShowBridges && this.myDoMergeEdgeBySources == settings.myDoMergeEdgeBySources && this.myDoMergeEdgeByTargets == settings.myDoMergeEdgeByTargets && this.myCurrentLayouter.equals(settings.myCurrentLayouter);
    }

    public int hashCode() {
        return Objects.hash(this.myCurrentLayouter, this.myDoFitContentAfterLayout, this.myDoShowEdgeLabels, this.myDoShowBridges, this.myDoMergeEdgeBySources, this.myDoMergeEdgeByTargets);
    }

    public String toString() {
        return "GraphSettings{myCurrentLayouter=" + this.myCurrentLayouter + ", myDoFitContentAfterLayout=" + this.myDoFitContentAfterLayout + ", myDoShowEdgeLabels=" + this.myDoShowEdgeLabels + ", myDoShowBridges=" + this.myDoShowBridges + ", myDoMergeEdgeBySources=" + this.myDoMergeEdgeBySources + ", myDoMergeEdgeByTargets=" + this.myDoMergeEdgeByTargets + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentLayouter";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "old";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/settings/GraphSettings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentLayoutOrientation";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentEdgeRealizerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/settings/GraphSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentLayouter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentLayoutOrientation";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentEdgeRealizerProvider";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupLayouter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setFrom";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fireSettingsChanged";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentLayouter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentLayoutOrientation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentEdgeRealizerProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ChangeListener
    extends EventListener {
        public void settingsChanged(@NotNull GraphSettings var1, @NotNull GraphSettings var2);
    }
}

