/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.exasol;

import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.data.types.domain.TextLikeDomain;
import com.intellij.openapi.util.text.StringUtil;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;

public class ExaDomains
extends BaseDomainRegistry {
    private static final int MAX_CHAR = 2000;
    private static final int MAX_VARCHAR = 2000000;
    private static final int MAX_PRECISION = 36;
    private static final double BIGINT_MAX = ExaDomains.calculateMaxValue(36).doubleValue();
    private static final double INTEGER_MAX = ExaDomains.calculateMaxValue(18).doubleValue();
    private static final int SMALLINT_MAX = ExaDomains.calculateMaxValue(9).intValue();

    public ExaDomains() {
        this.add((Domain)new IntegerDomain("bigint", ConversionPoint.NUMBER, -BIGINT_MAX, BIGINT_MAX));
        this.add((Domain)new IntegerDomain("integer", ConversionPoint.NUMBER, -INTEGER_MAX, INTEGER_MAX));
        this.add((Domain)new IntegerDomain("smallint", ConversionPoint.NUMBER, (double)(-SMALLINT_MAX), (double)SMALLINT_MAX));
        this.add((Domain)new BooleanDomain("boolean", ConversionPoint.BOOLEAN));
        this.add((Domain)new TextDomain("char", ConversionPoint.CHAR, 2000L, 1L, true, false));
        this.add((Domain)new TextDomain("varchar", ConversionPoint.VARCHAR, 2000000L, TextDomain.Length.mandatory((long)2000000L, (boolean)true)));
        this.add(new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, 36, 36, true));
        this.add((Domain)new FloatDomain("double precision", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add((Domain)new FloatDomain("float", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add(new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 3, 3, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new FractionDomain("timestamp with local time zone", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 3, 3, false));
        this.add((Domain)new GeometryDomain());
        this.add((Domain)new IntervalDomain("interval day to second"));
        this.add((Domain)new IntervalDomain("interval year to month"));
        this.add((Domain)new IntervalDomain("interval year"));
        this.add((Domain)new IntervalDomain("interval day"));
    }

    @NotNull
    private static BigInteger calculateMaxValue(int precision) {
        BigInteger bigInteger = BigInteger.TEN.pow(precision).subtract(BigInteger.ONE);
        if (bigInteger == null) {
            ExaDomains.$$$reportNull$$$0(0);
        }
        return bigInteger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/exasol/ExaDomains", "calculateMaxValue"));
    }

    private static class IntervalDomain
    extends TextLikeDomain {
        protected IntervalDomain(@NotNull String name2) {
            if (name2 == null) {
                IntervalDomain.$$$reportNull$$$0(0);
            }
            super(name2, ConversionPoint.INTERVAL, PhysicalDomainType.TEXT);
            this.withOperationSupport(OperationSupport.SUPPORTS_LIKE);
        }

        @NotNull
        public Compatibility getCompatibility(@NotNull Domain domain) {
            if (domain == null) {
                IntervalDomain.$$$reportNull$$$0(1);
            }
            Compatibility compatibility = domain instanceof IntervalDomain && StringUtil.equals((CharSequence)domain.name(), (CharSequence)this.name()) ? Compatibility.full((Cardinality)this.cardinality(), (LogicalType)domain.getLogicType(), (LogicalType)this.getLogicType()) : super.getCompatibility(domain);
            if (compatibility == null) {
                IntervalDomain.$$$reportNull$$$0(2);
            }
            return compatibility;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domain";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/exasol/ExaDomains$IntervalDomain";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/exasol/ExaDomains$IntervalDomain";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompatibility";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getCompatibility";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class GeometryDomain
    extends TextLikeDomain {
        protected GeometryDomain() {
            super("geometry", ConversionPoint.GEOMETRY, PhysicalDomainType.TEXT);
            this.withOperationSupport(OperationSupport.SUPPORTS_LIKE_ONLY);
        }

        @NotNull
        public Compatibility getCompatibility(@NotNull Domain domain) {
            if (domain == null) {
                GeometryDomain.$$$reportNull$$$0(0);
            }
            Compatibility compatibility = domain instanceof GeometryDomain ? Compatibility.full((Cardinality)this.cardinality(), (LogicalType)domain.getLogicType(), (LogicalType)this.getLogicType()) : super.getCompatibility(domain);
            if (compatibility == null) {
                GeometryDomain.$$$reportNull$$$0(1);
            }
            return compatibility;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domain";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/exasol/ExaDomains$GeometryDomain";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/exasol/ExaDomains$GeometryDomain";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompatibility";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getCompatibility";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

